/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"UNIX_SEPARATOR", "", "WINDOWS_SEPARATOR", "getExtension", "", "fileName", "indexOfExtension", "", "indexOfLastSeparator", "Frontend"})
public final class FileExtKt {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    @Nullable
    public static final String getExtension(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        int index = FileExtKt.indexOfExtension(fileName);
        if (index == -1) {
            return null;
        }
        String string = fileName.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return string;
    }

    private static final int indexOfExtension(String fileName) {
        int extensionPos = StringsKt.lastIndexOf$default((CharSequence)fileName, '.', 0, false, 6, null);
        int lastSeparator = FileExtKt.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static final int indexOfLastSeparator(String fileName) {
        int lastUnixPos = StringsKt.lastIndexOf$default((CharSequence)fileName, '/', 0, false, 6, null);
        int lastWindowsPos = StringsKt.lastIndexOf$default((CharSequence)fileName, '\\', 0, false, 6, null);
        return Math.max(lastUnixPos, lastWindowsPos);
    }
}

