/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.models.windows;

import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.models.RdError;
import com.jetbrains.jdbc.base.models.RdFetchWindow;
import com.jetbrains.jdbc.base.models.RdGetResultSetRow;
import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.resultsets.models.FetchWindowMoveResult;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRowMetadata;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.string.IPrintable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\rH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\rH\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00101\u001a\u00020\rH\u0016J\b\u00103\u001a\u00020/H\u0016J\b\u00104\u001a\u00020/H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u001cH\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001a\u001a\"\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bj\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u001c`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/models/windows/FetchWindow;", "Lcom/jetbrains/jdbc/base/resultsets/models/windows/IFetchWindow;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "rdResultSet", "Lcom/jetbrains/jdbc/base/models/RdResultSet;", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;Lcom/jetbrains/jdbc/base/models/RdResultSet;)V", "awaitedRowArrivedOrNoMoreRows", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "awaitedRowPosition", "", "Ljava/lang/Integer;", "currentRow", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;", "getCurrentRow", "()Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;", "setCurrentRow", "(Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;)V", "failed", "Lcom/jetbrains/jdbc/base/models/RdError;", "lastReceivedRowNumber", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "map", "Ljava/util/HashMap;", "Lcom/jetbrains/jdbc/base/models/RdGetResultSetRow;", "Lkotlin/collections/HashMap;", "metadata", "Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowMetadata;", "<set-?>", "position", "getPosition", "()I", "rdFetchWindow", "Lcom/jetbrains/jdbc/base/models/RdFetchWindow;", "getRdFetchWindow", "()Lcom/jetbrains/jdbc/base/models/RdFetchWindow;", "close", "", "getOrWait", "getValue", "isFinished", "", "last", "Lcom/jetbrains/jdbc/base/resultsets/models/FetchWindowMoveResult;", "moveBackward", "steps", "moveForward", "next", "previous", "waitForLast", "Frontend"})
@SourceDebugExtension(value={"SMAP\nFetchWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchWindow.kt\ncom/jetbrains/jdbc/base/resultsets/models/windows/FetchWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
public final class FetchWindow
implements IFetchWindow {
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final IRowsAndColumnsFactory rowsAndColumnsFactory;
    @NotNull
    private final RdResultSet rdResultSet;
    @NotNull
    private final ReentrantLock lock;
    private final Condition awaitedRowArrivedOrNoMoreRows;
    @Nullable
    private Integer awaitedRowPosition;
    @NotNull
    private final ResultSetRowMetadata metadata;
    private int lastReceivedRowNumber;
    @Nullable
    private RdError failed;
    @NotNull
    private final HashMap<Integer, RdGetResultSetRow> map;
    private int position;
    @Nullable
    private IResultSetRow currentRow;

    public FetchWindow(@NotNull LifetimeDefinition lifetimeDefinition, @NotNull IRowsAndColumnsFactory rowsAndColumnsFactory, @NotNull RdResultSet rdResultSet) {
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(rowsAndColumnsFactory, "rowsAndColumnsFactory");
        Intrinsics.checkNotNullParameter(rdResultSet, "rdResultSet");
        this.lifetimeDefinition = lifetimeDefinition;
        this.rowsAndColumnsFactory = rowsAndColumnsFactory;
        this.rdResultSet = rdResultSet;
        this.lock = new ReentrantLock();
        this.awaitedRowArrivedOrNoMoreRows = this.lock.newCondition();
        this.metadata = new ResultSetRowMetadata(InterfacesKt.getValueOrThrow(this.rdResultSet.getMetadata()));
        this.map = new HashMap();
        ProtocolUtilsKt.queueAndWait(JdbcModelExtKt.getScheduler(this.rdResultSet), (Function0)new Function0<Unit>(){

            @Override
            public final void invoke() {
                rdResultSet.getFetchWindow().set(new RdFetchWindow());
                lifetimeDefinition.onTermination(new Function0<Unit>(){

                    @Override
                    public final void invoke() {
                        JdbcModelExtKt.getScheduler(this.getRdFetchWindow()).invokeOrQueue(new Function0<Unit>(){

                            @Override
                            public final void invoke() {
                                this.getRdFetchWindow().getAbort().fire(Unit.INSTANCE);
                                rdResultSet.getFetchWindow().set(null);
                            }
                        });
                    }
                });
                this.getRdFetchWindow().getFinished().advise(lifetimeDefinition, new Function1<Boolean, Unit>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void invoke(boolean it) {
                        lock.lock();
                        try {
                            if (it) {
                                awaitedRowArrivedOrNoMoreRows.signal();
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                this.getRdFetchWindow().getRowReceived().advise(lifetimeDefinition, new Function1<RdGetResultSetRow[], Unit>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void invoke(@NotNull RdGetResultSetRow[] value2) {
                        Intrinsics.checkNotNullParameter(value2, "value");
                        lock.lock();
                        try {
                            for (RdGetResultSetRow v : value2) {
                                Map map2 = map;
                                FetchWindow fetchWindow = this;
                                int n = fetchWindow.lastReceivedRowNumber;
                                fetchWindow.lastReceivedRowNumber = n + 1;
                                map2.put(n, v);
                                Integer n2 = awaitedRowPosition;
                                if (n2 == null || lastReceivedRowNumber != n2) continue;
                                awaitedRowArrivedOrNoMoreRows.signal();
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                this.getRdFetchWindow().getFailed().advise(lifetimeDefinition, new Function1<RdError, Unit>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void invoke(@NotNull RdError value2) {
                        Intrinsics.checkNotNullParameter(value2, "value");
                        lock.lock();
                        try {
                            failed = value2;
                            awaitedRowArrivedOrNoMoreRows.signal();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
            }
        });
    }

    private final RdFetchWindow getRdFetchWindow() {
        RdFetchWindow rdFetchWindow = this.rdResultSet.getFetchWindow().getValue();
        if (rdFetchWindow == null) {
            throw ExceptionsKt.fetchWindowIsClosed();
        }
        return rdFetchWindow;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public IResultSetRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(@Nullable IResultSetRow iResultSetRow) {
        this.currentRow = iResultSetRow;
    }

    @Override
    public void close() {
        LifetimeDefinition.terminate$default(this.lifetimeDefinition, false, 1, null);
    }

    @Override
    @NotNull
    public FetchWindowMoveResult previous() {
        return this.moveBackward(-1);
    }

    @Override
    @NotNull
    public FetchWindowMoveResult next() {
        return this.moveForward(1);
    }

    @Override
    @NotNull
    public FetchWindowMoveResult last() {
        FetchWindowMoveResult fetchWindowMoveResult;
        RdGetResultSetRow response = this.waitForLast();
        if (response == null) {
            this.position = 0;
            this.setCurrentRow(null);
            fetchWindowMoveResult = FetchWindowMoveResult.Companion.couldNotReach(1);
        } else {
            this.position = this.map.size();
            this.setCurrentRow(this.rowsAndColumnsFactory.createResultSetRow(this.getPosition(), response, this.metadata));
            fetchWindowMoveResult = FetchWindowMoveResult.Companion.reached();
        }
        return fetchWindowMoveResult;
    }

    @Override
    @NotNull
    public FetchWindowMoveResult moveForward(int steps) {
        int target = this.getPosition() + steps;
        RdGetResultSetRow response = this.getOrWait(target);
        if (response == null) {
            this.position = 0;
            this.setCurrentRow(null);
            return FetchWindowMoveResult.Companion.couldNotReach(target - this.map.size());
        }
        this.position = target;
        this.setCurrentRow(this.rowsAndColumnsFactory.createResultSetRow(target, response, this.metadata));
        return FetchWindowMoveResult.Companion.reached();
    }

    @Override
    @NotNull
    public FetchWindowMoveResult moveBackward(int steps) {
        int target = this.getPosition() + steps;
        if (target <= 0) {
            this.position = 0;
            this.setCurrentRow(null);
            return FetchWindowMoveResult.Companion.couldNotReach(target - 1);
        }
        this.position = target;
        RdGetResultSetRow rdGetResultSetRow = this.getOrWait(target);
        Intrinsics.checkNotNull(rdGetResultSetRow);
        this.setCurrentRow(this.rowsAndColumnsFactory.createResultSetRow(target, rdGetResultSetRow, this.metadata));
        return FetchWindowMoveResult.Companion.reached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RdGetResultSetRow getOrWait(int position) {
        this.lock.lock();
        try {
            while (true) {
                RdGetResultSetRow row = this.getValue(position);
                IPrintable iPrintable = this.failed;
                if (iPrintable != null) {
                    RdError it = iPrintable;
                    boolean bl = false;
                    throw ExceptionsKt.toException(it);
                }
                if (row != null) {
                    this.awaitedRowPosition = null;
                    iPrintable = row;
                    return iPrintable;
                }
                if (this.isFinished()) {
                    this.awaitedRowPosition = null;
                    iPrintable = null;
                    return iPrintable;
                }
                this.awaitedRowPosition = position;
                this.awaitedRowArrivedOrNoMoreRows.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RdGetResultSetRow waitForLast() {
        this.lock.lock();
        try {
            while (!this.isFinished()) {
                this.awaitedRowArrivedOrNoMoreRows.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.map.isEmpty() ? null : this.map.get(this.map.size() - 1);
    }

    private final RdGetResultSetRow getValue(int position) {
        return this.map.get(position - 1);
    }

    private final boolean isFinished() {
        return this.getRdFetchWindow().getFinished().getValue();
    }
}

