/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.models;

import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.models.RdGetResultSetColumn;
import com.jetbrains.jdbc.base.models.RdGetResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetColumn;
import com.jetbrains.jdbc.base.resultsets.models.IResultSetRow;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRowMetadata;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRowStatus;
import com.jetbrains.jdbc.base.utils.FlagsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.translators.TranslatorsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\r2\n\u0010\u0017\u001a\u00060\u0003j\u0002`\u0018H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0003j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRow;", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetRow;", "positionInBatch", "", "row", "Lcom/jetbrains/jdbc/base/models/RdGetResultSetRow;", "metadata", "Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowMetadata;", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "(ILcom/jetbrains/jdbc/base/models/RdGetResultSetRow;Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowMetadata;Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;)V", "columns", "", "Lcom/jetbrains/jdbc/base/resultsets/models/IResultSetColumn;", "getColumns", "()Ljava/util/List;", "getPositionInBatch", "()I", "status", "Lcom/jetbrains/jdbc/base/utils/Flags;", "clearPendingValues", "", "getColumn", "index", "Lcom/jetbrains/jdbc/base/OneBasedIndex;", "name", "", "isDeleted", "", "isInserted", "isUpdated", "markAsDeleted", "markAsNeedsRefresh", "markAsRefreshed", "needsRefresh", "Frontend"})
@SourceDebugExtension(value={"SMAP\nResultSetRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResultSetRow.kt\ncom/jetbrains/jdbc/base/resultsets/models/ResultSetRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n*S KotlinDebug\n*F\n+ 1 ResultSetRow.kt\ncom/jetbrains/jdbc/base/resultsets/models/ResultSetRow\n*L\n19#1:83\n19#1:84,3\n*E\n"})
public final class ResultSetRow
implements IResultSetRow {
    private final int positionInBatch;
    @NotNull
    private final ResultSetRowMetadata metadata;
    @NotNull
    private final IRowsAndColumnsFactory rowsAndColumnsFactory;
    @NotNull
    private final List<IResultSetColumn> columns;
    private int status;

    /*
     * WARNING - void declaration
     */
    public ResultSetRow(int positionInBatch, @NotNull RdGetResultSetRow row, @NotNull ResultSetRowMetadata metadata2, @NotNull IRowsAndColumnsFactory rowsAndColumnsFactory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(row, "row");
        Intrinsics.checkNotNullParameter(metadata2, "metadata");
        Intrinsics.checkNotNullParameter(rowsAndColumnsFactory, "rowsAndColumnsFactory");
        this.positionInBatch = positionInBatch;
        this.metadata = metadata2;
        this.rowsAndColumnsFactory = rowsAndColumnsFactory;
        Iterable iterable = row.getColumns();
        ResultSetRow resultSetRow = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void column;
            RdGetResultSetColumn rdGetResultSetColumn = (RdGetResultSetColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.rowsAndColumnsFactory.createResultSetColumn((RdGetResultSetColumn)column));
        }
        resultSetRow.columns = (List)destination$iv$iv;
        this.status = TranslatorsKt.toModel(row.getStatus()).getValue();
    }

    @Override
    public int getPositionInBatch() {
        return this.positionInBatch;
    }

    @Override
    @NotNull
    public List<IResultSetColumn> getColumns() {
        return this.columns;
    }

    @Override
    public void clearPendingValues() {
        for (IResultSetColumn column : this.getColumns()) {
            column.clearPendingValue();
        }
    }

    @Override
    public void markAsNeedsRefresh() {
        this.clearPendingValues();
        this.status = FlagsKt.setFlag(this.status, ResultSetRowStatus.NeedsRefresh);
    }

    @Override
    public void markAsRefreshed() {
        this.clearPendingValues();
        this.status = FlagsKt.setFlag(this.status, ResultSetRowStatus.Untouched);
        this.status = FlagsKt.removeFlag(this.status, ResultSetRowStatus.NeedsRefresh);
    }

    @Override
    public void markAsDeleted() {
        this.clearPendingValues();
        this.status = FlagsKt.setFlag(this.status, ResultSetRowStatus.Deleted);
        this.status = FlagsKt.removeFlag(this.status, ResultSetRowStatus.NeedsRefresh);
    }

    @Override
    public boolean isDeleted() {
        return FlagsKt.hasFlag(this.status, ResultSetRowStatus.Deleted);
    }

    @Override
    public boolean isUpdated() {
        return FlagsKt.hasFlag(this.status, ResultSetRowStatus.Updated);
    }

    @Override
    public boolean isInserted() {
        return FlagsKt.hasFlag(this.status, ResultSetRowStatus.Inserted);
    }

    @Override
    public boolean needsRefresh() {
        return FlagsKt.hasFlag(this.status, ResultSetRowStatus.NeedsRefresh);
    }

    @Override
    @NotNull
    public IResultSetColumn getColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        int index = this.metadata.getColumnIndex(name);
        if (index == -1) {
            throw ExceptionsKt.columnNotFound(name);
        }
        return this.getColumns().get(index);
    }

    @Override
    @NotNull
    public IResultSetColumn getColumn(int index) {
        if (index - 1 >= this.getColumns().size()) {
            throw ExceptionsKt.columnNotFound(index);
        }
        return this.getColumns().get(index - 1);
    }
}

