/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors;

import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.models.RdDeleteRowRequest;
import com.jetbrains.jdbc.base.models.RdInsertRowRequest;
import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.models.RdResultSetColumnMetadata;
import com.jetbrains.jdbc.base.models.RdUpdateRowRequest;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.models.windows.EmptyFetchWindow;
import com.jetbrains.jdbc.base.resultsets.models.windows.FetchWindow;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.RdResultSetExtKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\"H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/RemoteCursor;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "rdResultSet", "Lcom/jetbrains/jdbc/base/models/RdResultSet;", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "resultSetLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/jdbc/base/models/RdResultSet;Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "previousFetchWindow", "Lcom/jetbrains/jdbc/base/resultsets/models/windows/IFetchWindow;", "deleteRow", "", "request", "Lcom/jetbrains/jdbc/base/models/RdDeleteRowRequest;", "fetchAbsolute", "rowPosition", "", "fetchAfterLast", "fetchBackward", "stepsToScroll", "fetchBeforeFirst", "fetchFirst", "fetchForward", "fetchLast", "fetchNext", "fetchRefresh", "getMetadata", "", "Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;", "()[Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;", "insertRow", "Lcom/jetbrains/jdbc/base/models/RdInsertRowRequest;", "updateRow", "Lcom/jetbrains/jdbc/base/models/RdUpdateRowRequest;", "Frontend"})
public final class RemoteCursor
implements IRemoteCursor {
    @NotNull
    private final RdResultSet rdResultSet;
    @NotNull
    private final IRowsAndColumnsFactory rowsAndColumnsFactory;
    @NotNull
    private final Lifetime resultSetLifetime;
    @Nullable
    private IFetchWindow previousFetchWindow;

    public RemoteCursor(@NotNull RdResultSet rdResultSet, @NotNull IRowsAndColumnsFactory rowsAndColumnsFactory, @NotNull Lifetime resultSetLifetime) {
        Intrinsics.checkNotNullParameter(rdResultSet, "rdResultSet");
        Intrinsics.checkNotNullParameter(rowsAndColumnsFactory, "rowsAndColumnsFactory");
        Intrinsics.checkNotNullParameter(resultSetLifetime, "resultSetLifetime");
        this.rdResultSet = rdResultSet;
        this.rowsAndColumnsFactory = rowsAndColumnsFactory;
        this.resultSetLifetime = resultSetLifetime;
    }

    @Override
    @NotNull
    public IFetchWindow fetchFirst() {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getFirst(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchLast() {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getLast(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchForward(int stepsToScroll) {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getRelative(), stepsToScroll, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchBackward(int stepsToScroll) {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getRelative(), stepsToScroll, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchNext() {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getNext(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchAbsolute(int rowPosition) {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getAbsolute(), rowPosition, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchRefresh() {
        FetchWindow fetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        FetchWindow it = fetchWindow = new FetchWindow(this.resultSetLifetime.createNested(), this.rowsAndColumnsFactory, this.rdResultSet);
        boolean bl = false;
        ProtocolUtilsKt.fireOnScheduler(this.rdResultSet.getRefreshRow(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        this.previousFetchWindow = it;
        return fetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchBeforeFirst() {
        EmptyFetchWindow emptyFetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        ProtocolUtilsKt.syncOnScheduler(this.rdResultSet.getBeforeFirst(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        EmptyFetchWindow it = emptyFetchWindow = new EmptyFetchWindow();
        boolean bl = false;
        this.previousFetchWindow = it;
        return emptyFetchWindow;
    }

    @Override
    @NotNull
    public IFetchWindow fetchAfterLast() {
        EmptyFetchWindow emptyFetchWindow;
        IFetchWindow iFetchWindow = this.previousFetchWindow;
        if (iFetchWindow != null) {
            iFetchWindow.close();
        }
        ProtocolUtilsKt.syncOnScheduler(this.rdResultSet.getAfterLast(), Unit.INSTANCE, JdbcModelExtKt.getScheduler(this.rdResultSet));
        EmptyFetchWindow it = emptyFetchWindow = new EmptyFetchWindow();
        boolean bl = false;
        this.previousFetchWindow = it;
        return emptyFetchWindow;
    }

    @Override
    public void insertRow(@NotNull RdInsertRowRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        RdResultSetExtKt.insertRow(this.rdResultSet, this.resultSetLifetime, request);
    }

    @Override
    public void updateRow(@NotNull RdUpdateRowRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        RdResultSetExtKt.updateRow(this.rdResultSet, this.resultSetLifetime, request);
    }

    @Override
    public void deleteRow(@NotNull RdDeleteRowRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        RdResultSetExtKt.deleteRow(this.rdResultSet, this.resultSetLifetime, request);
    }

    @Override
    @NotNull
    public RdResultSetColumnMetadata[] getMetadata() {
        return InterfacesKt.getValueOrThrow(this.rdResultSet.getMetadata());
    }
}

