/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets;

import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.models.RdResultSetColumnMetadata;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToJavaTypeTranslator;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToNativeTypeTranslator;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0014\u0010\u0012\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0014\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0015\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0016\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0017\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0018\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0019\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001a\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001d\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001e\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u001f\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010 \u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010!\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\"\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010#\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0016\u0010$\u001a\u00020\u001c2\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010&H\u0016J\u0014\u0010'\u001a\u00020\u001c2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J%\u0010(\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H)\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/ProtocolResultSetMetaData;", "Ljava/sql/ResultSetMetaData;", "remoteResultSet", "Lcom/jetbrains/jdbc/base/models/RdResultSet;", "nativeTypeTranslator", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;", "javaTypeTranslator", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToJavaTypeTranslator;", "(Lcom/jetbrains/jdbc/base/models/RdResultSet;Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToJavaTypeTranslator;)V", "getCatalogName", "", "columnIndex", "", "Lcom/jetbrains/jdbc/base/OneBasedIndex;", "getColumn", "Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;", "getColumnClassName", "getColumnCount", "getColumnDisplaySize", "getColumnLabel", "getColumnName", "getColumnType", "getColumnTypeName", "getPrecision", "getScale", "getSchemaName", "getTableName", "isAutoIncrement", "", "isCaseSensitive", "isCurrency", "isDefinitelyWritable", "isNullable", "isReadOnly", "isSearchable", "isSigned", "isWrapperFor", "iface", "Ljava/lang/Class;", "isWritable", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "Frontend"})
public final class ProtocolResultSetMetaData
implements ResultSetMetaData {
    @NotNull
    private final RdResultSet remoteResultSet;
    @NotNull
    private final IJdbcToNativeTypeTranslator nativeTypeTranslator;
    @NotNull
    private final IJdbcToJavaTypeTranslator javaTypeTranslator;

    public ProtocolResultSetMetaData(@NotNull RdResultSet remoteResultSet, @NotNull IJdbcToNativeTypeTranslator nativeTypeTranslator, @NotNull IJdbcToJavaTypeTranslator javaTypeTranslator) {
        Intrinsics.checkNotNullParameter(remoteResultSet, "remoteResultSet");
        Intrinsics.checkNotNullParameter(nativeTypeTranslator, "nativeTypeTranslator");
        Intrinsics.checkNotNullParameter(javaTypeTranslator, "javaTypeTranslator");
        this.remoteResultSet = remoteResultSet;
        this.nativeTypeTranslator = nativeTypeTranslator;
        this.javaTypeTranslator = javaTypeTranslator;
    }

    @Override
    @Nullable
    public <T> T unwrap(@Nullable Class<T> iface) {
        T t = null;
        if (iface == null) {
            return t;
        }
        try {
            iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage());
        }
        return t;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        Class<?> clazz = iface;
        return clazz != null ? clazz.isInstance(this) : false;
    }

    @Override
    public int getColumnCount() {
        return ((Object[])InterfacesKt.getValueOrThrow(this.remoteResultSet.getMetadata())).length;
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isSearchable();
    }

    @Override
    public boolean isCurrency(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isCurrency();
    }

    @Override
    public int isNullable(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        if (column.isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isSigned();
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.getDisplaySize();
    }

    @Override
    @Nullable
    public String getColumnLabel(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.getLabel();
    }

    @Override
    @NotNull
    public String getColumnName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.getName();
    }

    @Override
    @NotNull
    public String getSchemaName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        String string = column.getSchema();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getPrecision(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        Integer n = column.getPrecision();
        return n != null ? n : 0;
    }

    @Override
    public int getScale(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        Integer n = column.getScale();
        return n != null ? n : 0;
    }

    @Override
    @NotNull
    public String getTableName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        String string = column.getTable();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getCatalogName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        String string = column.getCatalog();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public int getColumnType(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        Integer n = this.nativeTypeTranslator.fromNativeToJdbc(column.getSqlType()).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "nativeTypeTranslator.fro\u2026sqlType).vendorTypeNumber");
        return ((Number)n).intValue();
    }

    @Override
    @NotNull
    public String getColumnTypeName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.getTypeName();
    }

    @Override
    public boolean isReadOnly(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isReadonly();
    }

    @Override
    public boolean isWritable(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isWritable();
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return column.isDefinitelyWritable();
    }

    @Override
    @NotNull
    public String getColumnClassName(int columnIndex) {
        RdResultSetColumnMetadata column = this.getColumn(columnIndex);
        return this.javaTypeTranslator.fromNativeToJava(column.getSqlType());
    }

    private final RdResultSetColumnMetadata getColumn(int columnIndex) {
        return InterfacesKt.getValueOrThrow(this.remoteResultSet.getMetadata())[columnIndex - 1];
    }
}

