/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql.xml.apis;

import com.jetbrains.jdbc.base.models.sql.xml.XmlResult;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlResultGetter;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlSourceGetter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/apis/DOM;", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlSourceGetter;", "Ljavax/xml/transform/dom/DOMSource;", "Lcom/jetbrains/jdbc/base/models/sql/xml/apis/interfaces/XmlResultGetter;", "Ljavax/xml/transform/dom/DOMResult;", "()V", "getResult", "Lcom/jetbrains/jdbc/base/models/sql/xml/XmlResult;", "getSource", "value", "", "SqlServerEntityResolver", "Frontend"})
public final class DOM
implements XmlSourceGetter<DOMSource>,
XmlResultGetter<DOMResult> {
    @Override
    @NotNull
    public XmlResult<DOMResult> getResult() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue(documentBuilder, "factory.newDocumentBuilder()");
            builder = documentBuilder;
            Document docValue = builder.newDocument();
            DOMResult dOMResult = new DOMResult(docValue);
            Intrinsics.checkNotNullExpressionValue(docValue, "docValue");
            return new XmlResult<DOMResult>(dOMResult, docValue);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionsKt.cantInstantiateParser(e.toString());
        }
    }

    @Override
    @NotNull
    public DOMSource getSource(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue(documentBuilder, "factory.newDocumentBuilder()");
            builder = documentBuilder;
            builder.setEntityResolver(new SqlServerEntityResolver());
            try {
                document = builder.parse(new InputSource(new StringReader(value2)));
            }
            catch (IOException e) {
                throw new Exception();
            }
            return new DOMSource(document);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionsKt.cantInstantiateParser(e.toString());
        }
        catch (SAXException e) {
            String string = e.toString();
            Intrinsics.checkNotNullExpressionValue(string, "e.toString()");
            throw ExceptionsKt.failedToParseXml(string);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/apis/DOM$SqlServerEntityResolver;", "Lorg/xml/sax/EntityResolver;", "()V", "resolveEntity", "Lorg/xml/sax/InputSource;", "publicId", "", "systemId", "Frontend"})
    public static final class SqlServerEntityResolver
    implements EntityResolver {
        @Override
        @NotNull
        public InputSource resolveEntity(@NotNull String publicId, @NotNull String systemId) {
            Intrinsics.checkNotNullParameter(publicId, "publicId");
            Intrinsics.checkNotNullParameter(systemId, "systemId");
            return new InputSource(new StringReader(""));
        }
    }
}

