/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql;

import com.jetbrains.jdbc.base.models.sql.ClobWriter;
import com.jetbrains.jdbc.base.models.sql.SQLServerClobAsciiOutputStream;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015J\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003J&\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015J\b\u0010\"\u001a\u00020\fH\u0002J\u000e\u0010#\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0012R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryClobBase;", "", "str", "", "(Ljava/lang/String;)V", "activeStreams", "Ljava/util/ArrayList;", "Ljava/io/Closeable;", "Lkotlin/collections/ArrayList;", "isClosed", "", "free", "", "getAsciiStream", "Ljava/io/InputStream;", "getCharacterStream", "Ljava/io/Reader;", "pos", "", "length", "getSubString", "", "position", "searchstr", "Ljava/sql/Clob;", "start", "setAsciiStream", "Ljava/io/OutputStream;", "setCharacterStream", "Ljava/io/Writer;", "setString", "stringToSet", "offset", "len", "throwIfClosed", "truncate", "Frontend"})
public class ProtocolInMemoryClobBase {
    @NotNull
    private String str;
    private boolean isClosed;
    @NotNull
    private final ArrayList<Closeable> activeStreams;

    public ProtocolInMemoryClobBase(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        this.str = str;
        this.activeStreams = new ArrayList();
    }

    public final long length() {
        this.throwIfClosed();
        return this.str.length();
    }

    @NotNull
    public final String getSubString(long pos, int length) {
        this.throwIfClosed();
        if (pos < 1L) {
            throw ExceptionsKt.invalidStreamPosition(pos);
        }
        if (length < 0) {
            throw ExceptionsKt.invalidStreamLength(length);
        }
        long startPosition = pos - 1L;
        int substringLength = length;
        if (startPosition > (long)this.str.length()) {
            startPosition = this.str.length();
        }
        if ((long)substringLength > (long)this.str.length() - startPosition) {
            substringLength = (int)((long)this.str.length() - startPosition);
        }
        String string = this.str.substring((int)startPosition, (int)startPosition + substringLength);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @NotNull
    public final Reader getCharacterStream() {
        this.throwIfClosed();
        StringReader reader = new StringReader(this.str);
        this.activeStreams.add(reader);
        return reader;
    }

    @NotNull
    public final Reader getCharacterStream(long pos, long length) {
        this.throwIfClosed();
        String substring = this.getSubString(pos, (int)length);
        StringReader reader = new StringReader(substring);
        this.activeStreams.add(reader);
        return reader;
    }

    @NotNull
    public final InputStream getAsciiStream() {
        this.throwIfClosed();
        String string = this.str;
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        ByteArrayInputStream stream = new ByteArrayInputStream(byArray);
        this.activeStreams.add(stream);
        return stream;
    }

    public final long position(@NotNull String searchstr, long start2) {
        Intrinsics.checkNotNullParameter(searchstr, "searchstr");
        this.throwIfClosed();
        if (start2 < 1L) {
            throw ExceptionsKt.invalidStreamPosition(start2);
        }
        int pos = StringsKt.indexOf$default((CharSequence)this.str, searchstr, (int)(start2 - 1L), false, 4, null);
        return pos != -1 ? (long)pos + 1L : -1L;
    }

    public final long position(@NotNull Clob searchstr, long start2) {
        Intrinsics.checkNotNullParameter(searchstr, "searchstr");
        this.throwIfClosed();
        String string = searchstr.getSubString(1L, (int)searchstr.length());
        Intrinsics.checkNotNullExpressionValue(string, "searchstr.getSubString(1\u2026archstr.length().toInt())");
        return this.position(string, start2);
    }

    public final int setString(long pos, @NotNull String stringToSet) {
        Intrinsics.checkNotNullParameter(stringToSet, "stringToSet");
        this.throwIfClosed();
        return this.setString(pos, stringToSet, 0, this.str.length());
    }

    public final int setString(long pos, @NotNull String stringToSet, int offset, int len) {
        Intrinsics.checkNotNullParameter(stringToSet, "stringToSet");
        this.throwIfClosed();
        if (offset < 0 || offset > stringToSet.length()) {
            throw ExceptionsKt.invalidStreamOffset(len);
        }
        if (len < 0 || len > stringToSet.length() - offset) {
            throw ExceptionsKt.invalidStreamLength(len);
        }
        if (pos <= 0L || pos > (long)(stringToSet.length() + 1)) {
            throw ExceptionsKt.invalidStreamPosition(len);
        }
        long position = pos - 1L;
        if ((long)len >= (long)this.str.length() - position) {
            StringBuilder sb = new StringBuilder((int)pos + len);
            String string = this.str.substring(0, (int)pos);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            sb.append(string);
            String string2 = stringToSet.substring(offset, offset + len);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            sb.append(string2);
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "sb.toString()");
            this.str = string3;
        } else {
            StringBuilder sb = new StringBuilder(this.str.length());
            String string = this.str.substring(0, (int)pos);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            sb.append(string);
            String string4 = stringToSet.substring(offset, offset + len);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            sb.append(string4);
            String string5 = this.str.substring((int)pos + len);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            sb.append(string5);
            String string6 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string6, "sb.toString()");
            this.str = string6;
        }
        return len;
    }

    @NotNull
    public final OutputStream setAsciiStream(long pos) {
        this.throwIfClosed();
        if (pos < 1L) {
            throw ExceptionsKt.invalidStreamPosition(pos);
        }
        return new SQLServerClobAsciiOutputStream(this, pos);
    }

    @NotNull
    public final Writer setCharacterStream(long pos) {
        this.throwIfClosed();
        if (pos < 1L) {
            throw ExceptionsKt.invalidStreamPosition(pos);
        }
        return new ClobWriter(this, pos);
    }

    public final void truncate(long len) {
        this.throwIfClosed();
        if (len < 0L) {
            throw ExceptionsKt.invalidStreamLength(len);
        }
        if ((long)this.str.length() > len && len <= Integer.MAX_VALUE) {
            String string = this.str.substring(0, (int)len);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            this.str = string;
        }
    }

    public final void free() {
        if (this.isClosed) {
            return;
        }
        for (Closeable stream : this.activeStreams) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        this.activeStreams.clear();
        this.isClosed = true;
    }

    private final void throwIfClosed() {
        if (this.isClosed) {
            throw ExceptionsKt.blobClosed();
        }
    }
}

