/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql;

import com.jetbrains.jdbc.base.models.sql.SqlServerBlobOutputStream;
import com.jetbrains.jdbc.base.utils.SearchUtilsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J(\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryBlob;", "Ljava/sql/Blob;", "bytes", "", "([B)V", "activeStreams", "Ljava/util/ArrayList;", "Ljava/io/InputStream;", "Lkotlin/collections/ArrayList;", "isClosed", "", "free", "", "getBinaryStream", "pos", "", "length", "getBytes", "", "position", "pattern", "start", "setBinaryStream", "Ljava/io/OutputStream;", "setBytes", "bytesToSet", "offset", "len", "throwIfClosed", "truncate", "Frontend"})
public final class ProtocolInMemoryBlob
implements Blob {
    @NotNull
    private byte[] bytes;
    @NotNull
    private final ArrayList<InputStream> activeStreams;
    private boolean isClosed;

    public ProtocolInMemoryBlob(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.bytes = bytes;
        this.activeStreams = new ArrayList();
    }

    @Override
    public long length() {
        this.throwIfClosed();
        return this.bytes.length;
    }

    @Override
    @NotNull
    public byte[] getBytes(long pos, int length) {
        this.throwIfClosed();
        if (pos < 1L) {
            throw ExceptionsKt.invalidStreamPosition(pos);
        }
        if (length < 0) {
            throw ExceptionsKt.invalidStreamLength(length);
        }
        long startPosition = pos - 1L;
        int chunkLength = length;
        if (startPosition > (long)this.bytes.length) {
            startPosition = this.bytes.length;
        }
        if ((long)chunkLength > (long)this.bytes.length - startPosition) {
            chunkLength = (int)((long)this.bytes.length - startPosition);
        }
        byte[] chunk = new byte[length];
        System.arraycopy(this.bytes, (int)startPosition, chunk, 0, chunkLength);
        return chunk;
    }

    @Override
    @NotNull
    public InputStream getBinaryStream() {
        this.throwIfClosed();
        return this.getBinaryStream(0L, this.bytes.length);
    }

    @Override
    @NotNull
    public InputStream getBinaryStream(long pos, long length) {
        this.throwIfClosed();
        if (pos < 1L) {
            throw ExceptionsKt.invalidStreamPosition(pos);
        }
        if (length < 0L) {
            throw ExceptionsKt.invalidStreamLength(length);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(this.bytes, (int)pos - 1, (int)length);
        this.activeStreams.add(stream);
        return stream;
    }

    @Override
    public long position(@NotNull byte[] pattern, long start2) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.throwIfClosed();
        return SearchUtilsKt.kmpSearch(this.bytes, pattern, (int)start2);
    }

    @Override
    public long position(@NotNull Blob pattern, long start2) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.throwIfClosed();
        byte[] byArray = pattern.getBytes(1L, (int)pattern.length());
        Intrinsics.checkNotNullExpressionValue(byArray, "pattern.getBytes(1L, pattern.length().toInt())");
        return this.position(byArray, start2);
    }

    @Override
    public int setBytes(long pos, @NotNull byte[] bytesToSet) {
        Intrinsics.checkNotNullParameter(bytesToSet, "bytesToSet");
        this.throwIfClosed();
        return this.setBytes(pos, bytesToSet, 0, bytesToSet.length);
    }

    @Override
    public int setBytes(long pos, @NotNull byte[] bytesToSet, int offset, int len) {
        Intrinsics.checkNotNullParameter(bytesToSet, "bytesToSet");
        this.throwIfClosed();
        if (offset < 0 || offset > bytesToSet.length) {
            throw ExceptionsKt.invalidStreamOffset(len);
        }
        if (len < 0 || len > this.bytes.length - offset) {
            throw ExceptionsKt.invalidStreamLength(len);
        }
        if (pos <= 0L || pos > (long)(this.bytes.length + 1)) {
            throw ExceptionsKt.invalidStreamPosition(len);
        }
        long position = pos - 1L;
        if ((long)len >= (long)this.bytes.length - position) {
            byte[] combinedValue = new byte[(int)position + len];
            System.arraycopy(this.bytes, 0, combinedValue, 0, (int)position);
            System.arraycopy(bytesToSet, offset, combinedValue, (int)position, len);
            this.bytes = combinedValue;
        } else {
            System.arraycopy(bytesToSet, offset, this.bytes, (int)position, len);
        }
        return len;
    }

    @Override
    @NotNull
    public OutputStream setBinaryStream(long pos) {
        this.throwIfClosed();
        return new SqlServerBlobOutputStream(this, pos);
    }

    @Override
    public void truncate(long len) {
        this.throwIfClosed();
        if (len < 0L) {
            throw ExceptionsKt.invalidStreamLength(len);
        }
        if ((long)this.bytes.length > len) {
            byte[] newBytes = new byte[(int)len];
            System.arraycopy(this.bytes, 0, newBytes, 0, (int)len);
            this.bytes = newBytes;
        }
    }

    @Override
    public void free() {
        if (this.isClosed) {
            return;
        }
        for (InputStream stream : this.activeStreams) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        this.activeStreams.clear();
        this.isClosed = true;
    }

    private final void throwIfClosed() {
        if (this.isClosed) {
            throw ExceptionsKt.blobClosed();
        }
    }
}

