/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.conversions.set;

import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToNativeTypeTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0017\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0018\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u001a\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\"\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010$\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010&\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010*2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010+J\u001f\u0010,\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010/2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u00100\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u00102\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u00104\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00106J\"\u00107\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u00108\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u0001092\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010:\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010;2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010<\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010=\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010>2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010?\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010@2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010A\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010B2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010C\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010D2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010E\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010F2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010G\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010H2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010IJ\"\u0010J\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010N\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010;2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010O\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010P2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010Q\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010R2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010S\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010T\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010U2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010V\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010W2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006X"}, d2={"Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "", "translator", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;", "(Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;)V", "to", "", "Ljava/sql/SQLType;", "getTo", "()Ljava/util/List;", "getTranslator", "()Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;", "fromArray", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "Ljava/sql/Array;", "sqlType", "", "fromAsciiStream", "Ljava/io/InputStream;", "length", "fromBigDecimal", "Ljava/math/BigDecimal;", "fromBinaryStream", "fromBlob", "Ljava/sql/Blob;", "fromBoolean", "", "(Ljava/lang/Boolean;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromByte", "", "(Ljava/lang/Byte;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromBytes", "", "fromCharacterStream", "Ljava/io/Reader;", "fromClob", "Ljava/sql/Clob;", "fromDouble", "", "(Ljava/lang/Double;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromFloat", "", "(Ljava/lang/Float;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromInt", "(Ljava/lang/Integer;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromLocalDate", "Ljava/time/LocalDate;", "fromLocalDateTime", "Ljava/time/LocalDateTime;", "fromLocalTime", "Ljava/time/LocalTime;", "fromLong", "", "(Ljava/lang/Long;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromNCharacterStream", "fromNClob", "Ljava/sql/NClob;", "fromNString", "", "fromNull", "fromOffsetDateTime", "Ljava/time/OffsetDateTime;", "fromOffsetTime", "Ljava/time/OffsetTime;", "fromRef", "Ljava/sql/Ref;", "fromRowId", "Ljava/sql/RowId;", "fromSQLXML", "Ljava/sql/SQLXML;", "fromShort", "", "(Ljava/lang/Short;I)Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "fromSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "fromString", "fromTime", "Ljava/sql/Time;", "fromTimestamp", "Ljava/sql/Timestamp;", "fromUnicodeStream", "fromUrl", "Ljava/net/URL;", "fromUtilDate", "Ljava/util/Date;", "Frontend"})
public abstract class SetValueConverter {
    @NotNull
    private final IJdbcToNativeTypeTranslator translator;

    public SetValueConverter(@NotNull IJdbcToNativeTypeTranslator translator) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        this.translator = translator;
    }

    @NotNull
    protected final IJdbcToNativeTypeTranslator getTranslator() {
        return this.translator;
    }

    @NotNull
    public abstract List<SQLType> getTo();

    @NotNull
    public final RdSetValueRequest fromNull(int sqlType) {
        Integer n = this.translator.fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetNullRequest(((Number)n).intValue());
    }

    @NotNull
    public RdSetValueRequest fromBoolean(@Nullable Boolean value2, int sqlType) {
        String string = UUID.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "UUID::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromByte(@Nullable Byte value2, int sqlType) {
        String string = Byte.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Byte::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromShort(@Nullable Short value2, int sqlType) {
        String string = Short.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Short::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromInt(@Nullable Integer value2, int sqlType) {
        String string = Integer.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Int::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromLong(@Nullable Long value2, int sqlType) {
        String string = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Long::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromFloat(@Nullable Float value2, int sqlType) {
        String string = Float.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Float::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromDouble(@Nullable Double value2, int sqlType) {
        String string = Double.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Double::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromBigDecimal(@Nullable BigDecimal value2, int sqlType) {
        String string = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "BigDecimal::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        String string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "String::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromBytes(@Nullable byte[] value2, int sqlType) {
        String string = byte[].class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "ByteArray::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromSqlDate(@Nullable Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = Date.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Date::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromUtilDate(@Nullable java.util.Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = Date.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Date::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromTime(@Nullable Time value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = Time.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Time::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromTimestamp(@Nullable Timestamp value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = Timestamp.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Timestamp::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromLocalDateTime(@Nullable LocalDateTime value2, int sqlType) {
        String string = LocalDateTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "LocalDateTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromLocalDate(@Nullable LocalDate value2, int sqlType) {
        String string = LocalDate.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "LocalDate::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromLocalTime(@Nullable LocalTime value2, int sqlType) {
        String string = LocalTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "LocalTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromOffsetDateTime(@Nullable OffsetDateTime value2, int sqlType) {
        String string = OffsetDateTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "OffsetDateTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromOffsetTime(@Nullable OffsetTime value2, int sqlType) {
        String string = OffsetTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "OffsetTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromAsciiStream(@Nullable InputStream value2, int length, int sqlType) {
        String string = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromUnicodeStream(@Nullable InputStream value2, int length, int sqlType) {
        String string = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromArray(@Nullable Array value2, int sqlType) {
        String string = Array.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Array::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromBinaryStream(@Nullable InputStream value2, int length, int sqlType) {
        String string = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromCharacterStream(@Nullable Reader value2, int length, int sqlType) {
        String string = Reader.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Reader::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromBlob(@Nullable Blob value2, int sqlType) {
        String string = Blob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Blob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromClob(@Nullable Clob value2, int sqlType) {
        String string = Clob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Clob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromUrl(@Nullable URL value2, int sqlType) {
        String string = URL.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "URL::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromRowId(@Nullable RowId value2, int sqlType) {
        String string = RowId.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "RowId::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromRef(@Nullable Ref value2, int sqlType) {
        String string = Ref.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Ref::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        String string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "String::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromNClob(@Nullable NClob value2, int sqlType) {
        String string = NClob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "NClob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromSQLXML(@Nullable SQLXML value2, int sqlType) {
        String string = SQLXML.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "SQLXML::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }

    @NotNull
    public RdSetValueRequest fromNCharacterStream(@Nullable Reader value2, int length, int sqlType) {
        String string = Reader.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "Reader::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, sqlType);
    }
}

