/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base;

import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdConnectionInfo;
import com.jetbrains.jdbc.base.models.RdConnectionProperty;
import com.jetbrains.jdbc.base.models.RdDriver;
import com.jetbrains.jdbc.base.models.RdDriverPropertyInfo;
import com.jetbrains.jdbc.base.utils.logging.ILoggerProvider;
import com.jetbrains.jdbc.base.utils.protocol.RdDriverExtKt;
import com.jetbrains.jdbc.base.utils.protocol.hosting.ProtocolHost;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ConnectionInitializationData;
import com.jetbrains.jdbc.base.utils.translators.TranslatorsKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.util.Properties;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010!J\u0006\u0010\"\u001a\u00020\u0015J%\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0019R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/jdbc/base/ProtocolDriver;", "", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "loggerProvider", "Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;)V", "driver", "Lcom/jetbrains/jdbc/base/models/RdDriver;", "getDriver", "()Lcom/jetbrains/jdbc/base/models/RdDriver;", "driver$delegate", "Lkotlin/Lazy;", "jdbcModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "getJdbcModel", "()Lcom/jetbrains/jdbc/base/models/JdbcModel;", "jdbcModel$delegate", "logger", "Ljava/util/logging/Logger;", "protocolHost", "Lcom/jetbrains/jdbc/base/utils/protocol/hosting/ProtocolHost;", "acceptsURL", "", "url", "", "close", "", "connect", "Ljava/sql/Connection;", "info", "Ljava/util/Properties;", "getParentLogger", "getPropertyInfo", "", "Ljava/sql/DriverPropertyInfo;", "(Ljava/lang/String;Ljava/util/Properties;)[Ljava/sql/DriverPropertyInfo;", "jdbcCompliant", "Frontend"})
@SourceDebugExtension(value={"SMAP\nProtocolDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolDriver.kt\ncom/jetbrains/jdbc/base/ProtocolDriver\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,88:1\n26#2:89\n*S KotlinDebug\n*F\n+ 1 ProtocolDriver.kt\ncom/jetbrains/jdbc/base/ProtocolDriver\n*L\n68#1:89\n*E\n"})
public abstract class ProtocolDriver {
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final JdbcFactory jdbcFactory;
    @NotNull
    private final ILoggerProvider loggerProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ProtocolHost protocolHost;
    @NotNull
    private final Lazy jdbcModel$delegate;
    @NotNull
    private final Lazy driver$delegate;

    public ProtocolDriver(@NotNull LifetimeDefinition lifetimeDefinition, @NotNull JdbcFactory jdbcFactory, @NotNull ILoggerProvider loggerProvider) {
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        Intrinsics.checkNotNullParameter(loggerProvider, "loggerProvider");
        this.lifetimeDefinition = lifetimeDefinition;
        this.jdbcFactory = jdbcFactory;
        this.loggerProvider = loggerProvider;
        this.logger = this.loggerProvider.getLogger(ProtocolDriver.class);
        this.protocolHost = new ProtocolHost(this.lifetimeDefinition.getLifetime(), this.loggerProvider);
        this.jdbcModel$delegate = LazyKt.lazy((Function0)new Function0<JdbcModel>(this){
            final /* synthetic */ ProtocolDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JdbcModel invoke() {
                return ProtocolDriver.access$getProtocolHost$p(this.this$0).start();
            }
        });
        this.driver$delegate = LazyKt.lazy((Function0)new Function0<RdDriver>(this){
            final /* synthetic */ ProtocolDriver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RdDriver invoke() {
                return InterfacesKt.getValueOrThrow(ProtocolDriver.access$getJdbcModel(this.this$0).getDriver());
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ProtocolDriver._init_$lambda$0(this)));
    }

    private final JdbcModel getJdbcModel() {
        Lazy lazy = this.jdbcModel$delegate;
        return (JdbcModel)lazy.getValue();
    }

    private final RdDriver getDriver() {
        Lazy lazy = this.driver$delegate;
        return (RdDriver)lazy.getValue();
    }

    @Nullable
    public final Connection connect(@Nullable String url, @Nullable Properties info) {
        if (url == null && (info == null || info.isEmpty())) {
            return null;
        }
        Properties properties2 = info;
        RdConnectionInfo request = new RdConnectionInfo(url, (RdConnectionProperty[])(properties2 != null ? TranslatorsKt.toRdConnectionProperties(properties2) : null));
        ConnectionInitializationData rdConnection = RdDriverExtKt.getConnection(this.getDriver(), this.lifetimeDefinition.getLifetime(), request, this.getJdbcModel().getConnections());
        this.logger.finer("connected successfully");
        return this.jdbcFactory.createConnection(rdConnection, this.getJdbcModel(), this.lifetimeDefinition.getLifetime());
    }

    public final boolean acceptsURL(@Nullable String url) {
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return RdDriverExtKt.acceptsURL(this.getDriver(), this.lifetimeDefinition.getLifetime(), url);
    }

    @NotNull
    public final DriverPropertyInfo[] getPropertyInfo(@Nullable String url, @Nullable Properties info) {
        if (url == null && (info == null || info.isEmpty())) {
            boolean $i$f$emptyArray = false;
            return new DriverPropertyInfo[0];
        }
        Properties properties2 = info;
        RdConnectionInfo request = new RdConnectionInfo(url, (RdConnectionProperty[])(properties2 != null ? TranslatorsKt.toRdConnectionProperties(properties2) : null));
        RdDriverPropertyInfo[] propertiesInfo = RdDriverExtKt.getPropertyInfo(this.getDriver(), this.lifetimeDefinition.getLifetime(), request);
        return TranslatorsKt.toDriverProperties(propertiesInfo);
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    @NotNull
    public final Logger getParentLogger() {
        return this.loggerProvider.getBaseLogger();
    }

    public final void close() {
        LifetimeDefinition.terminate$default(this.lifetimeDefinition, false, 1, null);
    }

    private static final void _init_$lambda$0(ProtocolDriver this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.close();
    }

    public static final /* synthetic */ ProtocolHost access$getProtocolHost$p(ProtocolDriver $this) {
        return $this.protocolHost;
    }

    public static final /* synthetic */ JdbcModel access$getJdbcModel(ProtocolDriver $this) {
        return $this.getJdbcModel();
    }
}

