/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.profile.FileAndModule;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;
import org.jetbrains.qodana.staticAnalysis.profile.SanityInspectionGroupKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001aR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "", "project", "Lcom/intellij/openapi/project/Project;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "_maxPerFile", "", "_maxPerModule", "_maxPerProject", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;III)V", "getInspectionToolWrapper", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "maxPerFile", "maxPerModule", "maxPerProject", "perFile", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/profile/FileAndModule;", "perModule", "", "perProject", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addProblem", "", "relativePath", "module", "isThresholdReached", "wasAnyModuleThresholdReached", "wasProjectThresholdReached", "intellij.qodana"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n187#2,3:190\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n*L\n176#1:190,3\n*E\n"})
public final class ProblemCounters {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionToolWrapper<?, ?> inspectionToolWrapper;
    @NotNull
    private final ConcurrentHashMap<FileAndModule, Integer> perFile;
    @NotNull
    private final ConcurrentHashMap<String, Integer> perModule;
    @NotNull
    private final AtomicInteger perProject;
    private final int maxPerFile;
    private final int maxPerModule;
    private final int maxPerProject;

    public ProblemCounters(@NotNull Project project, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper, int _maxPerFile, int _maxPerModule, int _maxPerProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
        this.project = project;
        this.inspectionToolWrapper = inspectionToolWrapper;
        this.perFile = new ConcurrentHashMap();
        this.perModule = new ConcurrentHashMap();
        this.perProject = new AtomicInteger(0);
        this.maxPerFile = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerFile);
        this.maxPerModule = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerModule);
        this.maxPerProject = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerProject);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionToolWrapper<?, ?> getInspectionToolWrapper() {
        return this.inspectionToolWrapper;
    }

    public final boolean addProblem(@Nullable String relativePath, @Nullable String module2) {
        int currentPerModule2;
        Integer n;
        int currentPerFile2;
        Integer n2;
        if (relativePath != null) {
            String string = module2;
            if (string == null) {
                string = "";
            }
            if ((n2 = this.perFile.compute(new FileAndModule(relativePath, string), addProblem.currentPerFile.1.INSTANCE)) == null) {
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        if ((currentPerFile2 = ((Number)n2).intValue()) > this.maxPerFile) {
            return true;
        }
        if (module2 != null) {
            n = this.perModule.compute(module2, addProblem.currentPerModule.1.INSTANCE);
            if (n == null) {
                n = -1;
            }
        } else {
            n = -1;
        }
        if ((currentPerModule2 = ((Number)n).intValue()) > this.maxPerModule) {
            return true;
        }
        int currentPerProject = this.perProject.incrementAndGet();
        return currentPerFile2 >= this.maxPerFile || currentPerModule2 >= this.maxPerModule || currentPerProject >= this.maxPerProject;
    }

    public final boolean isThresholdReached(@Nullable String relativePath, @Nullable String module2) {
        if (this.perProject.get() >= this.maxPerProject) {
            return true;
        }
        if (module2 != null) {
            Integer n = this.perModule.get(module2);
            if (n == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerModule) {
                return true;
            }
        }
        if (relativePath != null) {
            Integer n;
            String string = module2;
            if (string == null) {
                string = "";
            }
            if ((n = this.perFile.get(new FileAndModule(relativePath, string))) == null) {
                n = 0;
            }
            if (((Number)n).intValue() >= this.maxPerFile) {
                return true;
            }
        }
        return false;
    }

    public final boolean wasAnyModuleThresholdReached() {
        boolean bl;
        block3: {
            Map $this$any$iv = this.perModule;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(((Number)it.getValue()).intValue() >= this.maxPerModule)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean wasProjectThresholdReached() {
        return this.perProject.get() >= this.maxPerProject;
    }
}

