/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.targets;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.TestTarget;
import org.jetbrains.qodana.staticAnalysis.scopes.QodanaAnalysisScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/SingleScopeTestTarget;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/TestTarget;", "name", "", "inspections", "", "threshold", "", "scope", "Lorg/jetbrains/qodana/staticAnalysis/scopes/QodanaAnalysisScope;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Ljava/lang/String;Ljava/util/List;ILorg/jetbrains/qodana/staticAnalysis/scopes/QodanaAnalysisScope;Lcom/intellij/openapi/components/PathMacroManager;)V", "getInspections", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getThreshold", "()I", "contains", "", "inspection", "url", "intellij.qodana"})
public final class SingleScopeTestTarget
implements TestTarget {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> inspections;
    private final int threshold;
    @NotNull
    private final QodanaAnalysisScope scope;
    @NotNull
    private final PathMacroManager macroManager;

    public SingleScopeTestTarget(@NotNull String name, @NotNull List<String> inspections, int threshold, @NotNull QodanaAnalysisScope scope2, @NotNull PathMacroManager macroManager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(inspections, (String)"inspections");
        Intrinsics.checkNotNullParameter((Object)((Object)scope2), (String)"scope");
        Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
        this.name = name;
        this.inspections = inspections;
        this.threshold = threshold;
        this.scope = scope2;
        this.macroManager = macroManager;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<String> getInspections() {
        return this.inspections;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean contains(@NotNull String inspection, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)inspection, (String)"inspection");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(this.macroManager.expandPath(url));
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return this.getInspections().contains(inspection) && this.scope.contains(virtualFile3);
    }
}

