/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.extensions.VcsIgnoredFilesProvider;
import org.jetbrains.qodana.license.QodanaLicense;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FailureConditions;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaProfileConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaScriptConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.DefaultSeverityIncludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.GlobalExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormatKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b7\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 \u008a\u00012\u00020\u0001:\u0002\u008a\u0001B\u0099\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u000e\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0003\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\b\u0012\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u0012\u0010\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u0012\b\u0010 \u001a\u0004\u0018\u00010\b\u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010#\u001a\u00020\u000e\u0012\u0006\u0010$\u001a\u00020%\u0012\b\b\u0002\u0010&\u001a\u00020\u000e\u0012\b\b\u0002\u0010'\u001a\u00020\u000e\u0012\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\"\u0012\b\b\u0002\u0010)\u001a\u00020\"\u0012\b\b\u0002\u0010*\u001a\u00020\"\u0012\b\b\u0002\u0010+\u001a\u00020\"\u00a2\u0006\u0002\u0010,J\u000e\u0010[\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020]J\t\u0010^\u001a\u00020\u0003H\u00c6\u0003J\t\u0010_\u001a\u00020\u0010H\u00c6\u0003J\u0010\u0010`\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010PJ\t\u0010a\u001a\u00020\u0013H\u00c6\u0003J\t\u0010b\u001a\u00020\u000eH\u00c6\u0003J\t\u0010c\u001a\u00020\u0016H\u00c6\u0003J\t\u0010d\u001a\u00020\u0018H\u00c6\u0003J\t\u0010e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010f\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0013\u0010g\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eH\u00c6\u0003J\u0013\u0010h\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001eH\u00c6\u0003J\u000b\u0010i\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010j\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010k\u001a\u00020\"H\u00c6\u0003J\t\u0010l\u001a\u00020\u000eH\u00c6\u0003J\t\u0010m\u001a\u00020%H\u00c6\u0003J\t\u0010n\u001a\u00020\u000eH\u00c6\u0003J\t\u0010o\u001a\u00020\u000eH\u00c6\u0003J\u0010\u0010p\u001a\u0004\u0018\u00010\"H\u00c6\u0003\u00a2\u0006\u0002\u0010XJ\t\u0010q\u001a\u00020\"H\u00c6\u0003J\t\u0010r\u001a\u00020\"H\u00c6\u0003J\t\u0010s\u001a\u00020\"H\u00c6\u0003J\t\u0010t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010u\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010v\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010w\u001a\u00020\nH\u00c6\u0003J\t\u0010x\u001a\u00020\bH\u00c6\u0003J\t\u0010y\u001a\u00020\bH\u00c6\u0003J\t\u0010z\u001a\u00020\u000eH\u00c6\u0003J\u00d0\u0002\u0010{\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0012\b\u0002\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u000e2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u000e2\b\b\u0002\u0010'\u001a\u00020\u000e2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010)\u001a\u00020\"2\b\b\u0002\u0010*\u001a\u00020\"2\b\b\u0002\u0010+\u001a\u00020\"H\u00c6\u0001\u00a2\u0006\u0002\u0010|J\u0013\u0010}\u001a\u00020\u000e2\b\u0010~\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\u007f\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u001c2\u0007\u0010\u0081\u0001\u001a\u00020\u000e2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u000e\u0010\u0084\u0001\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u001cJ\n\u0010\u0085\u0001\u001a\u00020\"H\u00d6\u0001J\u0010\u0010\u0086\u0001\u001a\u00020\u000e2\u0007\u0010\u0087\u0001\u001a\u00020\"J\u0013\u0010\u0088\u0001\u001a\u00020\u000e2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\n\u0010\u0089\u0001\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010 \u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010.R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001b\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010#\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00104R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010)\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001b\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00106R\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00104R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010;R\u0011\u0010*\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010;R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00101R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u00101R\u0011\u0010+\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010;R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u00101R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010Q\u001a\u0004\bO\u0010PR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010&\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u00104R\u0011\u0010'\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u00104R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010.R\u0015\u0010(\u001a\u0004\u0018\u00010\"\u00a2\u0006\n\n\u0002\u0010Y\u001a\u0004\bW\u0010XR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u00101\u00a8\u0006\u008b\u0001"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "", "projectPath", "Ljava/nio/file/Path;", "yamlConfigPath", "outPath", "resultsStorage", "baseline", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "profileSource", "defaultProfileName", "disableSanityInspections", "", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "runPromoInspections", "script", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "includeAbsent", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "license", "Lorg/jetbrains/qodana/license/QodanaLicense;", "coveragePath", "sourceDirectory", "exclude", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScopes;", "include", "bootstrap", "maxRuntimeNotifications", "", "failOnErrorNotification", "failureConditions", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;", "skipPreamble", "skipResultOutput", "stopThreshold", "fileSuspendThreshold", "moduleSuspendThreshold", "projectSuspendThreshold", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicense;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;ZZLjava/lang/Integer;III)V", "getBaseline", "()Ljava/lang/String;", "getBootstrap", "getCoveragePath", "()Ljava/nio/file/Path;", "getDefaultProfileName", "getDisableSanityInspections", "()Z", "getExclude", "()Ljava/util/List;", "getFailOnErrorNotification", "getFailureConditions", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;", "getFileSuspendThreshold", "()I", "getFixesStrategy", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "getInclude", "getIncludeAbsent", "getLicense", "()Lorg/jetbrains/qodana/license/QodanaLicense;", "setLicense", "(Lorg/jetbrains/qodana/license/QodanaLicense;)V", "getMaxRuntimeNotifications", "getModuleSuspendThreshold", "getOutPath", "getOutputFormat", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getProfile", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "getProfileSource", "getProjectPath", "getProjectSuspendThreshold", "getResultsStorage", "getRunPromoInspections", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getScript", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "getSkipPreamble", "getSkipResultOutput", "getSourceDirectory", "getStopThreshold", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getYamlConfigPath", "checkRunPromo", "inspectionProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicense;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;ZZLjava/lang/Integer;III)Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "equals", "other", "getExcludeModifiers", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "addDefaultExclude", "project", "Lcom/intellij/openapi/project/Project;", "getIncludeModifiers", "hashCode", "isAboveStopThreshold", "count", "supportsGitIgnore", "toString", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n1549#2:258\n1620#2,3:259\n*S KotlinDebug\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig\n*L\n222#1:258\n222#1:259,3\n*E\n"})
public final class QodanaConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectPath;
    @Nullable
    private final Path yamlConfigPath;
    @NotNull
    private final Path outPath;
    @NotNull
    private final Path resultsStorage;
    @Nullable
    private final String baseline;
    @NotNull
    private final QodanaProfileConfig profile;
    @NotNull
    private final String profileSource;
    @NotNull
    private final String defaultProfileName;
    private final boolean disableSanityInspections;
    @NotNull
    private final FixesStrategy fixesStrategy;
    @Nullable
    private final Boolean runPromoInspections;
    @NotNull
    private final QodanaScriptConfig script;
    private final boolean includeAbsent;
    @NotNull
    private final OutputFormat outputFormat;
    @NotNull
    private QodanaLicense license;
    @NotNull
    private final Path coveragePath;
    @Nullable
    private final String sourceDirectory;
    @NotNull
    private final List<InspectScope> exclude;
    @NotNull
    private final List<InspectScope> include;
    @Nullable
    private final String bootstrap;
    private final int maxRuntimeNotifications;
    private final boolean failOnErrorNotification;
    @NotNull
    private final FailureConditions failureConditions;
    private final boolean skipPreamble;
    private final boolean skipResultOutput;
    @Nullable
    private final Integer stopThreshold;
    private final int fileSuspendThreshold;
    private final int moduleSuspendThreshold;
    private final int projectSuspendThreshold;

    public QodanaConfig(@NotNull Path projectPath, @Nullable Path yamlConfigPath, @NotNull Path outPath, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String profileSource, @NotNull String defaultProfileName, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull OutputFormat outputFormat, @NotNull QodanaLicense license, @NotNull Path coveragePath, @Nullable String sourceDirectory, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap, int maxRuntimeNotifications, boolean failOnErrorNotification, @NotNull FailureConditions failureConditions, boolean skipPreamble, boolean skipResultOutput, @Nullable Integer stopThreshold, int fileSuspendThreshold, int moduleSuspendThreshold, int projectSuspendThreshold) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)profileSource, (String)"profileSource");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter((Object)failureConditions, (String)"failureConditions");
        this.projectPath = projectPath;
        this.yamlConfigPath = yamlConfigPath;
        this.outPath = outPath;
        this.resultsStorage = resultsStorage;
        this.baseline = baseline;
        this.profile = profile2;
        this.profileSource = profileSource;
        this.defaultProfileName = defaultProfileName;
        this.disableSanityInspections = disableSanityInspections;
        this.fixesStrategy = fixesStrategy;
        this.runPromoInspections = runPromoInspections;
        this.script = script;
        this.includeAbsent = includeAbsent;
        this.outputFormat = outputFormat;
        this.license = license;
        this.coveragePath = coveragePath;
        this.sourceDirectory = sourceDirectory;
        this.exclude = exclude2;
        this.include = include;
        this.bootstrap = bootstrap;
        this.maxRuntimeNotifications = maxRuntimeNotifications;
        this.failOnErrorNotification = failOnErrorNotification;
        this.failureConditions = failureConditions;
        this.skipPreamble = skipPreamble;
        this.skipResultOutput = skipResultOutput;
        this.stopThreshold = stopThreshold;
        this.fileSuspendThreshold = fileSuspendThreshold;
        this.moduleSuspendThreshold = moduleSuspendThreshold;
        this.projectSuspendThreshold = projectSuspendThreshold;
        if (!this.projectPath.isAbsolute()) {
            throw new QodanaException("Project path \"" + this.projectPath + "\" must be absolute");
        }
        if (this.failOnErrorNotification && this.maxRuntimeNotifications < 1) {
            throw new QodanaException("Cannot enable 'failOnErrorNotification' when 'maxRuntimeNotifications' is less than 1");
        }
    }

    public /* synthetic */ QodanaConfig(Path path, Path path2, Path path3, Path path4, String string, QodanaProfileConfig qodanaProfileConfig, String string2, String string3, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, OutputFormat outputFormat, QodanaLicense qodanaLicense, Path path5, String string4, List list2, List list3, String string5, int n, boolean bl4, FailureConditions failureConditions, boolean bl5, boolean bl6, Integer n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x800000) != 0) {
            bl5 = Boolean.parseBoolean(System.getProperty("qodana.skip.preamble"));
        }
        if ((n6 & 0x1000000) != 0) {
            bl6 = Boolean.parseBoolean(System.getProperty("qodana.skip.result"));
        }
        if ((n6 & 0x2000000) != 0) {
            String string6 = System.getProperty("qodana.stop.threshold");
            Integer n7 = n2 = string6 != null ? Integer.valueOf(Integer.parseInt(string6)) : null;
        }
        if ((n6 & 0x4000000) != 0) {
            String string7 = System.getProperty("qodana.file.suspend.threshold", "5");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getProperty(...)");
            n3 = Integer.parseInt(string7);
        }
        if ((n6 & 0x8000000) != 0) {
            String string8 = System.getProperty("qodana.module.suspend.threshold", "25");
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getProperty(...)");
            n4 = Integer.parseInt(string8);
        }
        if ((n6 & 0x10000000) != 0) {
            String string9 = System.getProperty("qodana.project.suspend.threshold", "125");
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getProperty(...)");
            n5 = Integer.parseInt(string9);
        }
        this(path, path2, path3, path4, string, qodanaProfileConfig, string2, string3, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, outputFormat, qodanaLicense, path5, string4, list2, list3, string5, n, bl4, failureConditions, bl5, bl6, n2, n3, n4, n5);
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @Nullable
    public final Path getYamlConfigPath() {
        return this.yamlConfigPath;
    }

    @NotNull
    public final Path getOutPath() {
        return this.outPath;
    }

    @NotNull
    public final Path getResultsStorage() {
        return this.resultsStorage;
    }

    @Nullable
    public final String getBaseline() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getProfileSource() {
        return this.profileSource;
    }

    @NotNull
    public final String getDefaultProfileName() {
        return this.defaultProfileName;
    }

    public final boolean getDisableSanityInspections() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy getFixesStrategy() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean getRunPromoInspections() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig getScript() {
        return this.script;
    }

    public final boolean getIncludeAbsent() {
        return this.includeAbsent;
    }

    @NotNull
    public final OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicense getLicense() {
        return this.license;
    }

    public final void setLicense(@NotNull QodanaLicense qodanaLicense) {
        Intrinsics.checkNotNullParameter((Object)qodanaLicense, (String)"<set-?>");
        this.license = qodanaLicense;
    }

    @NotNull
    public final Path getCoveragePath() {
        return this.coveragePath;
    }

    @Nullable
    public final String getSourceDirectory() {
        return this.sourceDirectory;
    }

    @NotNull
    public final List<InspectScope> getExclude() {
        return this.exclude;
    }

    @NotNull
    public final List<InspectScope> getInclude() {
        return this.include;
    }

    @Nullable
    public final String getBootstrap() {
        return this.bootstrap;
    }

    public final int getMaxRuntimeNotifications() {
        return this.maxRuntimeNotifications;
    }

    public final boolean getFailOnErrorNotification() {
        return this.failOnErrorNotification;
    }

    @NotNull
    public final FailureConditions getFailureConditions() {
        return this.failureConditions;
    }

    public final boolean getSkipPreamble() {
        return this.skipPreamble;
    }

    public final boolean getSkipResultOutput() {
        return this.skipResultOutput;
    }

    @Nullable
    public final Integer getStopThreshold() {
        return this.stopThreshold;
    }

    public final int getFileSuspendThreshold() {
        return this.fileSuspendThreshold;
    }

    public final int getModuleSuspendThreshold() {
        return this.moduleSuspendThreshold;
    }

    public final int getProjectSuspendThreshold() {
        return this.projectSuspendThreshold;
    }

    public final boolean checkRunPromo(@NotNull QodanaInspectionProfile inspectionProfile) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionProfile), (String)"inspectionProfile");
        return Intrinsics.areEqual((Object)this.runPromoInspections, (Object)true) || this.runPromoInspections == null && Intrinsics.areEqual((Object)inspectionProfile.getName(), (Object)this.defaultProfileName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QodanaScopeModifier> getIncludeModifiers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.include;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            InspectScope inspectScope = (InspectScope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DefaultSeverityIncludeScopeModifier((InspectScope)p0));
        }
        return (List)destination$iv$iv;
    }

    private final boolean supportsGitIgnore(Project project) {
        List<FilePath> ignored = VcsIgnoredFilesProvider.Companion.getVcsRepositoriesIgnoredFiles(project);
        return !((Collection)ignored).isEmpty();
    }

    @NotNull
    public final List<QodanaScopeModifier> getExcludeModifiers(boolean addDefaultExclude, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List modifiers = new ArrayList();
        for (InspectScope scope2 : this.exclude) {
            if (Intrinsics.areEqual((Object)scope2.getName(), (Object)"All")) {
                ((Collection)modifiers).add(new GlobalExcludeScopeModifier(scope2));
                continue;
            }
            ((Collection)modifiers).add(new ExcludeScopeModifier(scope2));
        }
        if (addDefaultExclude) {
            ((Collection)modifiers).add(QodanaConfigKt.getDEFAULT_EXCLUDE_SCOPE_MODIFIER());
        }
        if (addDefaultExclude && this.supportsGitIgnore(project)) {
            ((Collection)modifiers).add(QodanaConfigKt.getGIT_IGNORE_SCOPE_MODIFIER());
        }
        return modifiers;
    }

    public final boolean isAboveStopThreshold(int count) {
        return this.stopThreshold != null && count > this.stopThreshold;
    }

    @NotNull
    public final Path component1() {
        return this.projectPath;
    }

    @Nullable
    public final Path component2() {
        return this.yamlConfigPath;
    }

    @NotNull
    public final Path component3() {
        return this.outPath;
    }

    @NotNull
    public final Path component4() {
        return this.resultsStorage;
    }

    @Nullable
    public final String component5() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig component6() {
        return this.profile;
    }

    @NotNull
    public final String component7() {
        return this.profileSource;
    }

    @NotNull
    public final String component8() {
        return this.defaultProfileName;
    }

    public final boolean component9() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy component10() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean component11() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig component12() {
        return this.script;
    }

    public final boolean component13() {
        return this.includeAbsent;
    }

    @NotNull
    public final OutputFormat component14() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicense component15() {
        return this.license;
    }

    @NotNull
    public final Path component16() {
        return this.coveragePath;
    }

    @Nullable
    public final String component17() {
        return this.sourceDirectory;
    }

    @NotNull
    public final List<InspectScope> component18() {
        return this.exclude;
    }

    @NotNull
    public final List<InspectScope> component19() {
        return this.include;
    }

    @Nullable
    public final String component20() {
        return this.bootstrap;
    }

    public final int component21() {
        return this.maxRuntimeNotifications;
    }

    public final boolean component22() {
        return this.failOnErrorNotification;
    }

    @NotNull
    public final FailureConditions component23() {
        return this.failureConditions;
    }

    public final boolean component24() {
        return this.skipPreamble;
    }

    public final boolean component25() {
        return this.skipResultOutput;
    }

    @Nullable
    public final Integer component26() {
        return this.stopThreshold;
    }

    public final int component27() {
        return this.fileSuspendThreshold;
    }

    public final int component28() {
        return this.moduleSuspendThreshold;
    }

    public final int component29() {
        return this.projectSuspendThreshold;
    }

    @NotNull
    public final QodanaConfig copy(@NotNull Path projectPath, @Nullable Path yamlConfigPath, @NotNull Path outPath, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String profileSource, @NotNull String defaultProfileName, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull OutputFormat outputFormat, @NotNull QodanaLicense license, @NotNull Path coveragePath, @Nullable String sourceDirectory, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap, int maxRuntimeNotifications, boolean failOnErrorNotification, @NotNull FailureConditions failureConditions, boolean skipPreamble, boolean skipResultOutput, @Nullable Integer stopThreshold, int fileSuspendThreshold, int moduleSuspendThreshold, int projectSuspendThreshold) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)profileSource, (String)"profileSource");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        Intrinsics.checkNotNullParameter((Object)failureConditions, (String)"failureConditions");
        return new QodanaConfig(projectPath, yamlConfigPath, outPath, resultsStorage, baseline, profile2, profileSource, defaultProfileName, disableSanityInspections, fixesStrategy, runPromoInspections, script, includeAbsent, outputFormat, license, coveragePath, sourceDirectory, exclude2, include, bootstrap, maxRuntimeNotifications, failOnErrorNotification, failureConditions, skipPreamble, skipResultOutput, stopThreshold, fileSuspendThreshold, moduleSuspendThreshold, projectSuspendThreshold);
    }

    public static /* synthetic */ QodanaConfig copy$default(QodanaConfig qodanaConfig, Path path, Path path2, Path path3, Path path4, String string, QodanaProfileConfig qodanaProfileConfig, String string2, String string3, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, OutputFormat outputFormat, QodanaLicense qodanaLicense, Path path5, String string4, List list2, List list3, String string5, int n, boolean bl4, FailureConditions failureConditions, boolean bl5, boolean bl6, Integer n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            path = qodanaConfig.projectPath;
        }
        if ((n6 & 2) != 0) {
            path2 = qodanaConfig.yamlConfigPath;
        }
        if ((n6 & 4) != 0) {
            path3 = qodanaConfig.outPath;
        }
        if ((n6 & 8) != 0) {
            path4 = qodanaConfig.resultsStorage;
        }
        if ((n6 & 0x10) != 0) {
            string = qodanaConfig.baseline;
        }
        if ((n6 & 0x20) != 0) {
            qodanaProfileConfig = qodanaConfig.profile;
        }
        if ((n6 & 0x40) != 0) {
            string2 = qodanaConfig.profileSource;
        }
        if ((n6 & 0x80) != 0) {
            string3 = qodanaConfig.defaultProfileName;
        }
        if ((n6 & 0x100) != 0) {
            bl = qodanaConfig.disableSanityInspections;
        }
        if ((n6 & 0x200) != 0) {
            fixesStrategy = qodanaConfig.fixesStrategy;
        }
        if ((n6 & 0x400) != 0) {
            bl2 = qodanaConfig.runPromoInspections;
        }
        if ((n6 & 0x800) != 0) {
            qodanaScriptConfig = qodanaConfig.script;
        }
        if ((n6 & 0x1000) != 0) {
            bl3 = qodanaConfig.includeAbsent;
        }
        if ((n6 & 0x2000) != 0) {
            outputFormat = qodanaConfig.outputFormat;
        }
        if ((n6 & 0x4000) != 0) {
            qodanaLicense = qodanaConfig.license;
        }
        if ((n6 & 0x8000) != 0) {
            path5 = qodanaConfig.coveragePath;
        }
        if ((n6 & 0x10000) != 0) {
            string4 = qodanaConfig.sourceDirectory;
        }
        if ((n6 & 0x20000) != 0) {
            list2 = qodanaConfig.exclude;
        }
        if ((n6 & 0x40000) != 0) {
            list3 = qodanaConfig.include;
        }
        if ((n6 & 0x80000) != 0) {
            string5 = qodanaConfig.bootstrap;
        }
        if ((n6 & 0x100000) != 0) {
            n = qodanaConfig.maxRuntimeNotifications;
        }
        if ((n6 & 0x200000) != 0) {
            bl4 = qodanaConfig.failOnErrorNotification;
        }
        if ((n6 & 0x400000) != 0) {
            failureConditions = qodanaConfig.failureConditions;
        }
        if ((n6 & 0x800000) != 0) {
            bl5 = qodanaConfig.skipPreamble;
        }
        if ((n6 & 0x1000000) != 0) {
            bl6 = qodanaConfig.skipResultOutput;
        }
        if ((n6 & 0x2000000) != 0) {
            n2 = qodanaConfig.stopThreshold;
        }
        if ((n6 & 0x4000000) != 0) {
            n3 = qodanaConfig.fileSuspendThreshold;
        }
        if ((n6 & 0x8000000) != 0) {
            n4 = qodanaConfig.moduleSuspendThreshold;
        }
        if ((n6 & 0x10000000) != 0) {
            n5 = qodanaConfig.projectSuspendThreshold;
        }
        return qodanaConfig.copy(path, path2, path3, path4, string, qodanaProfileConfig, string2, string3, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, outputFormat, qodanaLicense, path5, string4, list2, list3, string5, n, bl4, failureConditions, bl5, bl6, n2, n3, n4, n5);
    }

    @NotNull
    public String toString() {
        return "QodanaConfig(projectPath=" + this.projectPath + ", yamlConfigPath=" + this.yamlConfigPath + ", outPath=" + this.outPath + ", resultsStorage=" + this.resultsStorage + ", baseline=" + this.baseline + ", profile=" + this.profile + ", profileSource=" + this.profileSource + ", defaultProfileName=" + this.defaultProfileName + ", disableSanityInspections=" + this.disableSanityInspections + ", fixesStrategy=" + this.fixesStrategy + ", runPromoInspections=" + this.runPromoInspections + ", script=" + this.script + ", includeAbsent=" + this.includeAbsent + ", outputFormat=" + this.outputFormat + ", license=" + this.license + ", coveragePath=" + this.coveragePath + ", sourceDirectory=" + this.sourceDirectory + ", exclude=" + this.exclude + ", include=" + this.include + ", bootstrap=" + this.bootstrap + ", maxRuntimeNotifications=" + this.maxRuntimeNotifications + ", failOnErrorNotification=" + this.failOnErrorNotification + ", failureConditions=" + this.failureConditions + ", skipPreamble=" + this.skipPreamble + ", skipResultOutput=" + this.skipResultOutput + ", stopThreshold=" + this.stopThreshold + ", fileSuspendThreshold=" + this.fileSuspendThreshold + ", moduleSuspendThreshold=" + this.moduleSuspendThreshold + ", projectSuspendThreshold=" + this.projectSuspendThreshold + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.projectPath).hashCode();
        result2 = result2 * 31 + (this.yamlConfigPath == null ? 0 : ((Object)this.yamlConfigPath).hashCode());
        result2 = result2 * 31 + ((Object)this.outPath).hashCode();
        result2 = result2 * 31 + ((Object)this.resultsStorage).hashCode();
        result2 = result2 * 31 + (this.baseline == null ? 0 : this.baseline.hashCode());
        result2 = result2 * 31 + this.profile.hashCode();
        result2 = result2 * 31 + this.profileSource.hashCode();
        result2 = result2 * 31 + this.defaultProfileName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.disableSanityInspections);
        result2 = result2 * 31 + this.fixesStrategy.hashCode();
        result2 = result2 * 31 + (this.runPromoInspections == null ? 0 : ((Object)this.runPromoInspections).hashCode());
        result2 = result2 * 31 + this.script.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.includeAbsent);
        result2 = result2 * 31 + this.outputFormat.hashCode();
        result2 = result2 * 31 + this.license.hashCode();
        result2 = result2 * 31 + ((Object)this.coveragePath).hashCode();
        result2 = result2 * 31 + (this.sourceDirectory == null ? 0 : this.sourceDirectory.hashCode());
        result2 = result2 * 31 + ((Object)this.exclude).hashCode();
        result2 = result2 * 31 + ((Object)this.include).hashCode();
        result2 = result2 * 31 + (this.bootstrap == null ? 0 : this.bootstrap.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.maxRuntimeNotifications);
        result2 = result2 * 31 + Boolean.hashCode(this.failOnErrorNotification);
        result2 = result2 * 31 + this.failureConditions.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.skipPreamble);
        result2 = result2 * 31 + Boolean.hashCode(this.skipResultOutput);
        result2 = result2 * 31 + (this.stopThreshold == null ? 0 : ((Object)this.stopThreshold).hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.fileSuspendThreshold);
        result2 = result2 * 31 + Integer.hashCode(this.moduleSuspendThreshold);
        result2 = result2 * 31 + Integer.hashCode(this.projectSuspendThreshold);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QodanaConfig)) {
            return false;
        }
        QodanaConfig qodanaConfig = (QodanaConfig)other;
        if (!Intrinsics.areEqual((Object)this.projectPath, (Object)qodanaConfig.projectPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.yamlConfigPath, (Object)qodanaConfig.yamlConfigPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outPath, (Object)qodanaConfig.outPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resultsStorage, (Object)qodanaConfig.resultsStorage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseline, (Object)qodanaConfig.baseline)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile, (Object)qodanaConfig.profile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profileSource, (Object)qodanaConfig.profileSource)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultProfileName, (Object)qodanaConfig.defaultProfileName)) {
            return false;
        }
        if (this.disableSanityInspections != qodanaConfig.disableSanityInspections) {
            return false;
        }
        if (this.fixesStrategy != qodanaConfig.fixesStrategy) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runPromoInspections, (Object)qodanaConfig.runPromoInspections)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.script, (Object)qodanaConfig.script)) {
            return false;
        }
        if (this.includeAbsent != qodanaConfig.includeAbsent) {
            return false;
        }
        if (this.outputFormat != qodanaConfig.outputFormat) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.license, (Object)qodanaConfig.license)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.coveragePath, (Object)qodanaConfig.coveragePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceDirectory, (Object)qodanaConfig.sourceDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.exclude, qodanaConfig.exclude)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.include, qodanaConfig.include)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bootstrap, (Object)qodanaConfig.bootstrap)) {
            return false;
        }
        if (this.maxRuntimeNotifications != qodanaConfig.maxRuntimeNotifications) {
            return false;
        }
        if (this.failOnErrorNotification != qodanaConfig.failOnErrorNotification) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureConditions, (Object)qodanaConfig.failureConditions)) {
            return false;
        }
        if (this.skipPreamble != qodanaConfig.skipPreamble) {
            return false;
        }
        if (this.skipResultOutput != qodanaConfig.skipResultOutput) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stopThreshold, (Object)qodanaConfig.stopThreshold)) {
            return false;
        }
        if (this.fileSuspendThreshold != qodanaConfig.fileSuspendThreshold) {
            return false;
        }
        if (this.moduleSuspendThreshold != qodanaConfig.moduleSuspendThreshold) {
            return false;
        }
        return this.projectSuspendThreshold == qodanaConfig.projectSuspendThreshold;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u008b\u0002\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00062\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020!0 j\u0002`\"2\u0012\b\u0002\u0010#\u001a\f\u0012\u0004\u0012\u00020!0 j\u0002`\"2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig$Companion;", "", "()V", "fromYaml", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "projectPath", "Ljava/nio/file/Path;", "outPath", "yamlConfigPath", "yaml", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;", "resultsStorage", "baseline", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "defaultProfileName", "disableSanityInspections", "", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "runPromoInspections", "script", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "includeAbsent", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "license", "Lorg/jetbrains/qodana/license/QodanaLicense;", "coveragePath", "sourceDirectory", "exclude", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScopes;", "include", "bootstrap", "maxRuntimeNotifications", "", "failOnErrorNotification", "failureConditions", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;ZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicense;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;)Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaConfig fromYaml(@NotNull Path projectPath, @NotNull Path outPath, @Nullable Path yamlConfigPath, @NotNull QodanaYamlConfig yaml, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull OutputFormat outputFormat, @NotNull QodanaLicense license, @NotNull Path coveragePath, @Nullable String sourceDirectory, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap, int maxRuntimeNotifications, boolean failOnErrorNotification, @NotNull FailureConditions failureConditions) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
            Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
            Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
            Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            Intrinsics.checkNotNullParameter((Object)license, (String)"license");
            Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
            Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
            Intrinsics.checkNotNullParameter(include, (String)"include");
            Intrinsics.checkNotNullParameter((Object)failureConditions, (String)"failureConditions");
            if (!Intrinsics.areEqual((Object)yaml.getVersion(), (Object)"1.0")) {
                throw new QodanaException("Property \"version\" in qodana.yaml must be \"1.0\", not \"" + yaml.getVersion() + "\"");
            }
            String string = Intrinsics.areEqual((Object)profile2, (Object)yaml.getProfile()) ? "qodana.yaml" : "command line";
            return new QodanaConfig(projectPath, yamlConfigPath, outPath, resultsStorage, baseline, profile2, string, defaultProfileName, disableSanityInspections, fixesStrategy, runPromoInspections, script, includeAbsent, outputFormat, license, coveragePath, sourceDirectory, exclude2, include, bootstrap, maxRuntimeNotifications, failOnErrorNotification, failureConditions, false, false, null, 0, 0, 0, 528482304, null);
        }

        public static /* synthetic */ QodanaConfig fromYaml$default(Companion companion, Path path, Path path2, Path path3, QodanaYamlConfig qodanaYamlConfig, Path path4, String string, QodanaProfileConfig qodanaProfileConfig, String string2, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, OutputFormat outputFormat, QodanaLicense qodanaLicense, Path path5, String string3, List list2, List list3, String string4, int n, boolean bl4, FailureConditions failureConditions, int n2, Object object) {
            if ((n2 & 4) != 0) {
                path3 = null;
            }
            if ((n2 & 8) != 0) {
                qodanaYamlConfig = QodanaYamlConfig.Companion.getEMPTY_V1();
            }
            if ((n2 & 0x10) != 0) {
                path4 = QodanaConfigKt.getResultsStorage(path2, OutputFormatKt.getOutputFormat());
            }
            if ((n2 & 0x20) != 0) {
                string = null;
            }
            if ((n2 & 0x40) != 0) {
                qodanaProfileConfig = qodanaYamlConfig.getProfile();
            }
            if ((n2 & 0x80) != 0) {
                string2 = QodanaConfigKt.access$getDefaultProfileName();
            }
            if ((n2 & 0x100) != 0) {
                bl = qodanaYamlConfig.getDisableSanityInspections();
            }
            if ((n2 & 0x200) != 0) {
                fixesStrategy = FixesStrategy.Companion.fromString(qodanaYamlConfig.getFixesStrategy());
            }
            if ((n2 & 0x400) != 0) {
                bl2 = qodanaYamlConfig.getRunPromoInspections();
            }
            if ((n2 & 0x800) != 0) {
                qodanaScriptConfig = qodanaYamlConfig.getScript();
            }
            if ((n2 & 0x1000) != 0) {
                bl3 = qodanaYamlConfig.getIncludeAbsent();
            }
            if ((n2 & 0x2000) != 0) {
                outputFormat = OutputFormatKt.getOutputFormat();
            }
            if ((n2 & 0x4000) != 0) {
                qodanaLicense = new QodanaLicense(QodanaLicenseType.ULTIMATE_PLUS, false, null);
            }
            if ((n2 & 0x8000) != 0) {
                Path path6 = path2.resolve("coverage/");
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
                path5 = path6;
            }
            if ((n2 & 0x10000) != 0) {
                string3 = null;
            }
            if ((n2 & 0x20000) != 0) {
                list2 = qodanaYamlConfig.getExclude();
            }
            if ((n2 & 0x40000) != 0) {
                list3 = qodanaYamlConfig.getInclude();
            }
            if ((n2 & 0x80000) != 0) {
                string4 = qodanaYamlConfig.getBootstrap();
            }
            if ((n2 & 0x100000) != 0) {
                n = qodanaYamlConfig.getMaxRuntimeNotifications();
            }
            if ((n2 & 0x200000) != 0) {
                bl4 = qodanaYamlConfig.getFailOnErrorNotification();
            }
            if ((n2 & 0x400000) != 0) {
                failureConditions = qodanaYamlConfig.getFailureConditions();
            }
            return companion.fromYaml(path, path2, path3, qodanaYamlConfig, path4, string, qodanaProfileConfig, string2, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, outputFormat, qodanaLicense, path5, string3, list2, list3, string4, n, bl4, failureConditions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

