/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.notifications.QodanaNotifications;
import org.jetbrains.qodana.report.LoadedSarif;
import org.jetbrains.qodana.report.ReportResult;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.ValidatedSarif;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator;", "", "()V", "getNotificationContentFromSource", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "validationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "reportSource", "getValidatorError", "report", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "validateReport", "Lorg/jetbrains/qodana/report/ReportResult;", "Lorg/jetbrains/qodana/report/ValidatedSarif;", "EmptyRuns", "NoResults", "NoRuns", "NoTool", "ValidatorError", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nReportValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportValidator.kt\norg/jetbrains/qodana/report/ReportValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1#2:63\n1726#3,3:64\n1726#3,3:67\n*S KotlinDebug\n*F\n+ 1 ReportValidator.kt\norg/jetbrains/qodana/report/ReportValidator\n*L\n23#1:64,3\n24#1:67,3\n*E\n"})
public final class ReportValidator {
    @NotNull
    public static final ReportValidator INSTANCE = new ReportValidator();

    private ReportValidator() {
    }

    @NotNull
    public final ReportResult<ValidatedSarif, ValidatorError> validateReport(@NotNull SarifReport report2) {
        ReportResult reportResult;
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        ValidatorError validatorError = this.getValidatorError(report2);
        if (validatorError != null) {
            ValidatorError it = validatorError;
            boolean bl = false;
            reportResult = new ReportResult.Fail<ReportResult.Error>(it);
        } else {
            reportResult = new ReportResult.Success<LoadedSarif>(new ValidatedSarif(report2));
        }
        return reportResult;
    }

    private final ValidatorError getValidatorError(SarifReport report2) {
        ValidatorError validatorError;
        if (report2.getRuns() == null) {
            validatorError = NoRuns.INSTANCE;
        } else if (report2.getRuns().isEmpty()) {
            validatorError = EmptyRuns.INSTANCE;
        } else {
            Run it;
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block12: {
                List list2 = report2.getRuns();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRuns(...)");
                $this$all$iv = list2;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (Run)element$iv;
                        boolean bl2 = false;
                        if (it.getResults() == null) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                validatorError = NoResults.INSTANCE;
            } else {
                boolean bl3;
                block13: {
                    List list3 = report2.getRuns();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getRuns(...)");
                    $this$all$iv = list3;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (Run)element$iv;
                            boolean bl4 = false;
                            if (it.getTool() == null) continue;
                            bl3 = false;
                            break block13;
                        }
                        bl3 = true;
                    }
                }
                validatorError = bl3 ? (ValidatorError)NoTool.INSTANCE : null;
            }
        }
        return validatorError;
    }

    @NotNull
    public final String getNotificationContentFromSource(@NotNull ValidatorError validationError, @NotNull String reportSource) {
        String string;
        Intrinsics.checkNotNullParameter((Object)validationError, (String)"validationError");
        Intrinsics.checkNotNullParameter((Object)reportSource, (String)"reportSource");
        ValidatorError validatorError = validationError;
        if (Intrinsics.areEqual((Object)validatorError, (Object)NoRuns.INSTANCE)) {
            Object[] objectArray = new Object[]{reportSource};
            String string2 = QodanaBundle.message("notification.content.failed.validation.no.runs", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (Intrinsics.areEqual((Object)validatorError, (Object)EmptyRuns.INSTANCE)) {
            Object[] objectArray = new Object[]{reportSource};
            String string3 = QodanaBundle.message("notification.content.failed.validation.empty.runs", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (Intrinsics.areEqual((Object)validatorError, (Object)NoResults.INSTANCE)) {
            Object[] objectArray = new Object[]{reportSource};
            String string4 = QodanaBundle.message("notification.content.failed.validation.no.results", objectArray);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else if (Intrinsics.areEqual((Object)validatorError, (Object)NoTool.INSTANCE)) {
            Object[] objectArray = new Object[]{reportSource};
            String string5 = QodanaBundle.message("notification.content.failed.validation.no.tool", objectArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$EmptyRuns;", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "()V", "intellij.qodana"})
    public static final class EmptyRuns
    extends ValidatorError {
        @NotNull
        public static final EmptyRuns INSTANCE = new EmptyRuns();

        private EmptyRuns() {
            super(null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$NoResults;", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "()V", "intellij.qodana"})
    public static final class NoResults
    extends ValidatorError {
        @NotNull
        public static final NoResults INSTANCE = new NoResults();

        private NoResults() {
            super(null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$NoRuns;", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "()V", "intellij.qodana"})
    public static final class NoRuns
    extends ValidatorError {
        @NotNull
        public static final NoRuns INSTANCE = new NoRuns();

        private NoRuns() {
            super(null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$NoTool;", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "()V", "intellij.qodana"})
    public static final class NoTool
    extends ValidatorError {
        @NotNull
        public static final NoTool INSTANCE = new NoTool();

        private NoTool() {
            super(null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u0082\u0001\u0004\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "Lorg/jetbrains/qodana/report/ReportResult$Error;", "()V", "spawnNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "contentProvider", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "throwException", "", "Lorg/jetbrains/qodana/report/ReportValidator$EmptyRuns;", "Lorg/jetbrains/qodana/report/ReportValidator$NoResults;", "Lorg/jetbrains/qodana/report/ReportValidator$NoRuns;", "Lorg/jetbrains/qodana/report/ReportValidator$NoTool;", "intellij.qodana"})
    public static abstract class ValidatorError
    implements ReportResult.Error<ValidatorError> {
        private ValidatorError() {
        }

        @Override
        @NotNull
        public Void throwException() {
            throw new IllegalStateException(("Error during report validation: " + this).toString());
        }

        @Override
        public void spawnNotification(@Nullable Project project, @NotNull Function1<? super ValidatorError, String> contentProvider) {
            Intrinsics.checkNotNullParameter(contentProvider, (String)"contentProvider");
            Notification notification2 = QodanaNotifications.notification$default(QodanaNotifications.General.INSTANCE, QodanaBundle.message("notification.title.cant.parse.report", new Object[0]), (String)contentProvider.invoke((Object)this), NotificationType.WARNING, false, 8, null);
            notification2.addAction((AnAction)NotificationAction.createSimple((String)QodanaBundle.message("notification.action.about.qodana.sarif.format", new Object[0]), (Runnable)spawnNotification.1.INSTANCE));
            notification2.notify(project);
        }

        public /* synthetic */ ValidatorError(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

