/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.NumberFormat;
import com.vladsch.flexmark.util.misc.Utils;

public class FormattedCounter {
    private final NumberFormat numberFormat;
    private final Boolean isLowercase;
    private final String delimiter;
    private int count;

    public FormattedCounter(NumberFormat format2, Boolean lowercase, String delimiter) {
        this.numberFormat = format2;
        this.isLowercase = lowercase;
        this.delimiter = delimiter;
        this.reset();
    }

    public void reset() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public int nextCount() {
        return ++this.count;
    }

    public String getFormatted(boolean withDelimiter) {
        String s = NumberFormat.getFormat(this.numberFormat, Utils.minLimit(this.count, 1));
        String o = this.isLowercase == null ? s : (this.isLowercase != false ? s.toLowerCase() : s.toUpperCase());
        return withDelimiter && this.delimiter != null && !this.delimiter.isEmpty() ? o + this.delimiter : o;
    }
}

