/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.UriContentResolver;
import com.vladsch.flexmark.html.UriContentResolverFactory;
import com.vladsch.flexmark.html.renderer.FileUriContentResolver;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedContent;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.dependency.FirstDependent;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeNodePostProcessor
extends NodePostProcessor {
    final HashMap<JekyllTag, String> includedDocuments = new HashMap();
    final HashMap<String, ResolvedLink> resolvedLinks = new HashMap();
    final Parser parser;
    final List<LinkResolver> linkResolvers;
    final List<UriContentResolver> contentResolvers;
    final boolean isIncluding = false;
    final Document document;
    final LinkResolverBasicContext context;
    private final boolean embedIncludedContent;
    private final Map<String, String> includedHtml;

    public IncludeNodePostProcessor(final @NotNull Document document2) {
        this.document = document2;
        this.parser = Parser.builder(document2).build();
        this.context = new LinkResolverBasicContext(){

            @Override
            @NotNull
            public DataHolder getOptions() {
                return document2;
            }

            @Override
            @NotNull
            public Document getDocument() {
                return document2;
            }
        };
        List<LinkResolverFactory> linkResolverFactories = DependencyResolver.resolveFlatDependencies(JekyllTagExtension.LINK_RESOLVER_FACTORIES.get(document2), null, null);
        this.linkResolvers = new ArrayList<LinkResolver>(linkResolverFactories.size());
        for (LinkResolverFactory resolverFactory : linkResolverFactories) {
            this.linkResolvers.add(resolverFactory.apply(this.context));
        }
        List<UriContentResolverFactory> resolverFactories = JekyllTagExtension.CONTENT_RESOLVER_FACTORIES.get(document2);
        if (resolverFactories.isEmpty()) {
            resolverFactories = Collections.singletonList(new FileUriContentResolver.Factory());
        }
        List<UriContentResolverFactory> contentResolverFactories = DependencyResolver.resolveFlatDependencies(resolverFactories, null, null);
        this.contentResolvers = new ArrayList<UriContentResolver>(contentResolverFactories.size());
        for (UriContentResolverFactory resolverFactory : contentResolverFactories) {
            this.contentResolvers.add(resolverFactory.apply(this.context));
        }
        this.embedIncludedContent = JekyllTagExtension.EMBED_INCLUDED_CONTENT.get(document2);
        this.includedHtml = JekyllTagExtension.INCLUDED_HTML.get(document2);
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        if (node instanceof JekyllTag && !this.includedDocuments.containsKey(node)) {
            JekyllTag jekyllTag = (JekyllTag)node;
            if (this.embedIncludedContent && jekyllTag.getTag().equals("include")) {
                BasedSequence parameters = jekyllTag.getParameters();
                String rawUrl = parameters.unescape();
                String fileContent = null;
                if (this.includedHtml != null && this.includedHtml.containsKey(rawUrl)) {
                    fileContent = this.includedHtml.get(rawUrl);
                } else {
                    Object linkResolver;
                    ResolvedLink resolvedLink = this.resolvedLinks.get(rawUrl);
                    if (resolvedLink == null) {
                        resolvedLink = new ResolvedLink(LinkType.LINK, rawUrl);
                        Iterator<LinkResolver> iterator = this.linkResolvers.iterator();
                        while (iterator.hasNext() && (resolvedLink = (linkResolver = iterator.next()).resolveLink(node, this.context, resolvedLink)).getStatus() == LinkStatus.UNKNOWN) {
                        }
                        this.resolvedLinks.put(rawUrl, resolvedLink);
                    }
                    if (resolvedLink.getStatus() == LinkStatus.VALID) {
                        UriContentResolver contentResolver;
                        ResolvedContent resolvedContent = new ResolvedContent(resolvedLink, LinkStatus.UNKNOWN, null);
                        linkResolver = this.contentResolvers.iterator();
                        while (linkResolver.hasNext() && (resolvedContent = (contentResolver = (UriContentResolver)linkResolver.next()).resolveContent(node, this.context, resolvedContent)).getStatus() == LinkStatus.UNKNOWN) {
                        }
                        if (resolvedContent.getStatus() == LinkStatus.VALID) {
                            try {
                                fileContent = new String(resolvedContent.getContent(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (fileContent != null && !fileContent.isEmpty()) {
                    this.includedDocuments.put(jekyllTag, fileContent);
                    Document includedDoc = this.parser.parse(fileContent);
                    this.parser.transferReferences(this.document, includedDoc, null);
                    if (includedDoc.contains(Parser.REFERENCES)) {
                        this.document.set(HtmlRenderer.RECHECK_UNDEFINED_REFERENCES, Boolean.valueOf(true));
                    }
                    Node child = includedDoc.getFirstChild();
                    if (!(jekyllTag.getParent() instanceof JekyllTagBlock) && child instanceof Paragraph && child.getNext() == null) {
                        child = child.getFirstChild();
                    }
                    while (child != null) {
                        Node next = child.getNext();
                        node.appendChild(child);
                        state.nodeAddedWithDescendants(child);
                        child = next;
                    }
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(JekyllTag.class);
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return Collections.singleton(FirstDependent.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document2) {
            return new IncludeNodePostProcessor(document2);
        }
    }
}

