/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import org.jetbrains.annotations.NotNull;

public class AnchorLinkNodePostProcessor
extends NodePostProcessor {
    private final AnchorLinkOptions options;

    public AnchorLinkNodePostProcessor(DataHolder options) {
        this.options = new AnchorLinkOptions(options);
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        Heading heading;
        if (node instanceof Heading && (heading = (Heading)node).getText().isNotNull()) {
            AnchorLink anchor = new AnchorLink();
            if (!this.options.wrapText) {
                if (heading.getFirstChild() == null) {
                    anchor.setChars(heading.getText().subSequence(0, 0));
                    heading.appendChild(anchor);
                } else {
                    anchor.setChars(heading.getFirstChild().getChars().subSequence(0, 0));
                    heading.getFirstChild().insertBefore(anchor);
                }
            } else {
                anchor.takeChildren(heading);
                heading.appendChild(anchor);
            }
            anchor.setCharsFromContent();
            state.nodeAdded(anchor);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory(DataHolder options) {
            super(false);
            if (AnchorLinkExtension.ANCHORLINKS_NO_BLOCK_QUOTE.get(options).booleanValue()) {
                this.addNodeWithExclusions(Heading.class, BlockQuote.class);
            } else {
                this.addNodes(Heading.class);
            }
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document2) {
            return new AnchorLinkNodePostProcessor(document2);
        }
    }
}

