/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwx;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jose4j.base64url.Base64Url;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.JsonHelp;

public class Headers {
    protected Base64Url base64url = new Base64Url();
    private Map<String, Object> headerMap = new LinkedHashMap<String, Object>();
    private String header;
    private String encodedHeader;

    public String getFullHeaderAsJsonString() {
        if (this.header == null) {
            this.header = JsonUtil.toJson(this.headerMap);
        }
        return this.header;
    }

    public String getEncodedHeader() {
        if (this.encodedHeader == null) {
            String headerAsString = this.getFullHeaderAsJsonString();
            this.encodedHeader = this.base64url.base64UrlEncodeUtf8ByteRepresentation(headerAsString);
        }
        return this.encodedHeader;
    }

    public void setStringHeaderValue(String name2, String value2) {
        this.setObjectHeaderValue(name2, value2);
    }

    public void setObjectHeaderValue(String name2, Object value2) {
        this.headerMap.put(name2, value2);
        this.header = null;
        this.encodedHeader = null;
    }

    public void setJwkHeaderValue(String name2, JsonWebKey jwk) {
        Map<String, Object> jwkParams = jwk.toParams(JsonWebKey.OutputControlLevel.PUBLIC_ONLY);
        this.setObjectHeaderValue(name2, jwkParams);
    }

    public String getStringHeaderValue(String headerName) {
        return JsonHelp.getString(this.headerMap, headerName);
    }

    public Long getLongHeaderValue(String headerName) {
        return JsonHelp.getLong(this.headerMap, headerName);
    }

    public Object getObjectHeaderValue(String name2) {
        return this.headerMap.get(name2);
    }

    @Deprecated
    public JsonWebKey getJwkHeaderValue(String name2) throws JoseException {
        return this.getPublicJwkHeaderValue(name2, null);
    }

    public PublicJsonWebKey getPublicJwkHeaderValue(String name2, String jcaProvider) throws JoseException {
        Object objectHeaderValue = this.getObjectHeaderValue(name2);
        Map jwkParams = (Map)objectHeaderValue;
        if (jwkParams != null) {
            PublicJsonWebKey publicJsonWebKey = PublicJsonWebKey.Factory.newPublicJwk(jwkParams, jcaProvider);
            if (publicJsonWebKey.getPrivateKey() != null) {
                throw new JoseException(name2 + " header contains a private key, which it most definitely should not.");
            }
            return publicJsonWebKey;
        }
        return null;
    }

    public void setFullHeaderAsJsonString(String header) throws JoseException {
        this.encodedHeader = null;
        this.header = header;
        this.headerMap = JsonUtil.parseJson(header);
    }

    void setEncodedHeader(String encodedHeader) throws JoseException {
        this.encodedHeader = encodedHeader;
        this.header = this.base64url.base64UrlDecodeToUtf8String(this.encodedHeader);
        this.headerMap = JsonUtil.parseJson(this.header);
    }
}

