/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.KeyOperations;
import org.jose4j.jwk.SimpleJwkFilter;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;

class SelectorSupport {
    private static final String[] VERIFY_OPS = new String[]{KeyOperations.VERIFY};
    private static final String[] DECRYPT_OPS = new String[]{KeyOperations.DECRYPT, KeyOperations.DERIVE_KEY, KeyOperations.UNWRAP_KEY};

    SelectorSupport() {
    }

    public static SimpleJwkFilter filterForInboundSigned(JsonWebSignature jws) throws JoseException {
        SimpleJwkFilter filter2 = SelectorSupport.commonFilterForInbound(jws);
        filter2.setUse("sig", SimpleJwkFilter.OMITTED_OKAY);
        filter2.setKeyOperations(VERIFY_OPS, SimpleJwkFilter.OMITTED_OKAY);
        return filter2;
    }

    public static SimpleJwkFilter filterForInboundEncrypted(JsonWebEncryption jwe) throws JoseException {
        SimpleJwkFilter filter2 = SelectorSupport.commonFilterForInbound(jwe);
        filter2.setUse("enc", SimpleJwkFilter.OMITTED_OKAY);
        filter2.setKeyOperations(DECRYPT_OPS, SimpleJwkFilter.OMITTED_OKAY);
        return filter2;
    }

    private static SimpleJwkFilter commonFilterForInbound(JsonWebStructure jwx) throws JoseException {
        SimpleJwkFilter filter2 = new SimpleJwkFilter();
        String kid = jwx.getKeyIdHeaderValue();
        if (kid != null) {
            filter2.setKid(kid, SimpleJwkFilter.VALUE_REQUIRED);
        }
        String x5t = jwx.getX509CertSha1ThumbprintHeaderValue();
        String x5tS256 = jwx.getX509CertSha256ThumbprintHeaderValue();
        filter2.setAllowFallbackDeriveFromX5cForX5Thumbs(true);
        if (x5t != null) {
            filter2.setX5t(x5t, SimpleJwkFilter.OMITTED_OKAY);
        }
        if (x5tS256 != null) {
            filter2.setX5tS256(x5tS256, SimpleJwkFilter.OMITTED_OKAY);
        }
        String keyType = jwx.getAlgorithmNoConstraintCheck().getKeyType();
        filter2.setKty(keyType);
        return filter2;
    }
}

