/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwk;

import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.base64url.Base64Url;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.OctetKeyPairJsonWebKey;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.lang.HashUtil;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.JsonHelp;
import org.jose4j.lang.StringUtil;

public abstract class JsonWebKey
implements Serializable {
    public static final String KEY_TYPE_PARAMETER = "kty";
    public static final String USE_PARAMETER = "use";
    public static final String KEY_ID_PARAMETER = "kid";
    public static final String ALGORITHM_PARAMETER = "alg";
    public static final String KEY_OPERATIONS = "key_ops";
    private String use;
    private String keyId;
    private String algorithm;
    private List<String> keyOps;
    protected Map<String, Object> otherParameters = new LinkedHashMap<String, Object>();
    protected Key key;

    protected JsonWebKey(Key key2) {
        this.key = key2;
    }

    protected JsonWebKey(Map<String, Object> params) throws JoseException {
        this.otherParameters.putAll(params);
        this.removeFromOtherParams(KEY_TYPE_PARAMETER, USE_PARAMETER, KEY_ID_PARAMETER, ALGORITHM_PARAMETER, KEY_OPERATIONS);
        this.setUse(JsonWebKey.getString(params, USE_PARAMETER));
        this.setKeyId(JsonWebKey.getString(params, KEY_ID_PARAMETER));
        this.setAlgorithm(JsonWebKey.getString(params, ALGORITHM_PARAMETER));
        if (params.containsKey(KEY_OPERATIONS)) {
            this.keyOps = JsonHelp.getStringArray(params, KEY_OPERATIONS);
        }
    }

    public abstract String getKeyType();

    protected abstract void fillTypeSpecificParams(Map<String, Object> var1, OutputControlLevel var2);

    public PublicKey getPublicKey() {
        try {
            return (PublicKey)this.key;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key getKey() {
        return this.key;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public List<String> getKeyOps() {
        return this.keyOps;
    }

    public void setKeyOps(List<String> keyOps) {
        this.keyOps = keyOps;
    }

    public void setOtherParameter(String name2, Object value2) {
        this.otherParameters.put(name2, value2);
    }

    public <T> T getOtherParameterValue(String name2, Class<T> type) {
        Object o = this.otherParameters.get(name2);
        return type.cast(o);
    }

    protected void removeFromOtherParams(String ... names2) {
        for (String name2 : names2) {
            this.otherParameters.remove(name2);
        }
    }

    public Map<String, Object> toParams(OutputControlLevel outputLevel) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(KEY_TYPE_PARAMETER, this.getKeyType());
        this.putIfNotNull(KEY_ID_PARAMETER, this.getKeyId(), params);
        this.putIfNotNull(USE_PARAMETER, this.getUse(), params);
        this.putIfNotNull(KEY_OPERATIONS, this.keyOps, params);
        this.putIfNotNull(ALGORITHM_PARAMETER, this.getAlgorithm(), params);
        this.fillTypeSpecificParams(params, outputLevel);
        params.putAll(this.otherParameters);
        return params;
    }

    public String toJson() {
        return this.toJson(OutputControlLevel.INCLUDE_SYMMETRIC);
    }

    public String toJson(OutputControlLevel outputLevel) {
        Map<String, Object> params = this.toParams(outputLevel);
        return JsonUtil.toJson(params);
    }

    public String toString() {
        return this.getClass().getName() + this.toParams(OutputControlLevel.PUBLIC_ONLY);
    }

    public String calculateBase64urlEncodedThumbprint(String hashAlgorithm) {
        byte[] thumbprint = this.calculateThumbprint(hashAlgorithm);
        return Base64Url.encode(thumbprint);
    }

    public byte[] calculateThumbprint(String hashAlgorithm) {
        MessageDigest digest = HashUtil.getMessageDigest(hashAlgorithm);
        String hashInputString = this.produceThumbprintHashInput();
        byte[] hashInputBytes = StringUtil.getBytesUtf8(hashInputString);
        return digest.digest(hashInputBytes);
    }

    public String calculateThumbprintUri(String hashAlgorithm) {
        if (!hashAlgorithm.equals("SHA-256")) {
            throw new UnsupportedOperationException("Only SHA-256 algorithm supported at this time for Thumbprint URIs");
        }
        return "urn:ietf:params:oauth:jwk-thumbprint:sha-256:" + this.calculateBase64urlEncodedThumbprint(hashAlgorithm);
    }

    protected abstract String produceThumbprintHashInput();

    protected void putIfNotNull(String name2, Object value2, Map<String, Object> params) {
        if (value2 != null) {
            params.put(name2, value2);
        }
    }

    protected static String getString(Map<String, Object> params, String name2) throws JoseException {
        return JsonHelp.getStringChecked(params, name2);
    }

    protected static String getStringRequired(Map<String, Object> params, String name2) throws JoseException {
        return JsonWebKey.getString(params, name2, true);
    }

    protected static String getString(Map<String, Object> params, String name2, boolean required) throws JoseException {
        String value2 = JsonWebKey.getString(params, name2);
        if (value2 == null && required) {
            throw new JoseException("Missing required '" + name2 + "' parameter.");
        }
        return value2;
    }

    public static enum OutputControlLevel {
        INCLUDE_PRIVATE,
        INCLUDE_SYMMETRIC,
        PUBLIC_ONLY;

    }

    public static class Factory {
        public static JsonWebKey newJwk(Map<String, Object> params) throws JoseException {
            String kty;
            switch (kty = JsonWebKey.getStringRequired(params, JsonWebKey.KEY_TYPE_PARAMETER)) {
                case "RSA": {
                    return new RsaJsonWebKey(params);
                }
                case "EC": {
                    return new EllipticCurveJsonWebKey(params);
                }
                case "OKP": {
                    return new OctetKeyPairJsonWebKey(params);
                }
                case "oct": {
                    return new OctetSequenceJsonWebKey(params);
                }
            }
            throw new JoseException("Unknown key type algorithm: '" + kty + "'");
        }

        public static JsonWebKey newJwk(Key key2) throws JoseException {
            if (RSAPublicKey.class.isInstance(key2)) {
                return new RsaJsonWebKey((RSAPublicKey)key2);
            }
            if (ECPublicKey.class.isInstance(key2)) {
                return new EllipticCurveJsonWebKey((ECPublicKey)key2);
            }
            if (PublicKey.class.isInstance(key2)) {
                if (OctetKeyPairJsonWebKey.isApplicable(key2)) {
                    return new OctetKeyPairJsonWebKey((PublicKey)key2);
                }
                throw new JoseException("Unsupported or unknown public key (alg=" + key2.getAlgorithm() + ") " + key2);
            }
            return new OctetSequenceJsonWebKey(key2);
        }

        public static JsonWebKey newJwk(String json) throws JoseException {
            Map<String, Object> parsed = JsonUtil.parseJson(json);
            return Factory.newJwk(parsed);
        }
    }
}

