/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.jose4j.lang.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherStrengthSupport {
    private static final Logger log = LoggerFactory.getLogger(CipherStrengthSupport.class);

    public static boolean isAvailable(String algorithm, int keyByteLength) {
        boolean isAvailable2;
        int bitKeyLength = ByteUtil.bitLength(keyByteLength);
        try {
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(algorithm);
            boolean bl = isAvailable2 = bitKeyLength <= maxAllowedKeyLength;
            if (!isAvailable2) {
                log.debug("max allowed key length for {} is {}", (Object)algorithm, (Object)maxAllowedKeyLength);
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("Unknown/unsupported algorithm, {} {}", (Object)algorithm, (Object)e);
            isAvailable2 = false;
        }
        return isAvailable2;
    }
}

