/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.labels;

import io.kubernetes.client.util.labels.LabelMatcher;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SetMatcher
implements LabelMatcher {
    private Operator operator;
    private String key;
    private String[] values;

    SetMatcher(String key2, Operator operator) {
        this(key2, operator, new String[0]);
    }

    SetMatcher(String key2, Operator operator, String[] values2) {
        this.key = key2;
        this.operator = operator;
        this.values = values2;
    }

    public static SetMatcher in(String key2, String ... values2) {
        return new SetMatcher(key2, Operator.IN, values2);
    }

    public static SetMatcher notIn(String key2, String ... values2) {
        return new SetMatcher(key2, Operator.NOT_IN, values2);
    }

    public static SetMatcher exists(String key2) {
        return new SetMatcher(key2, Operator.EXISTS);
    }

    public static SetMatcher notExists(String key2) {
        return new SetMatcher(key2, Operator.NOT_EXISTS);
    }

    public String toString() {
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                return this.key + " " + this.operator.name + " " + "(" + Arrays.stream(this.values).collect(Collectors.joining(",")) + ")";
            }
            case EXISTS: 
            case NOT_EXISTS: {
                return this.operator.name + this.key;
            }
        }
        throw new IllegalStateException("unknown operator " + this.operator.name);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean test(String s) {
        return this.operator.with(this.values).test(s);
    }

    private static enum Operator {
        IN("in", args -> v -> Operator.contains(args, v)),
        NOT_IN("notin", args -> v -> !Operator.contains(args, v)),
        EXISTS("", args -> v -> v != null),
        NOT_EXISTS("!", args -> v -> v == null);

        private final String name;
        private final Function<String[], Predicate<String>> matcherFunc;

        private Operator(String name2, Function<String[], Predicate<String>> matcherFunc) {
            this.name = name2;
            this.matcherFunc = matcherFunc;
        }

        public String getName() {
            return this.name;
        }

        Predicate<String> with(String ... values2) {
            return this.matcherFunc.apply(values2);
        }

        private static boolean contains(String[] strs, String s) {
            return Arrays.stream(strs).anyMatch(arg -> arg.equals(s));
        }
    }
}

