/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.authenticators;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.authenticators.Authenticator;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AzureActiveDirectoryAuthenticator
implements Authenticator {
    private static final String ACCESS_TOKEN = "access-token";
    private static final String EXPIRES_ON = "expires-on";
    private static final String TENANT_ID = "tenant-id";
    private static final String CLIENT_ID = "client-id";
    private static final String REFRESH_TOKEN = "refresh-token";

    @Override
    public String getName() {
        return "azure";
    }

    @Override
    public String getToken(Map<String, Object> config2) {
        return (String)config2.get(ACCESS_TOKEN);
    }

    @Override
    public boolean isExpired(Map<String, Object> config2) {
        String expiresOn = (String)config2.get(EXPIRES_ON);
        if (expiresOn == null || expiresOn.length() == 0) {
            return true;
        }
        Date expiry = new Date(Long.parseLong(expiresOn) * 1000L);
        return expiry.compareTo(new Date()) <= 0;
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config2) {
        String cloud = "https://login.microsoftonline.com";
        String tenantId = (String)config2.get(TENANT_ID);
        String authority = cloud + "/" + tenantId;
        String clientId = (String)config2.get(CLIENT_ID);
        String refreshToken = (String)config2.get(REFRESH_TOKEN);
        try {
            AuthenticationContext context = new AuthenticationContext(authority, true, Executors.newSingleThreadExecutor());
            Future resultFuture = context.acquireTokenByRefreshToken(refreshToken, clientId, null);
            AuthenticationResult result2 = (AuthenticationResult)resultFuture.get();
            config2.put(ACCESS_TOKEN, result2.getAccessToken());
            config2.put(REFRESH_TOKEN, result2.getRefreshToken());
            return config2;
        }
        catch (InterruptedException | MalformedURLException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        KubeConfig.registerAuthenticator(new AzureActiveDirectoryAuthenticator());
    }
}

