/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class SSLUtils {
    public static boolean isNotNullOrEmpty(String val) {
        return val != null && val.length() > 0;
    }

    public static KeyManager[] keyManagers(byte[] certData, byte[] keyData, String algo, String passphrase, String keyStoreFile, String keyStorePassphrase) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        KeyManager[] keyManagers = null;
        if (certData != null && keyData != null) {
            KeyStore keyStore = SSLUtils.createKeyStore(certData, keyData, algo, passphrase, keyStoreFile, keyStorePassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, passphrase.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    public static KeyStore createKeyStore(byte[] clientCertData, byte[] clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String keyStoreFile, String keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        try (ByteArrayInputStream certInputStream = new ByteArrayInputStream(clientCertData);){
            KeyStore keyStore;
            try (ByteArrayInputStream keyInputStream = new ByteArrayInputStream(clientKeyData);){
                keyStore = SSLUtils.createKeyStore(certInputStream, keyInputStream, clientKeyAlgo, clientKeyPassphrase != null ? clientKeyPassphrase.toCharArray() : null, keyStoreFile, SSLUtils.getKeyStorePassphrase(keyStorePassphrase));
            }
            return keyStore;
        }
    }

    public static byte[] dumpKey(PrivateKey privateKey) throws IOException {
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)privateKey));
        pemWriter.flush();
        return writer.toString().getBytes();
    }

    public static String recognizePrivateKeyAlgo(byte[] privateKeyBytes) {
        String dataString = new String(privateKeyBytes);
        String algo = "";
        if (dataString.contains("BEGIN EC PRIVATE KEY")) {
            algo = "EC";
        }
        if (dataString.contains("BEGIN RSA PRIVATE KEY")) {
            algo = "RSA";
        }
        return algo;
    }

    public static PrivateKey loadKey(byte[] privateKeyBytes) throws IOException, InvalidKeySpecException {
        return SSLUtils.loadKey(new ByteArrayInputStream(privateKeyBytes), SSLUtils.recognizePrivateKeyAlgo(privateKeyBytes));
    }

    public static PrivateKey loadKey(byte[] pemPrivateKeyBytes, String algo) throws IOException, InvalidKeySpecException {
        return SSLUtils.loadKey(new ByteArrayInputStream(pemPrivateKeyBytes), algo);
    }

    public static PrivateKey loadKey(InputStream keyInputStream, String clientKeyAlgo) throws IOException, InvalidKeySpecException {
        PrivateKey privateKey;
        block8: {
            try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(keyInputStream));){
                Object pemObject = pemParser.readObject();
                if (pemObject == null) {
                    String message2 = String.format("PEM Private Key Algorithm [%s] not parsed", clientKeyAlgo);
                    throw new InvalidKeySpecException(message2);
                }
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                if (pemObject instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)pemObject;
                    KeyPair keyPair = converter.getKeyPair(pemKeyPair);
                    privateKey = keyPair.getPrivate();
                    break block8;
                }
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemObject;
                    privateKey = converter.getPrivateKey(privateKeyInfo);
                    break block8;
                }
                String pemObjectType = pemObject.getClass().getSimpleName();
                String message3 = String.format("PEM Private Key Algorithm [%s] Type [%s] not supported", clientKeyAlgo, pemObjectType);
                throw new InvalidKeySpecException(message3);
            }
        }
        return privateKey;
    }

    public static KeyStore createKeyStore(InputStream certInputStream, InputStream keyInputStream, String clientKeyAlgo, char[] clientKeyPassphrase, String keyStoreFile, char[] keyStorePassphrase) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        KeyStore keyStore;
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        Collection<? extends Certificate> certs = certFactory.generateCertificates(certInputStream);
        PrivateKey privateKey = SSLUtils.loadKey(keyInputStream, clientKeyAlgo);
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            keyStore = KeyStore.getInstance("BKS");
        }
        if (keyStoreFile != null && keyStoreFile.length() > 0) {
            keyStore.load(new FileInputStream(keyStoreFile), keyStorePassphrase);
        } else {
            SSLUtils.loadDefaultKeyStoreFile(keyStore, keyStorePassphrase);
        }
        String alias = ((X509Certificate)certs.stream().findFirst().get()).getSubjectX500Principal().getName();
        keyStore.setKeyEntry(alias, privateKey, clientKeyPassphrase, certs.toArray(new X509Certificate[certs.size()]));
        return keyStore;
    }

    private static void loadDefaultKeyStoreFile(KeyStore keyStore, char[] keyStorePassphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        File keyStoreFile;
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (keyStorePath != null && keyStorePath.length() > 0 && SSLUtils.loadDefaultStoreFile(keyStore, keyStoreFile = new File(keyStorePath), keyStorePassphrase)) {
            return;
        }
        keyStore.load(null);
    }

    private static boolean loadDefaultStoreFile(KeyStore keyStore, File fileToLoad, char[] passphrase) throws CertificateException, NoSuchAlgorithmException, IOException {
        if (fileToLoad.exists() && fileToLoad.isFile() && fileToLoad.length() > 0L) {
            try (FileInputStream inputStream2 = new FileInputStream(fileToLoad);){
                keyStore.load(inputStream2, passphrase);
            }
            return true;
        }
        return false;
    }

    private static char[] getKeyStorePassphrase(String keyStorePassphrase) {
        if (keyStorePassphrase == null || keyStorePassphrase.length() == 0) {
            return System.getProperty("javax.net.ssl.keyStorePassword", "changeit").toCharArray();
        }
        return keyStorePassphrase.toCharArray();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

