/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.util.Strings;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProxyContentTypeRequestBody
extends RequestBody {
    private String overridePatchFormat;
    private RequestBody delegateRequestBody;

    public ProxyContentTypeRequestBody(RequestBody delegateRequestBody) {
        this.delegateRequestBody = delegateRequestBody;
    }

    public ProxyContentTypeRequestBody(RequestBody delegateRequestBody, String patchFormat) {
        this(delegateRequestBody);
        this.overridePatchFormat = patchFormat;
    }

    @Override
    public MediaType contentType() {
        if (!Strings.isNullOrEmpty(this.overridePatchFormat)) {
            return MediaType.parse(this.overridePatchFormat);
        }
        return this.delegateRequestBody.contentType();
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.delegateRequestBody.writeTo(bufferedSink);
    }
}

