/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.kubernetes.client.util.ConfigPersister;
import io.kubernetes.client.util.authenticators.Authenticator;
import io.kubernetes.client.util.authenticators.AzureActiveDirectoryAuthenticator;
import io.kubernetes.client.util.authenticators.GCPAuthenticator;
import io.kubernetes.client.util.authenticators.OpenIDConnectAuthenticator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class KubeConfig {
    private static final Logger log = LoggerFactory.getLogger(KubeConfig.class);
    public static final String ENV_HOME = "HOME";
    public static final String KUBEDIR = ".kube";
    public static final String KUBECONFIG = "config";
    public static final String CRED_TOKEN_KEY = "token";
    public static final String CRED_CLIENT_CERTIFICATE_DATA_KEY = "clientCertificateData";
    public static final String CRED_CLIENT_KEY_DATA_KEY = "clientKeyData";
    private static Map<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
    private ArrayList<Object> clusters;
    private ArrayList<Object> contexts;
    private ArrayList<Object> users;
    String currentContextName;
    Map<String, Object> currentContext;
    Map<String, Object> currentCluster;
    Map<String, Object> currentUser;
    String currentNamespace;
    Object preferences;
    ConfigPersister persister;
    private File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthenticator(Authenticator auth) {
        Map<String, Authenticator> map2 = authenticators;
        synchronized (map2) {
            authenticators.put(auth.getName(), auth);
        }
    }

    public static KubeConfig loadKubeConfig(Reader input) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Object config2 = yaml.load(input);
        Map configMap = (Map)config2;
        String currentContext = (String)configMap.get("current-context");
        ArrayList contexts2 = (ArrayList)configMap.get("contexts");
        ArrayList clusters = (ArrayList)configMap.get("clusters");
        ArrayList users = (ArrayList)configMap.get("users");
        Object preferences = configMap.get("preferences");
        KubeConfig kubeConfig = new KubeConfig(contexts2, clusters, users);
        kubeConfig.setContext(currentContext);
        kubeConfig.setPreferences(preferences);
        return kubeConfig;
    }

    public KubeConfig(ArrayList<Object> contexts2, ArrayList<Object> clusters, ArrayList<Object> users) {
        this.contexts = contexts2;
        this.clusters = clusters;
        this.users = users;
    }

    public String getCurrentContext() {
        return this.currentContextName;
    }

    public boolean setContext(String context) {
        Map<String, Object> obj;
        if (context == null) {
            return false;
        }
        this.currentContextName = context;
        this.currentCluster = null;
        this.currentUser = null;
        Map<String, Object> ctx = KubeConfig.findObject(this.contexts, context);
        if (ctx == null) {
            return false;
        }
        this.currentContext = (Map)ctx.get("context");
        if (this.currentContext == null) {
            return false;
        }
        String cluster = (String)this.currentContext.get("cluster");
        String user = (String)this.currentContext.get("user");
        this.currentNamespace = (String)this.currentContext.get("namespace");
        if (cluster != null && (obj = KubeConfig.findObject(this.clusters, cluster)) != null) {
            this.currentCluster = (Map)obj.get("cluster");
        }
        if (user != null && (obj = KubeConfig.findObject(this.users, user)) != null) {
            this.currentUser = (Map)obj.get("user");
        }
        return true;
    }

    public ArrayList<Object> getContexts() {
        return this.contexts;
    }

    public ArrayList<Object> getClusters() {
        return this.clusters;
    }

    public ArrayList<Object> getUsers() {
        return this.users;
    }

    public String getNamespace() {
        return this.currentNamespace;
    }

    public Object getPreferences() {
        return this.preferences;
    }

    public String getServer() {
        return KubeConfig.getData(this.currentCluster, "server");
    }

    public String getCertificateAuthorityData() {
        return KubeConfig.getData(this.currentCluster, "certificate-authority-data");
    }

    public String getCertificateAuthorityFile() {
        return KubeConfig.getData(this.currentCluster, "certificate-authority");
    }

    public String getClientCertificateFile() {
        return KubeConfig.getData(this.currentUser, "client-certificate");
    }

    public String getClientCertificateData() {
        return KubeConfig.getData(this.currentUser, "client-certificate-data");
    }

    public String getClientKeyFile() {
        return KubeConfig.getData(this.currentUser, "client-key");
    }

    public String getClientKeyData() {
        return KubeConfig.getData(this.currentUser, "client-key-data");
    }

    public String getUsername() {
        return KubeConfig.getData(this.currentUser, "username");
    }

    public String getPassword() {
        return KubeConfig.getData(this.currentUser, "password");
    }

    public Map<String, String> getCredentials() {
        Map<String, String> credentialsViaExecCredential;
        Map authProviderMap;
        Map<String, Object> authConfig;
        if (this.currentUser == null) {
            return null;
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        Object authProvider = this.currentUser.get("auth-provider");
        if (authProvider != null && (authConfig = (Map<String, Object>)(authProviderMap = (Map)authProvider).get(KUBECONFIG)) != null) {
            String name2 = (String)authProviderMap.get("name");
            Authenticator auth = authenticators.get(name2);
            if (auth != null) {
                if (auth.isExpired(authConfig)) {
                    authConfig = auth.refresh(authConfig);
                    if (this.persister != null) {
                        try {
                            this.persister.save(this.contexts, this.clusters, this.users, this.preferences, this.currentContextName);
                        }
                        catch (IOException ex) {
                            log.error("Failed to persist new token", (Throwable)ex);
                        }
                    }
                }
                credentials.put(CRED_TOKEN_KEY, auth.getToken(authConfig));
                return credentials;
            }
            log.error("Unknown auth provider: " + name2);
        }
        if ((credentialsViaExecCredential = this.credentialsViaExecCredential((Map)this.currentUser.get("exec"))) != null) {
            return credentialsViaExecCredential;
        }
        if (this.currentUser.containsKey(CRED_TOKEN_KEY)) {
            credentials.put(CRED_TOKEN_KEY, (String)this.currentUser.get(CRED_TOKEN_KEY));
            return credentials;
        }
        if (this.currentUser.containsKey("tokenFile")) {
            String tokenFile = (String)this.currentUser.get("tokenFile");
            try {
                byte[] data = Files.readAllBytes(FileSystems.getDefault().getPath(tokenFile, new String[0]));
                credentials.put(CRED_TOKEN_KEY, new String(data, StandardCharsets.UTF_8));
                return credentials;
            }
            catch (IOException ex) {
                log.error("Failed to read token file", (Throwable)ex);
            }
        }
        return null;
    }

    private Map<String, String> credentialsViaExecCredential(Map<String, Object> execMap) {
        if (execMap == null) {
            return null;
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        String apiVersion = (String)execMap.get("apiVersion");
        if (!("client.authentication.k8s.io/v1".equals(apiVersion) || "client.authentication.k8s.io/v1beta1".equals(apiVersion) || "client.authentication.k8s.io/v1alpha1".equals(apiVersion))) {
            log.error("Unrecognized user.exec.apiVersion: {}", (Object)apiVersion);
            return null;
        }
        String command = (String)execMap.get("command");
        JsonElement root = this.runExec(command, (List)execMap.get("args"), (List)execMap.get("env"));
        if (root == null) {
            return null;
        }
        if (!"ExecCredential".equals(root.getAsJsonObject().get("kind").getAsString())) {
            log.error("Unrecognized kind in response");
            return null;
        }
        if (!apiVersion.equals(root.getAsJsonObject().get("apiVersion").getAsString())) {
            log.error("Mismatched apiVersion in response");
            return null;
        }
        JsonObject status = root.getAsJsonObject().get("status").getAsJsonObject();
        JsonElement token = status.get(CRED_TOKEN_KEY);
        if (token == null) {
            if (status.get(CRED_CLIENT_CERTIFICATE_DATA_KEY) != null && status.get(CRED_CLIENT_KEY_DATA_KEY) != null) {
                log.debug("Obtained a client certificate from {}", (Object)command);
                credentials.put(CRED_CLIENT_CERTIFICATE_DATA_KEY, status.get(CRED_CLIENT_CERTIFICATE_DATA_KEY).getAsString());
                credentials.put(CRED_CLIENT_KEY_DATA_KEY, status.get(CRED_CLIENT_KEY_DATA_KEY).getAsString());
                return credentials;
            }
            log.warn("No token or certificates produced by {}", (Object)command);
            return null;
        }
        log.debug("Obtained a token from {}", (Object)command);
        credentials.put(CRED_TOKEN_KEY, token.getAsString());
        return credentials;
    }

    private JsonElement runExec(String command, List<String> args, List<Map<String, String>> env) {
        ArrayList<String> argv = new ArrayList<String>();
        if (command.contains("/") || command.contains("\\")) {
            Path resolvedCommand = this.file.toPath().getParent().resolve(command).normalize();
            if (!Files.exists(resolvedCommand, new LinkOption[0])) {
                log.error("No such file: {}", (Object)resolvedCommand);
                return null;
            }
            log.debug("Resolved {} to {}", (Object)command, (Object)resolvedCommand);
            argv.add(resolvedCommand.toString());
        } else {
            argv.add(command);
        }
        if (args != null) {
            argv.addAll(args);
        }
        ProcessBuilder pb = new ProcessBuilder(argv);
        if (env != null) {
            for (Map<String, String> entry : env) {
                pb.environment().put(entry.get("name"), entry.get("value"));
            }
        }
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            JsonElement root;
            Process proc = pb.start();
            try (InputStream is = proc.getInputStream();
                 InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                root = JsonParser.parseReader((Reader)r);
            }
            catch (JsonParseException x) {
                log.error("Failed to parse output of " + command, (Throwable)x);
                return null;
            }
            int r = proc.waitFor();
            if (r != 0) {
                log.error("{} failed with exit code {}", (Object)command, (Object)r);
                return null;
            }
            return root;
        }
        catch (IOException | InterruptedException x) {
            log.error("Failed to run " + command, (Throwable)x);
            return null;
        }
    }

    public boolean verifySSL() {
        if (this.currentCluster == null) {
            return false;
        }
        if (this.currentCluster.containsKey("insecure-skip-tls-verify")) {
            return (Boolean)this.currentCluster.get("insecure-skip-tls-verify") == false;
        }
        return true;
    }

    public void setPersistConfig(ConfigPersister persister) {
        this.persister = persister;
    }

    public void setFile(File file2) {
        this.file = file2;
    }

    public void setPreferences(Object preferences) {
        this.preferences = preferences;
    }

    private static String getData(Map<String, Object> obj, String key2) {
        if (obj == null) {
            return null;
        }
        return (String)obj.get(key2);
    }

    private static Map<String, Object> findObject(ArrayList<Object> list2, String name2) {
        if (list2 == null) {
            return null;
        }
        for (Object obj : list2) {
            Map map2 = (Map)obj;
            if (!name2.equals(map2.get("name"))) continue;
            return map2;
        }
        return null;
    }

    public byte[] getDataOrFileRelative(String data, String path) throws IOException {
        String resolvedPath = path;
        if (resolvedPath != null && this.file != null) {
            resolvedPath = this.file.toPath().getParent().resolve(path).normalize().toString();
        }
        return KubeConfig.getDataOrFile(data, resolvedPath);
    }

    private static byte[] getDataOrFile(String data, String file2) throws IOException {
        if (data != null) {
            return Base64.decodeBase64((String)data);
        }
        if (file2 != null) {
            return Files.readAllBytes(Paths.get(file2, new String[0]));
        }
        return null;
    }

    static {
        KubeConfig.registerAuthenticator(new GCPAuthenticator());
        KubeConfig.registerAuthenticator(new AzureActiveDirectoryAuthenticator());
        KubeConfig.registerAuthenticator(new OpenIDConnectAuthenticator());
    }
}

