/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CrossVersionObjectReference contains enough information to let you identify the referred resource.")
public class V2CrossVersionObjectReference {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V2CrossVersionObjectReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="apiVersion is the API version of the referent")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V2CrossVersionObjectReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V2CrossVersionObjectReference name(String name2) {
        this.name = name2;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2CrossVersionObjectReference v2CrossVersionObjectReference = (V2CrossVersionObjectReference)o;
        return Objects.equals(this.apiVersion, v2CrossVersionObjectReference.apiVersion) && Objects.equals(this.kind, v2CrossVersionObjectReference.kind) && Objects.equals(this.name, v2CrossVersionObjectReference.name);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2CrossVersionObjectReference {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

