/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1AWSElasticBlockStoreVolumeSource;
import io.kubernetes.client.openapi.models.V1AzureDiskVolumeSource;
import io.kubernetes.client.openapi.models.V1AzureFilePersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1CSIPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1CephFSPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1CinderPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1FCVolumeSource;
import io.kubernetes.client.openapi.models.V1FlexPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1FlockerVolumeSource;
import io.kubernetes.client.openapi.models.V1GCEPersistentDiskVolumeSource;
import io.kubernetes.client.openapi.models.V1GlusterfsPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1HostPathVolumeSource;
import io.kubernetes.client.openapi.models.V1ISCSIPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1LocalVolumeSource;
import io.kubernetes.client.openapi.models.V1NFSVolumeSource;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1PhotonPersistentDiskVolumeSource;
import io.kubernetes.client.openapi.models.V1PortworxVolumeSource;
import io.kubernetes.client.openapi.models.V1QuobyteVolumeSource;
import io.kubernetes.client.openapi.models.V1RBDPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1ScaleIOPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1StorageOSPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1VolumeNodeAffinity;
import io.kubernetes.client.openapi.models.V1VsphereVirtualDiskVolumeSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PersistentVolumeSpec is the specification of a persistent volume.")
public class V1PersistentVolumeSpec {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    public static final String SERIALIZED_NAME_AWS_ELASTIC_BLOCK_STORE = "awsElasticBlockStore";
    @SerializedName(value="awsElasticBlockStore")
    private V1AWSElasticBlockStoreVolumeSource awsElasticBlockStore;
    public static final String SERIALIZED_NAME_AZURE_DISK = "azureDisk";
    @SerializedName(value="azureDisk")
    private V1AzureDiskVolumeSource azureDisk;
    public static final String SERIALIZED_NAME_AZURE_FILE = "azureFile";
    @SerializedName(value="azureFile")
    private V1AzureFilePersistentVolumeSource azureFile;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, Quantity> capacity = null;
    public static final String SERIALIZED_NAME_CEPHFS = "cephfs";
    @SerializedName(value="cephfs")
    private V1CephFSPersistentVolumeSource cephfs;
    public static final String SERIALIZED_NAME_CINDER = "cinder";
    @SerializedName(value="cinder")
    private V1CinderPersistentVolumeSource cinder;
    public static final String SERIALIZED_NAME_CLAIM_REF = "claimRef";
    @SerializedName(value="claimRef")
    private V1ObjectReference claimRef;
    public static final String SERIALIZED_NAME_CSI = "csi";
    @SerializedName(value="csi")
    private V1CSIPersistentVolumeSource csi;
    public static final String SERIALIZED_NAME_FC = "fc";
    @SerializedName(value="fc")
    private V1FCVolumeSource fc;
    public static final String SERIALIZED_NAME_FLEX_VOLUME = "flexVolume";
    @SerializedName(value="flexVolume")
    private V1FlexPersistentVolumeSource flexVolume;
    public static final String SERIALIZED_NAME_FLOCKER = "flocker";
    @SerializedName(value="flocker")
    private V1FlockerVolumeSource flocker;
    public static final String SERIALIZED_NAME_GCE_PERSISTENT_DISK = "gcePersistentDisk";
    @SerializedName(value="gcePersistentDisk")
    private V1GCEPersistentDiskVolumeSource gcePersistentDisk;
    public static final String SERIALIZED_NAME_GLUSTERFS = "glusterfs";
    @SerializedName(value="glusterfs")
    private V1GlusterfsPersistentVolumeSource glusterfs;
    public static final String SERIALIZED_NAME_HOST_PATH = "hostPath";
    @SerializedName(value="hostPath")
    private V1HostPathVolumeSource hostPath;
    public static final String SERIALIZED_NAME_ISCSI = "iscsi";
    @SerializedName(value="iscsi")
    private V1ISCSIPersistentVolumeSource iscsi;
    public static final String SERIALIZED_NAME_LOCAL = "local";
    @SerializedName(value="local")
    private V1LocalVolumeSource local;
    public static final String SERIALIZED_NAME_MOUNT_OPTIONS = "mountOptions";
    @SerializedName(value="mountOptions")
    private List<String> mountOptions = null;
    public static final String SERIALIZED_NAME_NFS = "nfs";
    @SerializedName(value="nfs")
    private V1NFSVolumeSource nfs;
    public static final String SERIALIZED_NAME_NODE_AFFINITY = "nodeAffinity";
    @SerializedName(value="nodeAffinity")
    private V1VolumeNodeAffinity nodeAffinity;
    public static final String SERIALIZED_NAME_PERSISTENT_VOLUME_RECLAIM_POLICY = "persistentVolumeReclaimPolicy";
    @SerializedName(value="persistentVolumeReclaimPolicy")
    private String persistentVolumeReclaimPolicy;
    public static final String SERIALIZED_NAME_PHOTON_PERSISTENT_DISK = "photonPersistentDisk";
    @SerializedName(value="photonPersistentDisk")
    private V1PhotonPersistentDiskVolumeSource photonPersistentDisk;
    public static final String SERIALIZED_NAME_PORTWORX_VOLUME = "portworxVolume";
    @SerializedName(value="portworxVolume")
    private V1PortworxVolumeSource portworxVolume;
    public static final String SERIALIZED_NAME_QUOBYTE = "quobyte";
    @SerializedName(value="quobyte")
    private V1QuobyteVolumeSource quobyte;
    public static final String SERIALIZED_NAME_RBD = "rbd";
    @SerializedName(value="rbd")
    private V1RBDPersistentVolumeSource rbd;
    public static final String SERIALIZED_NAME_SCALE_I_O = "scaleIO";
    @SerializedName(value="scaleIO")
    private V1ScaleIOPersistentVolumeSource scaleIO;
    public static final String SERIALIZED_NAME_STORAGE_CLASS_NAME = "storageClassName";
    @SerializedName(value="storageClassName")
    private String storageClassName;
    public static final String SERIALIZED_NAME_STORAGEOS = "storageos";
    @SerializedName(value="storageos")
    private V1StorageOSPersistentVolumeSource storageos;
    public static final String SERIALIZED_NAME_VOLUME_MODE = "volumeMode";
    @SerializedName(value="volumeMode")
    private String volumeMode;
    public static final String SERIALIZED_NAME_VSPHERE_VOLUME = "vsphereVolume";
    @SerializedName(value="vsphereVolume")
    private V1VsphereVirtualDiskVolumeSource vsphereVolume;

    public V1PersistentVolumeSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeSpec awsElasticBlockStore(V1AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this.awsElasticBlockStore = awsElasticBlockStore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore;
    }

    public void setAwsElasticBlockStore(V1AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this.awsElasticBlockStore = awsElasticBlockStore;
    }

    public V1PersistentVolumeSpec azureDisk(V1AzureDiskVolumeSource azureDisk) {
        this.azureDisk = azureDisk;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AzureDiskVolumeSource getAzureDisk() {
        return this.azureDisk;
    }

    public void setAzureDisk(V1AzureDiskVolumeSource azureDisk) {
        this.azureDisk = azureDisk;
    }

    public V1PersistentVolumeSpec azureFile(V1AzureFilePersistentVolumeSource azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1AzureFilePersistentVolumeSource getAzureFile() {
        return this.azureFile;
    }

    public void setAzureFile(V1AzureFilePersistentVolumeSource azureFile) {
        this.azureFile = azureFile;
    }

    public V1PersistentVolumeSpec capacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1PersistentVolumeSpec putCapacityItem(String key2, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key2, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity")
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public V1PersistentVolumeSpec cephfs(V1CephFSPersistentVolumeSource cephfs) {
        this.cephfs = cephfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CephFSPersistentVolumeSource getCephfs() {
        return this.cephfs;
    }

    public void setCephfs(V1CephFSPersistentVolumeSource cephfs) {
        this.cephfs = cephfs;
    }

    public V1PersistentVolumeSpec cinder(V1CinderPersistentVolumeSource cinder) {
        this.cinder = cinder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CinderPersistentVolumeSource getCinder() {
        return this.cinder;
    }

    public void setCinder(V1CinderPersistentVolumeSource cinder) {
        this.cinder = cinder;
    }

    public V1PersistentVolumeSpec claimRef(V1ObjectReference claimRef) {
        this.claimRef = claimRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getClaimRef() {
        return this.claimRef;
    }

    public void setClaimRef(V1ObjectReference claimRef) {
        this.claimRef = claimRef;
    }

    public V1PersistentVolumeSpec csi(V1CSIPersistentVolumeSource csi) {
        this.csi = csi;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CSIPersistentVolumeSource getCsi() {
        return this.csi;
    }

    public void setCsi(V1CSIPersistentVolumeSource csi) {
        this.csi = csi;
    }

    public V1PersistentVolumeSpec fc(V1FCVolumeSource fc) {
        this.fc = fc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1FCVolumeSource getFc() {
        return this.fc;
    }

    public void setFc(V1FCVolumeSource fc) {
        this.fc = fc;
    }

    public V1PersistentVolumeSpec flexVolume(V1FlexPersistentVolumeSource flexVolume) {
        this.flexVolume = flexVolume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1FlexPersistentVolumeSource getFlexVolume() {
        return this.flexVolume;
    }

    public void setFlexVolume(V1FlexPersistentVolumeSource flexVolume) {
        this.flexVolume = flexVolume;
    }

    public V1PersistentVolumeSpec flocker(V1FlockerVolumeSource flocker) {
        this.flocker = flocker;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1FlockerVolumeSource getFlocker() {
        return this.flocker;
    }

    public void setFlocker(V1FlockerVolumeSource flocker) {
        this.flocker = flocker;
    }

    public V1PersistentVolumeSpec gcePersistentDisk(V1GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk;
    }

    public void setGcePersistentDisk(V1GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
    }

    public V1PersistentVolumeSpec glusterfs(V1GlusterfsPersistentVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1GlusterfsPersistentVolumeSource getGlusterfs() {
        return this.glusterfs;
    }

    public void setGlusterfs(V1GlusterfsPersistentVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
    }

    public V1PersistentVolumeSpec hostPath(V1HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1HostPathVolumeSource getHostPath() {
        return this.hostPath;
    }

    public void setHostPath(V1HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
    }

    public V1PersistentVolumeSpec iscsi(V1ISCSIPersistentVolumeSource iscsi) {
        this.iscsi = iscsi;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ISCSIPersistentVolumeSource getIscsi() {
        return this.iscsi;
    }

    public void setIscsi(V1ISCSIPersistentVolumeSource iscsi) {
        this.iscsi = iscsi;
    }

    public V1PersistentVolumeSpec local(V1LocalVolumeSource local) {
        this.local = local;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LocalVolumeSource getLocal() {
        return this.local;
    }

    public void setLocal(V1LocalVolumeSource local) {
        this.local = local;
    }

    public V1PersistentVolumeSpec mountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public V1PersistentVolumeSpec addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mountOptions is the list of mount options, e.g. [\"ro\", \"soft\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options")
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public V1PersistentVolumeSpec nfs(V1NFSVolumeSource nfs) {
        this.nfs = nfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NFSVolumeSource getNfs() {
        return this.nfs;
    }

    public void setNfs(V1NFSVolumeSource nfs) {
        this.nfs = nfs;
    }

    public V1PersistentVolumeSpec nodeAffinity(V1VolumeNodeAffinity nodeAffinity) {
        this.nodeAffinity = nodeAffinity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VolumeNodeAffinity getNodeAffinity() {
        return this.nodeAffinity;
    }

    public void setNodeAffinity(V1VolumeNodeAffinity nodeAffinity) {
        this.nodeAffinity = nodeAffinity;
    }

    public V1PersistentVolumeSpec persistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming")
    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    public void setPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
    }

    public V1PersistentVolumeSpec photonPersistentDisk(V1PhotonPersistentDiskVolumeSource photonPersistentDisk) {
        this.photonPersistentDisk = photonPersistentDisk;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PhotonPersistentDiskVolumeSource getPhotonPersistentDisk() {
        return this.photonPersistentDisk;
    }

    public void setPhotonPersistentDisk(V1PhotonPersistentDiskVolumeSource photonPersistentDisk) {
        this.photonPersistentDisk = photonPersistentDisk;
    }

    public V1PersistentVolumeSpec portworxVolume(V1PortworxVolumeSource portworxVolume) {
        this.portworxVolume = portworxVolume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PortworxVolumeSource getPortworxVolume() {
        return this.portworxVolume;
    }

    public void setPortworxVolume(V1PortworxVolumeSource portworxVolume) {
        this.portworxVolume = portworxVolume;
    }

    public V1PersistentVolumeSpec quobyte(V1QuobyteVolumeSource quobyte) {
        this.quobyte = quobyte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1QuobyteVolumeSource getQuobyte() {
        return this.quobyte;
    }

    public void setQuobyte(V1QuobyteVolumeSource quobyte) {
        this.quobyte = quobyte;
    }

    public V1PersistentVolumeSpec rbd(V1RBDPersistentVolumeSource rbd) {
        this.rbd = rbd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1RBDPersistentVolumeSource getRbd() {
        return this.rbd;
    }

    public void setRbd(V1RBDPersistentVolumeSource rbd) {
        this.rbd = rbd;
    }

    public V1PersistentVolumeSpec scaleIO(V1ScaleIOPersistentVolumeSource scaleIO) {
        this.scaleIO = scaleIO;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ScaleIOPersistentVolumeSource getScaleIO() {
        return this.scaleIO;
    }

    public void setScaleIO(V1ScaleIOPersistentVolumeSource scaleIO) {
        this.scaleIO = scaleIO;
    }

    public V1PersistentVolumeSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1PersistentVolumeSpec storageos(V1StorageOSPersistentVolumeSource storageos) {
        this.storageos = storageos;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1StorageOSPersistentVolumeSource getStorageos() {
        return this.storageos;
    }

    public void setStorageos(V1StorageOSPersistentVolumeSource storageos) {
        this.storageos = storageos;
    }

    public V1PersistentVolumeSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.")
    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public V1PersistentVolumeSpec vsphereVolume(V1VsphereVirtualDiskVolumeSource vsphereVolume) {
        this.vsphereVolume = vsphereVolume;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VsphereVirtualDiskVolumeSource getVsphereVolume() {
        return this.vsphereVolume;
    }

    public void setVsphereVolume(V1VsphereVirtualDiskVolumeSource vsphereVolume) {
        this.vsphereVolume = vsphereVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeSpec v1PersistentVolumeSpec = (V1PersistentVolumeSpec)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeSpec.accessModes) && Objects.equals(this.awsElasticBlockStore, v1PersistentVolumeSpec.awsElasticBlockStore) && Objects.equals(this.azureDisk, v1PersistentVolumeSpec.azureDisk) && Objects.equals(this.azureFile, v1PersistentVolumeSpec.azureFile) && Objects.equals(this.capacity, v1PersistentVolumeSpec.capacity) && Objects.equals(this.cephfs, v1PersistentVolumeSpec.cephfs) && Objects.equals(this.cinder, v1PersistentVolumeSpec.cinder) && Objects.equals(this.claimRef, v1PersistentVolumeSpec.claimRef) && Objects.equals(this.csi, v1PersistentVolumeSpec.csi) && Objects.equals(this.fc, v1PersistentVolumeSpec.fc) && Objects.equals(this.flexVolume, v1PersistentVolumeSpec.flexVolume) && Objects.equals(this.flocker, v1PersistentVolumeSpec.flocker) && Objects.equals(this.gcePersistentDisk, v1PersistentVolumeSpec.gcePersistentDisk) && Objects.equals(this.glusterfs, v1PersistentVolumeSpec.glusterfs) && Objects.equals(this.hostPath, v1PersistentVolumeSpec.hostPath) && Objects.equals(this.iscsi, v1PersistentVolumeSpec.iscsi) && Objects.equals(this.local, v1PersistentVolumeSpec.local) && Objects.equals(this.mountOptions, v1PersistentVolumeSpec.mountOptions) && Objects.equals(this.nfs, v1PersistentVolumeSpec.nfs) && Objects.equals(this.nodeAffinity, v1PersistentVolumeSpec.nodeAffinity) && Objects.equals(this.persistentVolumeReclaimPolicy, v1PersistentVolumeSpec.persistentVolumeReclaimPolicy) && Objects.equals(this.photonPersistentDisk, v1PersistentVolumeSpec.photonPersistentDisk) && Objects.equals(this.portworxVolume, v1PersistentVolumeSpec.portworxVolume) && Objects.equals(this.quobyte, v1PersistentVolumeSpec.quobyte) && Objects.equals(this.rbd, v1PersistentVolumeSpec.rbd) && Objects.equals(this.scaleIO, v1PersistentVolumeSpec.scaleIO) && Objects.equals(this.storageClassName, v1PersistentVolumeSpec.storageClassName) && Objects.equals(this.storageos, v1PersistentVolumeSpec.storageos) && Objects.equals(this.volumeMode, v1PersistentVolumeSpec.volumeMode) && Objects.equals(this.vsphereVolume, v1PersistentVolumeSpec.vsphereVolume);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.awsElasticBlockStore, this.azureDisk, this.azureFile, this.capacity, this.cephfs, this.cinder, this.claimRef, this.csi, this.fc, this.flexVolume, this.flocker, this.gcePersistentDisk, this.glusterfs, this.hostPath, this.iscsi, this.local, this.mountOptions, this.nfs, this.nodeAffinity, this.persistentVolumeReclaimPolicy, this.photonPersistentDisk, this.portworxVolume, this.quobyte, this.rbd, this.scaleIO, this.storageClassName, this.storageos, this.volumeMode, this.vsphereVolume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    awsElasticBlockStore: ").append(this.toIndentedString(this.awsElasticBlockStore)).append("\n");
        sb.append("    azureDisk: ").append(this.toIndentedString(this.azureDisk)).append("\n");
        sb.append("    azureFile: ").append(this.toIndentedString(this.azureFile)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    cephfs: ").append(this.toIndentedString(this.cephfs)).append("\n");
        sb.append("    cinder: ").append(this.toIndentedString(this.cinder)).append("\n");
        sb.append("    claimRef: ").append(this.toIndentedString(this.claimRef)).append("\n");
        sb.append("    csi: ").append(this.toIndentedString(this.csi)).append("\n");
        sb.append("    fc: ").append(this.toIndentedString(this.fc)).append("\n");
        sb.append("    flexVolume: ").append(this.toIndentedString(this.flexVolume)).append("\n");
        sb.append("    flocker: ").append(this.toIndentedString(this.flocker)).append("\n");
        sb.append("    gcePersistentDisk: ").append(this.toIndentedString(this.gcePersistentDisk)).append("\n");
        sb.append("    glusterfs: ").append(this.toIndentedString(this.glusterfs)).append("\n");
        sb.append("    hostPath: ").append(this.toIndentedString(this.hostPath)).append("\n");
        sb.append("    iscsi: ").append(this.toIndentedString(this.iscsi)).append("\n");
        sb.append("    local: ").append(this.toIndentedString(this.local)).append("\n");
        sb.append("    mountOptions: ").append(this.toIndentedString(this.mountOptions)).append("\n");
        sb.append("    nfs: ").append(this.toIndentedString(this.nfs)).append("\n");
        sb.append("    nodeAffinity: ").append(this.toIndentedString(this.nodeAffinity)).append("\n");
        sb.append("    persistentVolumeReclaimPolicy: ").append(this.toIndentedString(this.persistentVolumeReclaimPolicy)).append("\n");
        sb.append("    photonPersistentDisk: ").append(this.toIndentedString(this.photonPersistentDisk)).append("\n");
        sb.append("    portworxVolume: ").append(this.toIndentedString(this.portworxVolume)).append("\n");
        sb.append("    quobyte: ").append(this.toIndentedString(this.quobyte)).append("\n");
        sb.append("    rbd: ").append(this.toIndentedString(this.rbd)).append("\n");
        sb.append("    scaleIO: ").append(this.toIndentedString(this.scaleIO)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    storageos: ").append(this.toIndentedString(this.storageos)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("    vsphereVolume: ").append(this.toIndentedString(this.vsphereVolume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

