/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1GRPCAction {
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private String service;

    public V1GRPCAction port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="Port number of the gRPC service. Number must be in the range 1 to 65535.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public V1GRPCAction service(String service2) {
        this.service = service2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).  If this is not specified, the default behavior is defined by gRPC.")
    public String getService() {
        return this.service;
    }

    public void setService(String service2) {
        this.service = service2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GRPCAction v1GRPCAction = (V1GRPCAction)o;
        return Objects.equals(this.port, v1GRPCAction.port) && Objects.equals(this.service, v1GRPCAction.service);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GRPCAction {\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

