/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerPort represents a network port in a single container.")
public class V1ContainerPort {
    public static final String SERIALIZED_NAME_CONTAINER_PORT = "containerPort";
    @SerializedName(value="containerPort")
    private Integer containerPort;
    public static final String SERIALIZED_NAME_HOST_I_P = "hostIP";
    @SerializedName(value="hostIP")
    private String hostIP;
    public static final String SERIALIZED_NAME_HOST_PORT = "hostPort";
    @SerializedName(value="hostPort")
    private Integer hostPort;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public V1ContainerPort containerPort(Integer containerPort) {
        this.containerPort = containerPort;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.")
    public Integer getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public V1ContainerPort hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What host IP to bind the external port to.")
    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public V1ContainerPort hostPort(Integer hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.")
    public Integer getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public V1ContainerPort name(String name2) {
        this.name = name2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.")
    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public V1ContainerPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Protocol for port. Must be UDP, TCP, or SCTP. Defaults to \"TCP\".")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerPort v1ContainerPort = (V1ContainerPort)o;
        return Objects.equals(this.containerPort, v1ContainerPort.containerPort) && Objects.equals(this.hostIP, v1ContainerPort.hostIP) && Objects.equals(this.hostPort, v1ContainerPort.hostPort) && Objects.equals(this.name, v1ContainerPort.name) && Objects.equals(this.protocol, v1ContainerPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.containerPort, this.hostIP, this.hostPort, this.name, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerPort {\n");
        sb.append("    containerPort: ").append(this.toIndentedString(this.containerPort)).append("\n");
        sb.append("    hostIP: ").append(this.toIndentedString(this.hostIP)).append("\n");
        sb.append("    hostPort: ").append(this.toIndentedString(this.hostPort)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

