/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1ServiceReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WebhookClientConfig contains the information to make a TLS connection with the webhook")
public class AdmissionregistrationV1WebhookClientConfig {
    public static final String SERIALIZED_NAME_CA_BUNDLE = "caBundle";
    @SerializedName(value="caBundle")
    private byte[] caBundle;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private AdmissionregistrationV1ServiceReference service;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public AdmissionregistrationV1WebhookClientConfig caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public AdmissionregistrationV1WebhookClientConfig service(AdmissionregistrationV1ServiceReference service2) {
        this.service = service2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AdmissionregistrationV1ServiceReference getService() {
        return this.service;
    }

    public void setService(AdmissionregistrationV1ServiceReference service2) {
        this.service = service2;
    }

    public AdmissionregistrationV1WebhookClientConfig url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.  The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.  Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.  The scheme must be \"https\"; the URL must begin with \"https://\".  A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.  Attempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionregistrationV1WebhookClientConfig admissionregistrationV1WebhookClientConfig = (AdmissionregistrationV1WebhookClientConfig)o;
        return Arrays.equals(this.caBundle, admissionregistrationV1WebhookClientConfig.caBundle) && Objects.equals(this.service, admissionregistrationV1WebhookClientConfig.service) && Objects.equals(this.url, admissionregistrationV1WebhookClientConfig.url);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.caBundle), this.service, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdmissionregistrationV1WebhookClientConfig {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

