/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.impl;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.TransformFunc;
import io.kubernetes.client.informer.cache.Cache;
import io.kubernetes.client.informer.cache.Controller;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.cache.Indexer;
import io.kubernetes.client.informer.cache.ProcessorListener;
import io.kubernetes.client.informer.cache.SharedProcessor;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject>
implements SharedIndexInformer<ApiType> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private long defaultEventHandlerResyncPeriod;
    private Indexer<ApiType> indexer;
    private SharedProcessor<ApiType> processor;
    private Controller<ApiType, ApiListType> controller;
    private Thread controllerThread;
    private TransformFunc transform;
    private volatile boolean started = false;
    private volatile boolean stopped = false;

    public DefaultSharedIndexInformer(Class<ApiType> apiTypeClass, ListerWatcher<ApiType, ApiListType> listerWatcher, long resyncPeriod) {
        this(apiTypeClass, listerWatcher, resyncPeriod, new Cache());
    }

    public DefaultSharedIndexInformer(Class<ApiType> apiTypeClass, ListerWatcher<ApiType, ApiListType> listerWatcher, long resyncPeriod, Cache<ApiType> cache) {
        this(apiTypeClass, listerWatcher, resyncPeriod, new DeltaFIFO(cache.getKeyFunc(), cache), cache, null);
    }

    public DefaultSharedIndexInformer(Class<ApiType> apiTypeClass, ListerWatcher<ApiType, ApiListType> listerWatcher, long resyncPeriod, Cache<ApiType> cache, BiConsumer<Class<ApiType>, Throwable> exceptionHandler2) {
        this(apiTypeClass, listerWatcher, resyncPeriod, new DeltaFIFO(cache.getKeyFunc(), cache), cache, exceptionHandler2);
    }

    public DefaultSharedIndexInformer(Class<ApiType> apiTypeClass, ListerWatcher<ApiType, ApiListType> listerWatcher, long resyncPeriod, DeltaFIFO deltaFIFO, Indexer<ApiType> indexer) {
        this(apiTypeClass, listerWatcher, resyncPeriod, deltaFIFO, indexer, null);
    }

    public DefaultSharedIndexInformer(Class<ApiType> apiTypeClass, ListerWatcher<ApiType, ApiListType> listerWatcher, long resyncPeriod, DeltaFIFO deltaFIFO, Indexer<ApiType> indexer, BiConsumer<Class<ApiType>, Throwable> exceptionHandler2) {
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.processor = new SharedProcessor();
        this.indexer = indexer;
        this.controller = new Controller<ApiType, ApiListType>(apiTypeClass, deltaFIFO, listerWatcher, this::handleDeltas, this.processor::shouldResync, this.resyncCheckPeriodMillis, exceptionHandler2);
        this.controllerThread = new Thread(this.controller::run, "informer-controller-" + apiTypeClass.getSimpleName());
    }

    @Override
    public void addEventHandler(ResourceEventHandler<ApiType> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
    }

    @Override
    public void addEventHandlerWithResyncPeriod(ResourceEventHandler<ApiType> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to shared informer because it has stopped already");
            return;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small. Changing it to the minimum allowed rule of {}", (Object)resyncPeriodMillis, (Object)1000L);
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the informer has already started. Changing it to {}", new Object[]{resyncPeriodMillis, this.resyncCheckPeriodMillis, this.resyncCheckPeriodMillis});
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        ProcessorListener listener = new ProcessorListener(handler, this.determineResyncPeriod(this.resyncCheckPeriodMillis, this.resyncCheckPeriodMillis));
        if (!this.started) {
            this.processor.addListener(listener);
            return;
        }
        this.processor.addAndStartListener(listener);
        List objectList = this.indexer.list();
        for (Object item : objectList) {
            listener.add(new ProcessorListener.AddNotification(item));
        }
    }

    @Override
    public String lastSyncResourceVersion() {
        if (!this.started) {
            return "";
        }
        return this.controller.lastSyncResourceVersion();
    }

    @Override
    public void setTransform(TransformFunc transformFunc) {
        if (this.started) {
            throw new IllegalStateException("cannot set transform func to a running informer");
        }
        this.transform = transformFunc;
    }

    @Override
    public void run() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.processor.run();
        this.controllerThread.start();
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.stopped = true;
        this.controller.stop();
        this.controllerThread.interrupt();
        this.processor.stop();
    }

    @Override
    public boolean hasSynced() {
        return this.controller != null && this.controller.hasSynced();
    }

    public void handleDeltas(Deque<MutablePair<DeltaFIFO.DeltaType, KubernetesObject>> deltas) {
        if (CollectionUtils.isEmpty(deltas)) {
            return;
        }
        for (MutablePair<DeltaFIFO.DeltaType, KubernetesObject> delta : deltas) {
            DeltaFIFO.DeltaType deltaType = (DeltaFIFO.DeltaType)((Object)delta.getLeft());
            KubernetesObject obj = (KubernetesObject)delta.getRight();
            if (this.transform != null) {
                obj = this.transform.transform(obj);
            }
            switch (deltaType) {
                case Sync: 
                case Added: 
                case Updated: {
                    boolean isSync = deltaType == DeltaFIFO.DeltaType.Sync;
                    Object oldObj = this.indexer.get(obj);
                    if (oldObj != null) {
                        this.indexer.update(obj);
                        this.processor.distribute(new ProcessorListener.UpdateNotification<KubernetesObject>((KubernetesObject)oldObj, obj), isSync);
                        break;
                    }
                    this.indexer.add(obj);
                    this.processor.distribute(new ProcessorListener.AddNotification<KubernetesObject>(obj), isSync);
                    break;
                }
                case Deleted: {
                    this.indexer.delete(obj);
                    this.processor.distribute(new ProcessorListener.DeleteNotification<KubernetesObject>(obj), false);
                }
            }
        }
    }

    @Override
    public void addIndexers(Map<String, Function<ApiType, List<String>>> indexers) {
        if (this.started) {
            throw new IllegalStateException("cannot add indexers to a running informer");
        }
        this.indexer.addIndexers(indexers);
    }

    @Override
    public Indexer getIndexer() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check2) {
        if (desired == 0L) {
            return desired;
        }
        if (check2 == 0L) {
            return 0L;
        }
        return Math.max(desired, check2);
    }
}

