/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.engine.okhttp.OkHttpCallback;
import io.ktor.client.engine.okhttp.StreamAdapterIOException;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.Headers;
import io.ktor.http.HttpProtocolVersion;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a%\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a\f\u0010\f\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0005H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"mapOkHttpException", "", "requestData", "Lio/ktor/client/request/HttpRequestData;", "origin", "Ljava/io/IOException;", "execute", "Lokhttp3/Response;", "Lokhttp3/OkHttpClient;", "request", "Lokhttp3/Request;", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fromOkHttp", "Lio/ktor/http/Headers;", "Lokhttp3/Headers;", "Lio/ktor/http/HttpProtocolVersion;", "Lokhttp3/Protocol;", "isConnectException", "", "ktor-client-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,87:1\n314#2,11:88\n*S KotlinDebug\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n*L\n20#1:88,11\n*E\n"})
public final class OkUtilsKt {
    @Nullable
    public static final Object execute(@NotNull OkHttpClient $this$execute, @NotNull Request request, @NotNull HttpRequestData requestData, @NotNull Continuation<? super Response> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Response> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Call call = $this$execute.newCall(request);
        call.enqueue(new OkHttpCallback(requestData, (CancellableContinuation<? super Response>)continuation));
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(call){
            final /* synthetic */ Call $call;
            {
                this.$call = $call;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.$call.cancel();
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @NotNull
    public static final Headers fromOkHttp(@NotNull okhttp3.Headers $this$fromOkHttp) {
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        return new Headers($this$fromOkHttp){
            private final boolean caseInsensitiveName;
            final /* synthetic */ okhttp3.Headers $this_fromOkHttp;
            {
                this.$this_fromOkHttp = $receiver;
                this.caseInsensitiveName = true;
            }

            public boolean getCaseInsensitiveName() {
                return this.caseInsensitiveName;
            }

            @Nullable
            public List<String> getAll(@NotNull String name2) {
                List<String> list2;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                List<String> it = list2 = this.$this_fromOkHttp.values(name2);
                boolean bl = false;
                return !((Collection)it).isEmpty() ? list2 : null;
            }

            @NotNull
            public Set<String> names() {
                return this.$this_fromOkHttp.names();
            }

            @NotNull
            public Set<Map.Entry<String, List<String>>> entries() {
                return this.$this_fromOkHttp.toMultimap().entrySet();
            }

            public boolean isEmpty() {
                return this.$this_fromOkHttp.size() == 0;
            }

            public boolean contains(@NotNull String name2) {
                return Headers.DefaultImpls.contains((Headers)this, (String)name2);
            }

            public boolean contains(@NotNull String name2, @NotNull String value2) {
                return Headers.DefaultImpls.contains((Headers)this, (String)name2, (String)value2);
            }

            public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
                Headers.DefaultImpls.forEach((Headers)this, body);
            }

            @Nullable
            public String get(@NotNull String name2) {
                return Headers.DefaultImpls.get((Headers)this, (String)name2);
            }
        };
    }

    @NotNull
    public static final HttpProtocolVersion fromOkHttp(@NotNull Protocol $this$fromOkHttp) {
        HttpProtocolVersion httpProtocolVersion;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$fromOkHttp), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$fromOkHttp.ordinal()]) {
            case 1: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_0();
                break;
            }
            case 2: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_1_1();
                break;
            }
            case 3: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getSPDY_3();
                break;
            }
            case 4: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 5: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getHTTP_2_0();
                break;
            }
            case 6: {
                httpProtocolVersion = HttpProtocolVersion.Companion.getQUIC();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpProtocolVersion;
    }

    private static final Throwable mapOkHttpException(HttpRequestData requestData, IOException origin) {
        Throwable throwable;
        IOException iOException = origin;
        if (iOException instanceof StreamAdapterIOException) {
            throwable = origin.getCause();
            if (throwable == null) {
                throwable = origin;
            }
        } else {
            throwable = iOException instanceof SocketTimeoutException ? (Throwable)(OkUtilsKt.isConnectException(origin) ? (IOException)HttpTimeoutKt.ConnectTimeoutException((HttpRequestData)requestData, (Throwable)origin) : (IOException)HttpTimeoutKt.SocketTimeoutException((HttpRequestData)requestData, (Throwable)origin)) : (Throwable)origin;
        }
        return throwable;
    }

    private static final boolean isConnectException(IOException $this$isConnectException) {
        String string = $this$isConnectException.getMessage();
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"connect", (boolean)true) : false;
    }

    public static final /* synthetic */ Throwable access$mapOkHttpException(HttpRequestData requestData, IOException origin) {
        return OkUtilsKt.mapOkHttpException(requestData, origin);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Protocol.values().length];
            try {
                nArray[Protocol.HTTP_1_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.HTTP_1_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.SPDY_3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.HTTP_2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.H2_PRIOR_KNOWLEDGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Protocol.QUIC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

