/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.settings;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.settings.KubernetesLogsSettings;
import com.intellij.kubernetes.view.ui.KubernetesUIUtilitiesKt;
import com.intellij.kubernetes.view.ui.settings.KubernetesGridBagSettingsPanel;
import com.intellij.kubernetes.view.ui.settings.KubernetesGridBagSettingsPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesLogsSettingsPanel;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesGridBagSettingsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "askWhereToDownloadRadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "downloadPathRadioButton", "downloadPathSelector", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "downloadPathValidator", "Lcom/intellij/openapi/ui/ComponentValidator;", "kotlin.jvm.PlatformType", "isModified", "", "()Z", "timestampedLogNameCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "apply", "", "dispose", "reset", "updateDownloadPathUI", "validateDownloadPath", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogsSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogsSettingsPanel.kt\ncom/intellij/kubernetes/view/ui/settings/KubernetesLogsSettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class KubernetesLogsSettingsPanel
extends KubernetesGridBagSettingsPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBRadioButton downloadPathRadioButton;
    @NotNull
    private final TextFieldWithBrowseButton downloadPathSelector;
    private final ComponentValidator downloadPathValidator;
    @NotNull
    private final JBRadioButton askWhereToDownloadRadioButton;
    @NotNull
    private final JBCheckBox timestampedLogNameCheckbox;

    /*
     * WARNING - void declaration
     */
    public KubernetesLogsSettingsPanel(@NotNull Project project2) {
        void $this$downloadPathSelector_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.downloadPathRadioButton = new JBRadioButton(KubernetesBundle.message("KubernetesLogsSettingsPanel.downloadPathRadioButton.text", new Object[0]));
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(null, (Disposable)this);
        Object object = textFieldWithBrowseButton;
        KubernetesLogsSettingsPanel kubernetesLogsSettingsPanel = this;
        boolean bl = false;
        $this$downloadPathSelector_u24lambda_u240.addBrowseFolderListener(KubernetesBundle.message("KubernetesLogsSettingsPanel.selectDownloadPath.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        kubernetesLogsSettingsPanel.downloadPathSelector = textFieldWithBrowseButton;
        this.downloadPathValidator = new ComponentValidator((Disposable)this).withValidator(this::validateDownloadPath).withFocusValidator(this::validateDownloadPath).withOutlineProvider(ComponentValidator.CWBB_PROVIDER);
        this.askWhereToDownloadRadioButton = new JBRadioButton(KubernetesBundle.message("KubernetesLogsSettingsPanel.askWhereToDownloadRadioButton.text", new Object[0]));
        this.timestampedLogNameCheckbox = new JBCheckBox(KubernetesBundle.message("KubernetesLogsSettingsPanel.timestampedLogNameCheckbox.text", new Object[0]));
        String string = KubernetesBundle.message("KubernetesLogsSettingsPanel.downloadPath.emptyText", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        KubernetesUIUtilitiesKt.setEmptyText(this.downloadPathSelector, string);
        GridBag gridBag = KubernetesGridBagSettingsPanelKt.createGridBag();
        KubernetesGridBagSettingsPanelKt.add((Container)this, (Component)this.downloadPathRadioButton, (Component)this.downloadPathSelector, gridBag);
        this.downloadPathValidator.installOn((JComponent)this.downloadPathSelector);
        this.downloadPathSelector.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                downloadPathValidator.revalidate();
            }
        });
        this.add((Component)this.askWhereToDownloadRadioButton, gridBag.nextLine().next().coverLine());
        Object $this$_init__u24lambda_u241 = object = new ButtonGroup();
        boolean bl2 = false;
        ((ButtonGroup)$this$_init__u24lambda_u241).add((AbstractButton)this.downloadPathRadioButton);
        ((ButtonGroup)$this$_init__u24lambda_u241).add((AbstractButton)this.askWhereToDownloadRadioButton);
        this.downloadPathRadioButton.addActionListener(arg_0 -> KubernetesLogsSettingsPanel._init_$lambda$2(this, arg_0));
        this.askWhereToDownloadRadioButton.addActionListener(arg_0 -> KubernetesLogsSettingsPanel._init_$lambda$3(this, arg_0));
        KubernetesGridBagSettingsPanelKt.coverLineLargeVGap(this, (Component)this.timestampedLogNameCheckbox, gridBag);
    }

    public void dispose() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ValidationInfo validateDownloadPath() {
        boolean bl;
        String string;
        String string2;
        String string3 = KubernetesUIUtilitiesKt.getPath(this.downloadPathSelector);
        if (string3 == null) return null;
        String it = string2 = string3;
        boolean bl2 = false;
        if (!this.downloadPathRadioButton.isSelected()) return null;
        String string4 = string2;
        String string5 = string4;
        if (string5 == null) return null;
        String it2 = string = string5;
        boolean bl3 = false;
        try {
            File $this$validateDownloadPath_u24lambda_u246_u24lambda_u245 = new File(it2);
            boolean bl4 = false;
            if ($this$validateDownloadPath_u24lambda_u246_u24lambda_u245.exists() && $this$validateDownloadPath_u24lambda_u246_u24lambda_u245.isDirectory()) {
                return null;
            }
            boolean bl5 = false;
            bl = bl5;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (bl) return null;
        String string6 = string;
        string2 = string6;
        if (string2 == null) return null;
        it2 = string2;
        boolean bl6 = false;
        ValidationInfo validationInfo = new ValidationInfo(KubernetesBundle.message("KubernetesLogsSettingsPanel.downloadPath.errorMessage", new Object[0]), (JComponent)this.downloadPathSelector);
        return validationInfo;
    }

    private final void updateDownloadPathUI() {
        this.downloadPathSelector.setEnabled(this.downloadPathRadioButton.isSelected());
    }

    @Override
    public boolean isModified() {
        KubernetesLogsSettings settings2 = KubernetesLogsSettings.Companion.getInstance();
        return settings2.getAskWhereToDownload() != this.askWhereToDownloadRadioButton.isSelected() || settings2.getTimestampedLogName() != this.timestampedLogNameCheckbox.isSelected() || !Intrinsics.areEqual((Object)settings2.getDownloadPath(), (Object)KubernetesUIUtilitiesKt.getPath(this.downloadPathSelector));
    }

    @Override
    public void apply() {
        KubernetesLogsSettings settings2 = KubernetesLogsSettings.Companion.getInstance();
        settings2.setAskWhereToDownload(this.askWhereToDownloadRadioButton.isSelected());
        settings2.setDownloadPath(KubernetesUIUtilitiesKt.getPath(this.downloadPathSelector));
        settings2.setTimestampedLogName(this.timestampedLogNameCheckbox.isSelected());
    }

    @Override
    public void reset() {
        KubernetesLogsSettings settings2 = KubernetesLogsSettings.Companion.getInstance();
        if (settings2.getAskWhereToDownload()) {
            this.askWhereToDownloadRadioButton.setSelected(true);
        } else {
            this.downloadPathRadioButton.setSelected(true);
        }
        String downloadPath = settings2.getDownloadPath();
        this.downloadPathSelector.setText(downloadPath);
        this.timestampedLogNameCheckbox.setSelected(settings2.getTimestampedLogName());
        this.updateDownloadPathUI();
        this.downloadPathValidator.enableValidation();
        this.downloadPathValidator.revalidate();
        if (downloadPath == null) {
            this.downloadPathValidator.andStartOnFocusLost();
        }
    }

    private static final void _init_$lambda$2(KubernetesLogsSettingsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateDownloadPathUI();
    }

    private static final void _init_$lambda$3(KubernetesLogsSettingsPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateDownloadPathUI();
    }
}

