/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.secret;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\f\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bH\u0000\u001a-\u0010\u000f\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0015\u0010\u0011\u001a\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014H\u0000\u001a-\u0010\u0015\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0015\u0010\u0011\u001a\u00110\u000b\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"secretNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isAlphanumeric", "", "character", "", "validateAnnotationName", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "fullName", "", "validateDNSName", "name", "nameDescription", "validateFileExists", "text", "messageKey", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.KubernetesBundle", "validateValueNotBlank", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/kubernetes/view/ui/secret/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class UtilsKt {
    private static final Pattern secretNamePattern = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$");

    @Nullable
    public static final ValidationInfo validateDNSName(@NotNull ValidationInfoBuilder $this$validateDNSName, @NotNull String name2, @NotNull String nameDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$validateDNSName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)nameDescription, (String)"nameDescription");
        if (name2.length() > 253) {
            Object[] objectArray = new Object[]{nameDescription, name2.length()};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.dns.name.validation.length", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateDNSName.error(string);
        }
        int n = name2.length();
        for (int i = 0; i < n; ++i) {
            char character = name2.charAt(i);
            if (UtilsKt.isAlphanumeric(character) || character == '-' || character == '.') continue;
            Object[] objectArray = new Object[]{nameDescription};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.dns.name.validation.characters", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateDNSName.error(string);
        }
        if (!UtilsKt.isAlphanumeric(StringsKt.first((CharSequence)name2))) {
            Object[] objectArray = new Object[]{nameDescription};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.dns.name.validation.start", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateDNSName.error(string);
        }
        if (!UtilsKt.isAlphanumeric(StringsKt.last((CharSequence)name2))) {
            Object[] objectArray = new Object[]{nameDescription};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.dns.name.validation.end", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateDNSName.error(string);
        }
        if (!secretNamePattern.matcher(name2).matches()) {
            Object[] objectArray = new Object[]{nameDescription};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.dns.name.validation.domain", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateDNSName.error(string);
        }
        return null;
    }

    public static /* synthetic */ ValidationInfo validateDNSName$default(ValidationInfoBuilder validationInfoBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            String string3 = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.validation.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            string2 = string3;
        }
        return UtilsKt.validateDNSName(validationInfoBuilder, string, string2);
    }

    @Nullable
    public static final ValidationInfo validateAnnotationName(@NotNull ValidationInfoBuilder $this$validateAnnotationName, @NotNull String fullName) {
        Intrinsics.checkNotNullParameter((Object)$this$validateAnnotationName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        String qualifierName = StringsKt.substringAfter$default((String)fullName, (String)"/", null, (int)2, null);
        ValidationInfo validationInfo = UtilsKt.validateValueNotBlank($this$validateAnnotationName, qualifierName, "KubernetesCreateNewSecretDialog.secret.annotation.name.validation");
        if (validationInfo != null) {
            ValidationInfo it = validationInfo;
            boolean bl = false;
            return it;
        }
        if (qualifierName.length() > 63) {
            Object[] objectArray = new Object[]{qualifierName.length()};
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.annotation.name.validation.length", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateAnnotationName.error(string);
        }
        int n = qualifierName.length();
        for (int i = 0; i < n; ++i) {
            char character = qualifierName.charAt(i);
            if (UtilsKt.isAlphanumeric(character) || character == '-' || character == '.' || character == '_') continue;
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.annotation.name.validation.characters", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateAnnotationName.error(string);
        }
        if (!UtilsKt.isAlphanumeric(StringsKt.first((CharSequence)qualifierName))) {
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.annotation.name.validation.start", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateAnnotationName.error(string);
        }
        if (!UtilsKt.isAlphanumeric(StringsKt.last((CharSequence)qualifierName))) {
            String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.annotation.name.validation.end", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return $this$validateAnnotationName.error(string);
        }
        if (!StringsKt.contains$default((CharSequence)fullName, (CharSequence)"/", (boolean)false, (int)2, null)) {
            return null;
        }
        String prefix = StringsKt.substringBefore((String)fullName, (String)"/", (String)"");
        ValidationInfo validationInfo2 = UtilsKt.validateValueNotBlank($this$validateAnnotationName, prefix, "KubernetesCreateNewSecretDialog.secret.annotation.prefix.validation");
        if (validationInfo2 != null) {
            ValidationInfo it = validationInfo2;
            boolean bl = false;
            return it;
        }
        String string = KubernetesBundle.message("KubernetesCreateNewSecretDialog.secret.validation.annotation.prefix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return UtilsKt.validateDNSName($this$validateAnnotationName, prefix, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAlphanumeric(char character) {
        boolean bl;
        if ('a' <= character) {
            if (character < '{') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('0' > character) return false;
        if (character >= ':') return false;
        return true;
    }

    @Nullable
    public static final ValidationInfo validateValueNotBlank(@NotNull ValidationInfoBuilder $this$validateValueNotBlank, @NotNull String text, @NotNull String messageKey) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validateValueNotBlank, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)messageKey, (String)"messageKey");
        if (!StringsKt.isBlank((CharSequence)text)) {
            validationInfo = null;
        } else {
            String string = KubernetesBundle.message(messageKey, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validateValueNotBlank.error(string);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo validateFileExists(@NotNull ValidationInfoBuilder $this$validateFileExists, @NotNull String text, @NotNull String messageKey) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validateFileExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)messageKey, (String)"messageKey");
        Path path = Paths.get(text, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            validationInfo = null;
        } else {
            String string = KubernetesBundle.message(messageKey, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validateFileExists.error(string);
        }
        return validationInfo;
    }
}

