/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceVirtualFileBasedActionBase;
import com.intellij.kubernetes.view.vfs.KubernetesVirtualDirectory;
import com.intellij.kubernetes.view.vfs.ResourceContext;
import com.intellij.kubernetes.view.vfs.ResourceContextKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J5\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00028\u00002\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\fH\u0015J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDescribeResourceAction;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesResourceVirtualFileBasedActionBase;", "()V", "actionPerformed", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getContext", "Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "Lio/kubernetes/client/common/KubernetesListObject;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "getOrCreateVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "saveText", "file", "text", "", "intellij.clouds.kubernetes"})
public final class KubernetesDescribeResourceAction<T extends KubernetesObject>
extends KubernetesResourceVirtualFileBasedActionBase<T> {
    public KubernetesDescribeResourceAction() {
        super(Reflection.getOrCreateKotlinClass(KubernetesObject.class));
    }

    @Override
    @NotNull
    protected ResourceContext<T, ? extends KubernetesListObject> getContext(@NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new ResourceContext(resource, mapper, true);
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        EventId1<String> eventId1 = KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT();
        Project project2 = event2.getProject();
        Intrinsics.checkNotNull((Object)project2);
        eventId1.log(project2, (Object)"describe-resources");
        super.actionPerformed(apiModel2, event2);
    }

    @Override
    @RequiresWriteLock
    @NotNull
    protected VirtualFile getOrCreateVirtualFile(@NotNull Project project2, @NotNull ResourceContext<T, ?> context) {
        LightVirtualFileBase lightVirtualFileBase;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        KubernetesVirtualDirectory kubernetesVirtualDirectory = ResourceContextKt.getRootDirectory(context, project2);
        String string = context.getResourceName$intellij_clouds_kubernetes();
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextFileType, (String)"INSTANCE");
        LightVirtualFileBase $this$getOrCreateVirtualFile_u24lambda_u240 = lightVirtualFileBase = kubernetesVirtualDirectory.touch(string, (LanguageFileType)plainTextFileType);
        boolean bl = false;
        $this$getOrCreateVirtualFile_u24lambda_u240.setWritable(false);
        ResourceContextKt.setResourceContext((VirtualFile)$this$getOrCreateVirtualFile_u24lambda_u240, context);
        return (VirtualFile)lightVirtualFileBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveText(@NotNull VirtualFile file2, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            file2.setWritable(true);
            super.saveText(file2, text);
        }
        finally {
            file2.setWritable(false);
        }
    }
}

