/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesDeploymentServiceViewDescriptor;
import com.intellij.kubernetes.view.execution.KubernetesDeploymentService;
import com.intellij.kubernetes.view.ui.KubernetesDeploymentContent;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeploymentActionBase;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeploymentActionBaseKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeploymentFollowLogAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeploymentActionBase;", "()V", "actionPerformed", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.clouds.kubernetes"})
public final class KubernetesDeploymentFollowLogAction
extends KubernetesDeploymentActionBase {
    @Override
    protected void update(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Presentation presentation = event2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Object[] objectArray = new Object[1];
        Object t = this.getResource(event2);
        Intrinsics.checkNotNull(t);
        V1ObjectMeta v1ObjectMeta = ((V1Deployment)t).getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        objectArray[0] = v1ObjectMeta.getName();
        Supplier<String> supplier = KubernetesBundle.messagePointer("action.Kubernetes.DeploymentFollowLog.named.description", objectArray);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        Supplier<String> description = supplier;
        presentation2.setDescription(description);
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project2 = event2.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project3, (Object)"deployment-follow");
        Object t = this.getResource(event2);
        Intrinsics.checkNotNull(t);
        V1Deployment resource = (V1Deployment)t;
        KubernetesDeploymentServiceViewDescriptor kubernetesDeploymentServiceViewDescriptor = KubernetesDeploymentActionBaseKt.getSelectedDeploymentDescriptor(event2);
        Intrinsics.checkNotNull((Object)kubernetesDeploymentServiceViewDescriptor);
        KubernetesDeploymentServiceViewDescriptor deploymentDescriptor = kubernetesDeploymentServiceViewDescriptor;
        KubernetesDeploymentService.Companion.getInstance(project3).streamLog(apiModel2, resource, ((KubernetesDeploymentContent)deploymentDescriptor.getContent$intellij_clouds_kubernetes()).createLogPanel(resource));
    }
}

