/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.ide.DeleteProvider;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesContextServiceViewContributor;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeletableServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProvider;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProviderKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareActionKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceActionBaseKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.util.ArrayUtil;
import io.kubernetes.client.common.KubernetesObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u001c\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0015\u0012\u0002\b\u00030\u00160\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider;", "Lcom/intellij/ide/DeleteProvider;", "()V", "askDeleteDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "Lorg/jetbrains/annotations/Nls;", "askHideDialog", "canDeleteElement", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "deleteElement", "", "deleteResources", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "resourcesToMappers", "", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesDeleteResourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesDeleteResourceProvider.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider\n+ 2 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,149:1\n15#2,2:150\n15#2,2:156\n12474#3,2:152\n12474#3,2:154\n4098#3,11:158\n11383#3,9:173\n13309#3:182\n13310#3:184\n11392#3:185\n11383#3,9:186\n13309#3:195\n13310#3:199\n11392#3:200\n1549#4:169\n1620#4,3:170\n1#5:183\n1#5:198\n14#6:196\n14#6:197\n13#7:201\n*S KotlinDebug\n*F\n+ 1 KubernetesDeleteResourceProvider.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider\n*L\n35#1:150,2\n43#1:156,2\n36#1:152,2\n37#1:154,2\n44#1:158,11\n56#1:173,9\n56#1:182\n56#1:184\n56#1:185\n76#1:186,9\n76#1:195\n76#1:199\n76#1:200\n47#1:169\n47#1:170,3\n56#1:183\n76#1:198\n77#1:196\n78#1:197\n89#1:201\n*E\n"})
public final class KubernetesDeleteResourceProvider
implements DeleteProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final DataProvider dataProvider = KubernetesDeleteResourceProvider::dataProvider$lambda$6;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Object it;
        Object element$iv;
        int n;
        Object[] selectedItems;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = KubernetesDeleteResourceProviderKt.access$getProject(dataContext);
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        DataContext $this$selectedItems$iv = dataContext;
        boolean $i$f$getSelectedItems = false;
        Object[] objectArray2 = (Object[])$this$selectedItems$iv.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (objectArray2 == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = objectArray2;
        }
        Object[] $this$any$iv = selectedItems = objectArray;
        boolean $i$f$any = false;
        int n2 = $this$any$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it instanceof ServiceViewContributor && ((ServiceViewContributor)it).getViewDescriptor(project3) instanceof KubernetesDeletableServiceViewDescriptor) {
                return true;
            }
            boolean bl2 = false;
            if (!bl2) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (KubernetesModelBasedDumbAwareActionKt.getApiModel(dataContext) == null) return false;
        $this$any$iv = selectedItems;
        $i$f$any = false;
        n = 0;
        n2 = $this$any$iv.length;
        while (n < n2) {
            it = element$iv = $this$any$iv[n];
            boolean bl3 = false;
            if (KubernetesResourceActionBaseKt.getResource(it) != null) {
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        Object[] $this$mapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object[] selectedItems;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = KubernetesDeleteResourceProviderKt.access$getProject(dataContext);
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        DataContext $this$selectedItems$iv = dataContext;
        boolean $i$f$getSelectedItems = false;
        Object[] objectArray2 = (Object[])$this$selectedItems$iv.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (objectArray2 == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = objectArray2;
        }
        Object[] $this$filterIsInstance$iv = selectedItems = objectArray;
        boolean $i$f$filterIsInstance22 = false;
        Object[] objectArray3 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void var12_27 : $this$filterIsInstanceTo$iv$iv) {
            if (!(var12_27 instanceof KubernetesContextServiceViewContributor)) continue;
            destination$iv$iv.add(var12_27);
        }
        List serviceViewContributors = (List)destination$iv$iv;
        if (!((Collection)serviceViewContributors).isEmpty()) {
            void $this$map$iv;
            Iterable $i$f$filterIsInstance22 = serviceViewContributors;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                KubernetesContextServiceViewContributor kubernetesContextServiceViewContributor = (KubernetesContextServiceViewContributor)t;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getApiModel$intellij_clouds_kubernetes().getCurrentContextObject$intellij_clouds_kubernetes());
            }
            List contexts2 = (List)destination$iv$iv2;
            if (this.askHideDialog(project3, CollectionsKt.joinToString$default((Iterable)contexts2, null, null, null, (int)0, null, (Function1)deleteElement.1.INSTANCE, (int)31, null))) {
                KubernetesApiProvider.Companion.getInstance(project3).removeContexts$intellij_clouds_kubernetes(contexts2);
            }
            return;
        }
        Object[] $this$mapNotNull$iv = selectedItems;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        Object[] destination$iv$iv3 = (Object[])new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean bl = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int it = 0; it < n; ++it) {
            Pair pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[it];
            boolean bl2 = false;
            void item = element$iv$iv;
            boolean bl22 = false;
            if (KubernetesResourceActionBaseKt.getResource(item) != null) {
                KubernetesObject it2;
                boolean bl3 = false;
                KubernetesResourceMapper<?, ?> kubernetesResourceMapper = KubernetesResourceActionBaseKt.getMapper(item);
                Intrinsics.checkNotNull(kubernetesResourceMapper);
                pair = TuplesKt.to((Object)it2, kubernetesResourceMapper);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Map resourcesToMappers = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
        if (!resourcesToMappers.isEmpty()) {
            String displayableNames2 = CollectionsKt.joinToString$default((Iterable)resourcesToMappers.entrySet(), null, null, null, (int)0, null, (Function1)deleteElement.displayableNames.1.INSTANCE, (int)31, null);
            if (this.askDeleteDialog(project3, displayableNames2)) {
                KubernetesApiModel kubernetesApiModel = KubernetesModelBasedDumbAwareActionKt.getApiModel(dataContext);
                Intrinsics.checkNotNull((Object)kubernetesApiModel);
                this.deleteResources(kubernetesApiModel, resourcesToMappers);
            }
            return;
        }
        Object[] $this$mapNotNull$iv2 = selectedItems;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv3 = $this$mapNotNull$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void var12_31 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        int n2 = ((void)var12_31).length;
        for (n = 0; n < n2; ++n) {
            KubernetesDeletableServiceViewDescriptor kubernetesDeletableServiceViewDescriptor;
            ServiceViewDescriptor serviceViewDescriptor;
            ServiceViewContributor serviceViewContributor;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var12_31[n];
            boolean bl3 = false;
            void it = element$iv$iv;
            boolean bl5 = false;
            void $this$asSafely$iv = it;
            boolean $i$f$asSafely22 = false;
            Object v5 = $this$asSafely$iv;
            if (!(v5 instanceof ServiceViewContributor)) {
                v5 = null;
            }
            if ((serviceViewContributor = (ServiceViewContributor)v5) != null && (serviceViewDescriptor = serviceViewContributor.getViewDescriptor(project3)) != null) {
                void $this$asSafely$iv2;
                ServiceViewDescriptor $i$f$asSafely22 = serviceViewDescriptor;
                boolean $i$f$asSafely3 = false;
                Object v6 = $this$asSafely$iv2;
                if (!(v6 instanceof KubernetesDeletableServiceViewDescriptor)) {
                    v6 = null;
                }
                kubernetesDeletableServiceViewDescriptor = v6;
            } else {
                kubernetesDeletableServiceViewDescriptor = null;
            }
            if (kubernetesDeletableServiceViewDescriptor == null) continue;
            KubernetesDeletableServiceViewDescriptor it$iv$iv = kubernetesDeletableServiceViewDescriptor;
            boolean bl6 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List deletables = (List)destination$iv$iv4;
        if (!((Collection)deletables).isEmpty()) {
            String toDelete2 = CollectionsKt.joinToString$default((Iterable)deletables, null, null, null, (int)0, null, (Function1)deleteElement.toDelete.1.INSTANCE, (int)31, null);
            if (this.askHideDialog(project3, toDelete2)) {
                for (KubernetesDeletableServiceViewDescriptor deletable : deletables) {
                    Runnable remover = deletable.getRemover();
                    if (remover != null) {
                        remover.run();
                        continue;
                    }
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KubernetesDeleteResourceProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("failed to delete " + deletable + " of " + deletable.getClass());
                }
            }
            return;
        }
    }

    private final void deleteResources(KubernetesApiModel apiModel2, Map<KubernetesObject, ? extends KubernetesResourceMapper<KubernetesObject, ?>> resourcesToMappers) {
        Project project2 = apiModel2.getProject();
        KubernetesResourceService kubernetesResourceService = KubernetesResourceService.Companion.getInstance(project2);
        String string = KubernetesBundle.message("KubectlExecutor.delete.progressTitle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        kubernetesResourceService.schedule(string, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(resourcesToMappers, apiModel2, project2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ Map<KubernetesObject, KubernetesResourceMapper<KubernetesObject, ?>> $resourcesToMappers;
            final /* synthetic */ KubernetesApiModel $apiModel;
            final /* synthetic */ Project $project;
            {
                this.$resourcesToMappers = $resourcesToMappers;
                this.$apiModel = $apiModel;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        messages = new ArrayList<E>();
                        try {
                            var3_4 = this.$resourcesToMappers.entrySet().iterator();
                        }
                        catch (Throwable var3_5) {
                            if (((Collection)messages).isEmpty() == false == false) throw var3_6;
                            KubernetesNotificationManager.Companion.getInstance(this.$project).reportWarning(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                            if (KubernetesApiGlobalSettings.Companion.getInstance().getRefreshResourcesAfterActionConfig() == false) throw var3_6;
                            this.L$0 = var3_5;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 3;
                            v0 = this.$apiModel.refresh$intellij_clouds_kubernetes((Continuation<? super Unit>)((Continuation)this));
                            v1 = v0;
                            if (v0 != var8_2) throw var3_6;
                            return var8_2;
                        }
lbl22:
                        // 2 sources

                        while (var3_4.hasNext()) {
                            var4_7 = var3_4.next();
                            resource = var4_7.getKey();
                            mapper = var4_7.getValue();
                            var7_10 = messages;
                            this.L$0 = messages;
                            this.L$1 = var3_4;
                            this.L$2 = var7_10;
                            this.label = 1;
                            v2 = this.$apiModel.delete(resource, mapper.getEntity$intellij_clouds_kubernetes(), (Continuation<? super String>)((Continuation)this));
                            if (v2 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl43
                        }
                        ** GOTO lbl46
                    }
                    case 1: {
                        var7_10 = (Collection)this.L$2;
                        var3_4 = (Iterator<Map.Entry<KubernetesObject, KubernetesResourceMapper<KubernetesObject, ?>>>)this.L$1;
                        messages = (List)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl43:
                            // 2 sources

                            var7_10.add(v2);
                            ** GOTO lbl22
                        }
                    }
lbl46:
                    // 1 sources

                    if (((Collection)messages).isEmpty() == false == false) return Unit.INSTANCE;
                    KubernetesNotificationManager.Companion.getInstance(this.$project).reportWarning(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    if (KubernetesApiGlobalSettings.Companion.getInstance().getRefreshResourcesAfterActionConfig() == false) return Unit.INSTANCE;
                    this.L$0 = null;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 2;
                    v3 = this.$apiModel.refresh$intellij_clouds_kubernetes((Continuation<? super Unit>)((Continuation)this));
                    v4 = v3;
                    if (v3 != var8_2) return Unit.INSTANCE;
                    return var8_2;
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        return Unit.INSTANCE;
                    }
                    case 3: {
                        var3_6 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        throw var3_6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final boolean askDeleteDialog(Project project2, String text) {
        String string = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{text};
        String string2 = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = KubernetesBundle.message("action.Kubernetes.DeleteResource.confirmation.yes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return ((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3)).ask(project2);
    }

    private final boolean askHideDialog(Project project2, String text) {
        String string = KubernetesBundle.message("action.Kubernetes.hide.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{text};
        String string2 = KubernetesBundle.message("action.Kubernetes.hide.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = KubernetesBundle.message("action.Kubernetes.hide.confirmation.yes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return ((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3)).ask(project2);
    }

    private static final Object dataProvider$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(it) ? new KubernetesDeleteResourceProvider() : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeleteResourceProvider$Companion;", "", "()V", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

