/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.view.ui.actions.KubernetesCreateNewSecretAction;
import com.intellij.kubernetes.view.ui.secret.FileSecretEntry;
import com.intellij.kubernetes.view.ui.secret.KeyValueEntry;
import com.intellij.kubernetes.view.ui.secret.SecretEntry;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\"\u0010\t\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a:\u0010\u0010\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0015\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "appendAnnotations", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "annotations", "", "Lcom/intellij/kubernetes/view/ui/secret/SecretEntry;", "appendKey", "key", "", "tabulationCount", "", "appendNonEncodedData", "nonEncodedData", "appendSecretHeader", "name", "namespace", "type", "appendValue", "value", "encodeAndAppendValue", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesCreateNewSecretAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesCreateNewSecretAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesCreateNewSecretActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1855#2,2:126\n1855#2,2:128\n1#3:130\n13#4:131\n*S KotlinDebug\n*F\n+ 1 KubernetesCreateNewSecretAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesCreateNewSecretActionKt\n*L\n81#1:126,2\n94#1:128,2\n14#1:131\n*E\n"})
public final class KubernetesCreateNewSecretActionKt {
    @NotNull
    private static final Logger LOG;

    private static final void appendSecretHeader(Appendable $this$appendSecretHeader, String name2, String namespace, String type, List<? extends SecretEntry> annotations) {
        LOG.assertTrue(!StringsKt.isBlank((CharSequence)name2));
        Appendable appendable = $this$appendSecretHeader.append("apiVersion: v1");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Appendable appendable2 = $this$appendSecretHeader.append("metadata:");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
        $this$appendSecretHeader.append("  name: ");
        Appendable appendable3 = $this$appendSecretHeader.append("\"" + name2 + "\"");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
        CharSequence charSequence = namespace;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$appendSecretHeader.append("  namespace: ");
            Appendable appendable4 = $this$appendSecretHeader.append(namespace);
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable4.append('\n'), (String)"append(...)");
        }
        KubernetesCreateNewSecretActionKt.appendAnnotations($this$appendSecretHeader, annotations);
        Appendable appendable5 = $this$appendSecretHeader.append("kind: Secret");
        Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable5.append('\n'), (String)"append(...)");
        charSequence = type;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$appendSecretHeader.append("type: ");
            Appendable appendable6 = $this$appendSecretHeader.append(type);
            Intrinsics.checkNotNullExpressionValue((Object)appendable6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable6.append('\n'), (String)"append(...)");
        }
    }

    private static final void appendAnnotations(Appendable $this$appendAnnotations, List<? extends SecretEntry> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        Appendable appendable = $this$appendAnnotations.append("  annotations:");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = annotations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SecretEntry secret = (SecretEntry)element$iv;
            boolean bl = false;
            KubernetesCreateNewSecretActionKt.appendKey($this$appendAnnotations, secret.getKey(), 2);
            SecretEntry secretEntry = secret;
            if (secretEntry instanceof KeyValueEntry) {
                KubernetesCreateNewSecretActionKt.appendValue($this$appendAnnotations, ((KeyValueEntry)secret).getValue());
                continue;
            }
            if (!(secretEntry instanceof FileSecretEntry)) continue;
            LOG.error("File secret entry in annotation section: " + secret.getKey());
        }
    }

    private static final void appendNonEncodedData(Appendable $this$appendNonEncodedData, List<? extends SecretEntry> nonEncodedData) {
        if (nonEncodedData.isEmpty()) {
            return;
        }
        Appendable appendable = $this$appendNonEncodedData.append("data:");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = nonEncodedData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SecretEntry secret = (SecretEntry)element$iv;
            boolean bl = false;
            KubernetesCreateNewSecretActionKt.appendKey$default($this$appendNonEncodedData, secret.getKey(), 0, 2, null);
            SecretEntry secretEntry = secret;
            if (secretEntry instanceof KeyValueEntry) {
                byte[] byArray = ((KeyValueEntry)secret).getValue().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                KubernetesCreateNewSecretActionKt.encodeAndAppendValue($this$appendNonEncodedData, byArray);
                continue;
            }
            if (!(secretEntry instanceof FileSecretEntry)) continue;
            byte[] byArray = Files.readAllBytes(((FileSecretEntry)secret).getPath());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            KubernetesCreateNewSecretActionKt.encodeAndAppendValue($this$appendNonEncodedData, byArray);
        }
    }

    private static final void appendKey(Appendable $this$appendKey, String key2, int tabulationCount) {
        LOG.assertTrue(!StringsKt.isBlank((CharSequence)key2));
        int n = 0;
        while (n < tabulationCount) {
            int it = n++;
            boolean bl = false;
            $this$appendKey.append("  ");
        }
        $this$appendKey.append(key2);
    }

    static /* synthetic */ void appendKey$default(Appendable appendable, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        KubernetesCreateNewSecretActionKt.appendKey(appendable, string, n);
    }

    private static final void encodeAndAppendValue(Appendable $this$encodeAndAppendValue, byte[] value2) {
        LOG.assertTrue(!(value2.length == 0));
        $this$encodeAndAppendValue.append(": ");
        $this$encodeAndAppendValue.append(Base64.getEncoder().encodeToString(value2));
        Intrinsics.checkNotNullExpressionValue((Object)$this$encodeAndAppendValue.append('\n'), (String)"append(...)");
    }

    private static final void appendValue(Appendable $this$appendValue, String value2) {
        LOG.assertTrue(!StringsKt.isBlank((CharSequence)value2));
        $this$appendValue.append(": ");
        $this$appendValue.append(value2);
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendValue.append('\n'), (String)"append(...)");
    }

    public static final /* synthetic */ void access$appendSecretHeader(Appendable $receiver, String name2, String namespace, String type, List annotations) {
        KubernetesCreateNewSecretActionKt.appendSecretHeader($receiver, name2, namespace, type, annotations);
    }

    public static final /* synthetic */ void access$appendNonEncodedData(Appendable $receiver, List nonEncodedData) {
        KubernetesCreateNewSecretActionKt.appendNonEncodedData($receiver, nonEncodedData);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesCreateNewSecretAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

