/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.actions.JavaTimeYamlConstructor;
import com.intellij.kubernetes.view.ui.actions.KubernetesCompareWithClusterActionKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceEditorAction;
import com.intellij.kubernetes.view.vfs.ResourceContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000E\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\u001a0\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0083@\u00a2\u0006\u0002\u0010\u000b\u001a\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003\u00a2\u0006\u0002\u0010\u0010\u001a\b\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0012\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a+\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u0004*\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0003\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "calculateResourceContext", "Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "Lio/kubernetes/client/common/KubernetesObject;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;Lorg/jetbrains/yaml/psi/YAMLFile;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLightImmutableCopy", "com/intellij/kubernetes/view/ui/actions/KubernetesCompareWithClusterActionKt$createLightImmutableCopy$1", "content", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)Lcom/intellij/kubernetes/view/ui/actions/KubernetesCompareWithClusterActionKt$createLightImmutableCopy$1;", "currentTimestamp", "findResourceMapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "unmarshal", "T", "resourceClass", "Lkotlin/reflect/KClass;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/reflect/KClass;)Lio/kubernetes/client/common/KubernetesObject;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesCompareWithClusterAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesCompareWithClusterAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesCompareWithClusterActionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,237:1\n13#2:238\n*S KotlinDebug\n*F\n+ 1 KubernetesCompareWithClusterAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesCompareWithClusterActionKt\n*L\n46#1:238\n*E\n"})
public final class KubernetesCompareWithClusterActionKt {
    @NotNull
    private static final Logger LOG;

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final KubernetesResourceMapper<?, ?> findResourceMapper(YAMLFile yamlFile) {
        YAMLDocument yAMLDocument;
        List list2 = yamlFile.getDocuments();
        YAMLValue yAMLValue = list2 != null && (yAMLDocument = (YAMLDocument)CollectionsKt.singleOrNull((List)list2)) != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping yamlMapping = yAMLMapping;
        if (YamlUtilKt.get(yamlMapping, "apiVersion") == null) {
            return null;
        }
        if (YamlUtilKt.get(yamlMapping, "metadata") == null) {
            return null;
        }
        Object object = YamlUtilKt.get(yamlMapping, "kind");
        if (object == null || (object = YamlUtilKt.getEffectiveText(object)) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            return null;
        }
        Object kind = object;
        return KubernetesResourceMapper.Companion.find((Function1)new Function1<KubernetesEntity<?, ?>, Boolean>((String)kind){
            final /* synthetic */ String $kind;
            {
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KubernetesEntity<?, ?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)it.getKind(), (Object)this.$kind);
            }
        });
    }

    @RequiresBackgroundThread
    private static final Object calculateResourceContext(KubernetesApiModel apiModel2, YAMLFile yamlFile, VirtualFile virtualFile, Continuation<? super ResourceContext<KubernetesObject, ?>> $completion) {
        return CoroutinesKt.readAction((Function0)((Function0)new Function0<ResourceContext<KubernetesObject, ? extends KubernetesListObject>>(yamlFile, virtualFile, apiModel2){
            final /* synthetic */ YAMLFile $yamlFile;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ KubernetesApiModel $apiModel;
            {
                this.$yamlFile = $yamlFile;
                this.$virtualFile = $virtualFile;
                this.$apiModel = $apiModel;
                super(0);
            }

            @NotNull
            public final ResourceContext<KubernetesObject, ? extends KubernetesListObject> invoke() {
                KubernetesResourceMapper kubernetesResourceMapper = KubernetesCompareWithClusterActionKt.access$findResourceMapper(this.$yamlFile);
                Intrinsics.checkNotNull((Object)kubernetesResourceMapper);
                KubernetesResourceMapper mapper = kubernetesResourceMapper;
                KClass<T> resourceClass = mapper.getResourceClass();
                KubernetesObject kubernetesObject = KubernetesCompareWithClusterActionKt.access$unmarshal(this.$virtualFile, resourceClass);
                if (kubernetesObject == null) {
                    throw new RuntimeException("resource of type '" + resourceClass + "' not found");
                }
                KubernetesObject resource = kubernetesObject;
                V1ObjectMeta v1ObjectMeta = resource.getMetadata();
                if (v1ObjectMeta == null) {
                    throw new RuntimeException("metadata not found");
                }
                V1ObjectMeta metadata = v1ObjectMeta;
                if (metadata.getNamespace() == null) {
                    metadata.setNamespace(this.$apiModel.getNamespaceForRequest());
                }
                return new ResourceContext<T, L>(resource, mapper, false, 4, null);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @RequiresReadLock
    private static final <T extends KubernetesObject> T unmarshal(VirtualFile $this$unmarshal, KClass<T> resourceClass) {
        KubernetesObject kubernetesObject;
        try {
            Iterable iterable;
            Representer representer = new Representer(new DumperOptions());
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml((BaseConstructor)new JavaTimeYamlConstructor<T>(resourceClass), representer);
            Closeable closeable = $this$unmarshal.getInputStream();
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                iterable = yaml.loadAll((InputStream)new BufferedInputStream(inputStream2));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Iterable resources2 = iterable;
            Intrinsics.checkNotNull((Object)resources2);
            kubernetesObject = (KubernetesObject)KClasses.safeCast(resourceClass, (Object)CollectionsKt.singleOrNull((Iterable)resources2));
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            kubernetesObject = null;
        }
        return (T)kubernetesObject;
    }

    @RequiresReadLock
    private static final createLightImmutableCopy.1 createLightImmutableCopy(VirtualFile virtualFile, String content2) {
        String string = virtualFile.getNameWithoutExtension() + "_" + KubernetesCompareWithClusterActionKt.currentTimestamp() + "." + virtualFile.getExtension();
        FileType fileType = virtualFile.getFileType();
        return new LightVirtualFile(virtualFile, content2, string, fileType){
            {
                this.setOriginalFile($virtualFile);
                this.setCharset($virtualFile.getCharset());
                this.setWritable(false);
            }
        };
    }

    private static final String currentTimestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss.SSS").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        String string = LocalDateTime.now().format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static final /* synthetic */ createLightImmutableCopy.1 access$createLightImmutableCopy(VirtualFile virtualFile, String content2) {
        return KubernetesCompareWithClusterActionKt.createLightImmutableCopy(virtualFile, content2);
    }

    public static final /* synthetic */ KubernetesResourceMapper access$findResourceMapper(YAMLFile yamlFile) {
        return KubernetesCompareWithClusterActionKt.findResourceMapper(yamlFile);
    }

    public static final /* synthetic */ Object access$calculateResourceContext(KubernetesApiModel apiModel2, YAMLFile yamlFile, VirtualFile virtualFile, Continuation $completion) {
        return KubernetesCompareWithClusterActionKt.calculateResourceContext(apiModel2, yamlFile, virtualFile, $completion);
    }

    public static final /* synthetic */ KubernetesObject access$unmarshal(VirtualFile $receiver, KClass resourceClass) {
        return KubernetesCompareWithClusterActionKt.unmarshal($receiver, resourceClass);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesResourceEditorAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

