/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.Period;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0018\u0010\u0015R\u001b\u0010\u001a\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u001d\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u000e\u001a\u0004\b+\u0010,R\u001b\u0010.\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u000e\u001a\u0004\b/\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010$\u00a8\u00063"}, d2={"Lcom/intellij/kubernetes/view/ui/MomentJSLikeDuration;", "", "start", "Ljava/time/OffsetDateTime;", "end", "(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)V", "originalDuration", "Ljava/time/Duration;", "(Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Ljava/time/Duration;)V", "absoluteEnd", "Ljava/time/LocalDate;", "getAbsoluteEnd", "()Ljava/time/LocalDate;", "absoluteEnd$delegate", "Lkotlin/Lazy;", "absoluteStart", "getAbsoluteStart", "absoluteStart$delegate", "days", "", "getDays", "()J", "duration", "fullHours", "getFullHours", "fullHours$delegate", "fullMinutes", "getFullMinutes", "fullMinutes$delegate", "hours", "getHours", "minutes", "getMinutes", "months", "", "getMonths", "()I", "negative", "", "getNegative", "()Z", "period", "Ljava/time/Period;", "getPeriod", "()Ljava/time/Period;", "period$delegate", "seconds", "getSeconds", "seconds$delegate", "years", "getYears", "intellij.clouds.kubernetes"})
final class MomentJSLikeDuration {
    @NotNull
    private final OffsetDateTime start;
    @NotNull
    private final OffsetDateTime end;
    private final boolean negative;
    @NotNull
    private final Duration duration;
    @NotNull
    private final Lazy seconds$delegate;
    @NotNull
    private final Lazy fullMinutes$delegate;
    @NotNull
    private final Lazy fullHours$delegate;
    @NotNull
    private final Lazy absoluteStart$delegate;
    @NotNull
    private final Lazy absoluteEnd$delegate;
    @NotNull
    private final Lazy period$delegate;

    private MomentJSLikeDuration(OffsetDateTime start, OffsetDateTime end, Duration originalDuration) {
        Duration duration;
        this.start = start;
        this.end = end;
        this.negative = originalDuration.isNegative();
        if (this.negative) {
            Duration duration2 = originalDuration.negated();
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"negated(...)");
        } else {
            duration = originalDuration;
        }
        this.duration = duration;
        this.seconds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return MomentJSLikeDuration.access$getDuration$p(this.this$0).toSeconds();
            }
        }));
        this.fullMinutes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return MomentJSLikeDuration.access$getDuration$p(this.this$0).toMinutes();
            }
        }));
        this.fullHours$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return MomentJSLikeDuration.access$getDuration$p(this.this$0).toHours();
            }
        }));
        this.absoluteStart$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocalDate>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LocalDate invoke() {
                return (this.this$0.getNegative() ? MomentJSLikeDuration.access$getEnd$p(this.this$0) : MomentJSLikeDuration.access$getStart$p(this.this$0)).toLocalDate();
            }
        }));
        this.absoluteEnd$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LocalDate>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LocalDate invoke() {
                return (this.this$0.getNegative() ? MomentJSLikeDuration.access$getStart$p(this.this$0) : MomentJSLikeDuration.access$getEnd$p(this.this$0)).toLocalDate();
            }
        }));
        this.period$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Period>(this){
            final /* synthetic */ MomentJSLikeDuration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Period invoke() {
                return Period.between(MomentJSLikeDuration.access$getAbsoluteStart(this.this$0), MomentJSLikeDuration.access$getAbsoluteEnd(this.this$0));
            }
        }));
    }

    public MomentJSLikeDuration(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Duration duration = Duration.between(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        this(start, end, duration);
    }

    public final boolean getNegative() {
        return this.negative;
    }

    public final long getSeconds() {
        Lazy lazy = this.seconds$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    private final long getFullMinutes() {
        Lazy lazy = this.fullMinutes$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getMinutes() {
        return this.getFullMinutes() + (long)(this.getSeconds() % (long)60 < 30L ? 0 : 1);
    }

    private final long getFullHours() {
        Lazy lazy = this.fullHours$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getHours() {
        return this.getFullHours() + (long)(this.getFullMinutes() % (long)60 < 30L ? 0 : 1);
    }

    public final long getDays() {
        return this.duration.toDays() + (long)(this.getFullHours() % (long)24 < 12L ? 0 : 1);
    }

    private final LocalDate getAbsoluteStart() {
        Lazy lazy = this.absoluteStart$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LocalDate)object;
    }

    private final LocalDate getAbsoluteEnd() {
        Lazy lazy = this.absoluteEnd$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LocalDate)object;
    }

    private final Period getPeriod() {
        Lazy lazy = this.period$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Period)object;
    }

    public final int getMonths() {
        Period nextFullMonthLackingPeriod;
        int fullAdditionalDays = this.getPeriod().getDays();
        int fullMonths = this.getPeriod().getMonths() + 12 * this.getPeriod().getYears();
        return fullMonths + (fullAdditionalDays < 14 ? 0 : ((nextFullMonthLackingPeriod = Period.between(this.getAbsoluteEnd(), this.getAbsoluteStart().plusMonths((long)fullMonths + 1L))).getDays() > fullAdditionalDays ? 0 : 1));
    }

    public final int getYears() {
        return this.getPeriod().getYears() + (this.getPeriod().getMonths() < 6 ? 0 : 1);
    }

    public static final /* synthetic */ Duration access$getDuration$p(MomentJSLikeDuration $this) {
        return $this.duration;
    }

    public static final /* synthetic */ OffsetDateTime access$getEnd$p(MomentJSLikeDuration $this) {
        return $this.end;
    }

    public static final /* synthetic */ OffsetDateTime access$getStart$p(MomentJSLikeDuration $this) {
        return $this.start;
    }

    public static final /* synthetic */ LocalDate access$getAbsoluteStart(MomentJSLikeDuration $this) {
        return $this.getAbsoluteStart();
    }

    public static final /* synthetic */ LocalDate access$getAbsoluteEnd(MomentJSLikeDuration $this) {
        return $this.getAbsoluteEnd();
    }
}

