/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.notification;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.util.KubernetesRuntimeUtilitiesKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0013\u0010\u000f\u001a\u00020\f2\u000b\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012J\u0006\u0010\u0013\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "getExceptionHandler", "()Lkotlinx/coroutines/CoroutineExceptionHandler;", "notified", "Ljava/util/concurrent/atomic/AtomicBoolean;", "reportRequestError", "", "throwable", "", "reportWarning", "message", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "reset", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 KubernetesRuntimeUtilities.kt\ncom/intellij/kubernetes/util/KubernetesRuntimeUtilitiesKt\n*L\n1#1,65:1\n44#2,4:66\n23#3:70\n23#3:72\n9#4:71\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n*L\n23#1:66,4\n38#1:70\n57#1:72\n43#1:71\n*E\n"})
public final class KubernetesNotificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean notified;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;

    public KubernetesNotificationManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.notified = new AtomicBoolean();
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key2 = CoroutineExceptionHandler.Key;
        this.exceptionHandler = new CoroutineExceptionHandler(key2, this){
            final /* synthetic */ KubernetesNotificationManager this$0;
            {
                this.this$0 = kubernetesNotificationManager;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                this.this$0.reset();
                this.this$0.reportRequestError(throwable);
            }
        };
    }

    @NotNull
    public final CoroutineExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void reportRequestError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KubernetesRuntimeUtilitiesKt.logOrWarnWithDebug(logger, throwable);
        if (!this.notified.compareAndSet(false, true)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message("KubernetesNotificationManager.requestError.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Throwable $this$messageOrClass$iv = throwable;
        boolean $i$f$getMessageOrClass = false;
        String string2 = $this$messageOrClass$iv.getMessage();
        if (string2 == null) {
            String string3 = $this$messageOrClass$iv.getClass().getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        }
        notificationGroup.createNotification(string, string2, NotificationType.ERROR).addAction(ActionManager.getInstance().getAction("Kubernetes.CustomizeNotifications")).notify(this.project);
    }

    public final void reset() {
        this.notified.set(false);
    }

    public final void reportWarning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unable to perform operation " + message2);
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message("KubernetesNotificationManager.message.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, message2, NotificationType.WARNING).notify(this.project);
    }

    @JvmStatic
    @NotNull
    public static final KubernetesNotificationManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    @Nullable
    public static final Object getInstanceAsync(@NotNull Project project2, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
        return Companion.getInstanceAsync(project2, $completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n31#2,2:66\n72#2:68\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n*L\n31#1:66,2\n34#1:68\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesNotificationManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KubernetesNotificationManager> serviceClass$iv = KubernetesNotificationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesNotificationManager)object;
        }

        @JvmStatic
        @Nullable
        public final Object getInstanceAsync(@NotNull Project project2, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project2;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(KubernetesNotificationManager.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

