/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesNamespacedResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesNamespacedResourceNavigationData;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ3\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016\u00a2\u0006\u0002\b\u0018H\u0004J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0004JW\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00132\u000b\u0010\u001d\u001a\u00070\n\u00a2\u0006\u0002\b\u001e2\u0019\u0010\u001f\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010 0\u0016\u00a2\u0006\u0002\b\u00182\u0019\u0010!\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010 0\u0016\u00a2\u0006\u0002\b\u0018H\u0004JJ\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00132\u0019\u0010#\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010 0\u0016\u00a2\u0006\u0002\b\u00182\u0019\u0010!\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010 0\u0016\u00a2\u0006\u0002\b\u0018H\u0004J/\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00132\u0019\u0010%\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0016\u00a2\u0006\u0002\b\u0018H\u0004J\u001a\u0010&\u001a\u00070\n\u00a2\u0006\u0002\b\u001e2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J+\u0010,\u001a\u00020)2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010*\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.H\u0016R\u001d\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\n*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "(Lcom/intellij/kubernetes/api/KubernetesEntity;)V", "actualNamespace", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/kubernetes/api/Context;", "getActualNamespace", "(Lcom/intellij/kubernetes/api/Context;)Ljava/lang/String;", "rootDirectoryName", "getRootDirectoryName", "(Lio/kubernetes/client/common/KubernetesObject;)Ljava/lang/String;", "addImagesField", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "", "getPodTemplate", "Lkotlin/Function1;", "Lio/kubernetes/client/openapi/models/V1PodTemplateSpec;", "Lkotlin/ExtensionFunctionType;", "addNamespaceField", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "addProgressField", "name", "Lorg/jetbrains/annotations/Nls;", "getCurrent", "", "getDesired", "addReadyField", "getReady", "addTypeField", "getType", "getResourceDisplayableName", "resource", "isAccepted", "", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "isAcceptedFor", "getApiModel", "Lkotlin/Function0;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;Lkotlin/jvm/functions/Function0;)Z", "mayBeInList", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNamespacedResourceMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNamespacedResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n*L\n1#1,83:1\n1#2:84\n171#3,5:85\n171#3,5:90\n*S KotlinDebug\n*F\n+ 1 KubernetesNamespacedResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNamespacedResourceMapper\n*L\n78#1:85,5\n81#1:90,5\n*E\n"})
public abstract class KubernetesNamespacedResourceMapper<T extends KubernetesObject, L extends KubernetesListObject>
extends KubernetesResourceMapper<T, L> {
    public KubernetesNamespacedResourceMapper(@NotNull KubernetesEntity<T, L> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        super(entity);
    }

    @Override
    @NotNull
    public String getRootDirectoryName(@NotNull T $this$rootDirectoryName) {
        Intrinsics.checkNotNullParameter($this$rootDirectoryName, (String)"<this>");
        String string = $this$rootDirectoryName.getMetadata().getNamespace();
        if (string == null) {
            string = "undefined";
        }
        return string;
    }

    @Override
    @NotNull
    public String getResourceDisplayableName(@NotNull T resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Object[] objectArray = new Object[]{super.getResourceDisplayableName(resource), resource.getMetadata().getNamespace()};
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.resourceDisplayableName.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return navigationData instanceof KubernetesNamespacedResourceNavigationData && super.isAccepted(navigationData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayBeInList(@NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<KubernetesApiModel> getApiModel) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        if (!(navigationData instanceof KubernetesNamespacedResourceNavigationData)) return false;
        String string = ((KubernetesNamespacedResourceNavigationData)navigationData).getNamespace();
        if (string == null) return true;
        String it = string;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)((KubernetesApiModel)getApiModel.invoke()).getNamespace(), (Object)it)) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAcceptedFor(@NotNull T resource, @NotNull KubernetesResourceNavigationData navigationData, @NotNull Function0<KubernetesApiModel> getApiModel) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        Intrinsics.checkNotNullParameter(getApiModel, (String)"getApiModel");
        if (!super.isAcceptedFor(resource, navigationData, getApiModel)) return false;
        if (!(navigationData instanceof KubernetesNamespacedResourceNavigationData)) return false;
        String string = resource.getMetadata().getNamespace();
        String string2 = ((KubernetesNamespacedResourceNavigationData)navigationData).getNamespace();
        if (string2 == null) {
            string2 = this.getActualNamespace(((KubernetesApiModel)getApiModel.invoke()).getCurrentContextObject$intellij_clouds_kubernetes());
        }
        if (!Intrinsics.areEqual((Object)string, (Object)string2)) return false;
        return true;
    }

    private final String getActualNamespace(Context $this$actualNamespace) {
        String string = $this$actualNamespace.getCurrentNamespace();
        if (string == null) {
            string = $this$actualNamespace.getOriginalNamespaceOrDefault();
        }
        return string;
    }

    @Nullable
    protected final KubernetesResourceMapper.ColumnDescriptor<T, ?> addNamespaceField(@NotNull KubernetesApiModel apiModel2) {
        KubernetesResourceMapper.ColumnDescriptor columnDescriptor;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        if (apiModel2.isAllNamespaces()) {
            String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.namespaceField.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            columnDescriptor = new KubernetesResourceMapper.ColumnDescriptor(string, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, null, null, null, null, addNamespaceField.1.INSTANCE, 120, null);
        } else {
            columnDescriptor = null;
        }
        return columnDescriptor;
    }

    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addReadyField(@NotNull Function1<? super T, Integer> getReady, @NotNull Function1<? super T, Integer> getDesired) {
        Intrinsics.checkNotNullParameter(getReady, (String)"getReady");
        Intrinsics.checkNotNullParameter(getDesired, (String)"getDesired");
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.readyField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addProgressField(string, getReady, getDesired);
    }

    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, Iterable<?>> addImagesField(@NotNull Function1<? super T, ? extends V1PodTemplateSpec> getPodTemplate) {
        Intrinsics.checkNotNullParameter(getPodTemplate, (String)"getPodTemplate");
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.imagesField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.addMultilineField(string, (Function1)new Function1<T, Iterable<? extends String>>(getPodTemplate){
            final /* synthetic */ Function1<T, V1PodTemplateSpec> $getPodTemplate;
            {
                this.$getPodTemplate = $getPodTemplate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Iterable<String> invoke(@NotNull T $this$addMultilineField) {
                List list2;
                Intrinsics.checkNotNullParameter($this$addMultilineField, (String)"$this$addMultilineField");
                Object object = (V1PodTemplateSpec)this.$getPodTemplate.invoke($this$addMultilineField);
                if (object != null && (object = ((V1PodTemplateSpec)object).getSpec()) != null && (object = ((V1PodSpec)object).getContainers()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        V1Container p0 = (V1Container)element$iv$iv;
                        boolean bl2 = false;
                        if (p0.getImage() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                } else {
                    list2 = null;
                }
                return list2;
            }
        });
    }

    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addProgressField(@NotNull String name2, @NotNull Function1<? super T, Integer> getCurrent, @NotNull Function1<? super T, Integer> getDesired) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(getCurrent, (String)"getCurrent");
        Intrinsics.checkNotNullParameter(getDesired, (String)"getDesired");
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        Function1 getValue$iv = new Function1<T, String>(getCurrent, getDesired){
            final /* synthetic */ Function1<T, Integer> $getCurrent;
            final /* synthetic */ Function1<T, Integer> $getDesired;
            {
                this.$getCurrent = $getCurrent;
                this.$getDesired = $getDesired;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                Integer n = (Integer)this.$getCurrent.invoke($this$simple);
                Integer n2 = (Integer)this.$getDesired.invoke($this$simple);
                return (n != null ? n : 0) + " / " + (n2 != null ? n2 : 0);
            }
        };
        boolean $i$f$simple = false;
        return new KubernetesResourceMapper.ColumnDescriptor(name2, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final KubernetesResourceMapper.ColumnDescriptor<T, String> addTypeField(@NotNull Function1<? super T, String> getType) {
        void name$iv;
        Intrinsics.checkNotNullParameter(getType, (String)"getType");
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesNamespacedResourceMapper.typeField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = new Function1<T, String>(getType){
            final /* synthetic */ Function1<T, String> $getType;
            {
                this.$getType = $getType;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull T $this$simple) {
                Intrinsics.checkNotNullParameter($this$simple, (String)"$this$simple");
                return (String)this.$getType.invoke($this$simple);
            }
        };
        boolean $i$f$simple = false;
        return new KubernetesResourceMapper.ColumnDescriptor((String)name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
    }
}

