/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.KubernetesNavigatable;
import com.intellij.kubernetes.view.KubernetesServiceViewContributorKt;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.kubernetes.view.ui.actions.KubernetesNodeActionsKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import io.kubernetes.client.common.KubernetesObject;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0001*\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007BF\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00028\u0000\u0012\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u0010\u0014J\r\u0010\"\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0019J\b\u0010#\u001a\u00020$H$J\b\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u0010*\u001a\u00020\tH&J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0014J\b\u00103\u001a\u00020(H\u0016J\u0016\u00104\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0096@\u00a2\u0006\u0002\u00105R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00028\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u0011\u001a\u00028\u0000X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 \u00a8\u00066"}, d2={"Lcom/intellij/kubernetes/view/KubernetesServiceViewDescriptor;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "C", "", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lcom/intellij/kubernetes/view/KubernetesNavigatable;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "icon", "Ljavax/swing/Icon;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lkotlinx/coroutines/CoroutineScope;Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)V", "getApiModel$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "content", "getContent$intellij_clouds_kubernetes", "()Ljava/lang/Object;", "content$delegate", "Lkotlin/Lazy;", "coroutineScope", "getMapper$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "getResource$intellij_clouds_kubernetes", "()Lio/kubernetes/client/common/KubernetesObject;", "Lio/kubernetes/client/common/KubernetesObject;", "createContent", "createCustomActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "dispose", "", "equals", "", "other", "getId", "getPopupActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getToolbarActions", "hashCode", "", "isAccepted", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "isDisposed", "navigate", "(Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesServiceViewDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesServiceViewDescriptor\n+ 2 KubernetesRuntimeUtilities.kt\ncom/intellij/kubernetes/util/KubernetesRuntimeUtilitiesKt\n*L\n1#1,78:1\n23#2:79\n40#2,5:80\n*S KotlinDebug\n*F\n+ 1 KubernetesServiceViewDescriptor.kt\ncom/intellij/kubernetes/view/KubernetesServiceViewDescriptor\n*L\n63#1:79\n71#1:80,5\n*E\n"})
public abstract class KubernetesServiceViewDescriptor<T extends KubernetesObject, C>
extends SimpleServiceViewDescriptor
implements CheckedDisposable,
KubernetesNavigatable {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final T resource;
    @NotNull
    private final KubernetesResourceMapper<T, ?> mapper;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Lazy content$delegate;

    public KubernetesServiceViewDescriptor(@NotNull String name2, @Nullable Icon icon, @NotNull KubernetesApiModel apiModel2, @NotNull CoroutineScope parentCoroutineScope, @NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super(name2, icon);
        this.apiModel = apiModel2;
        this.resource = resource;
        this.mapper = mapper;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)parentCoroutineScope, (String)("k8s." + name2), null, (boolean)false, (int)6, null);
        this.content$delegate = LazyKt.lazy((Function0)new Function0<C>(this){
            final /* synthetic */ KubernetesServiceViewDescriptor<T, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final C invoke() {
                return this.this$0.createContent();
            }
        });
    }

    @NotNull
    public final KubernetesApiModel getApiModel$intellij_clouds_kubernetes() {
        return this.apiModel;
    }

    @NotNull
    public final T getResource$intellij_clouds_kubernetes() {
        return this.resource;
    }

    @NotNull
    public final KubernetesResourceMapper<T, ?> getMapper$intellij_clouds_kubernetes() {
        return this.mapper;
    }

    @NotNull
    public final C getContent$intellij_clouds_kubernetes() {
        Lazy lazy = this.content$delegate;
        return (C)lazy.getValue();
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    public boolean isDisposed() {
        return !kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope);
    }

    @NotNull
    protected abstract C createContent();

    @NotNull
    protected abstract DefaultActionGroup createCustomActions();

    @NotNull
    public abstract String getId();

    @NotNull
    public ActionGroup getToolbarActions() {
        AnAction[] anActionArray = new AnAction[]{this.createCustomActions(), Separator.create(), KubernetesNodeActionsKt.createNodeCommonActionsForToolbar()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    @NotNull
    public ActionGroup getPopupActions() {
        AnAction[] anActionArray = new AnAction[]{this.createCustomActions(), Separator.create(), KubernetesNodeActionsKt.createNodeCommonActionsForPopup()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        void it;
        KubernetesServiceViewDescriptor $this$equals$iv = this;
        boolean $i$f$equals = false;
        if ($this$equals$iv == other) return true;
        Object object = other;
        if ($this$equals$iv.getClass() != (object != null ? object.getClass() : null)) return false;
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.kubernetes.view.KubernetesServiceViewDescriptor<T, C>");
        }
        KubernetesServiceViewDescriptor kubernetesServiceViewDescriptor = (KubernetesServiceViewDescriptor)object2;
        KubernetesServiceViewDescriptor $this$equals_u24lambda_u240 = $this$equals$iv;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.getId(), (Object)it.getId())) return false;
        if (!Intrinsics.areEqual((Object)$this$equals_u24lambda_u240.apiModel, (Object)it.apiModel)) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.apiModel};
        return Objects.hash(objectArray);
    }

    @Override
    @Nullable
    public Object navigate(@NotNull KubernetesResourceNavigationData navigationData, @NotNull Continuation<? super Boolean> $completion) {
        return KubernetesServiceViewDescriptor.navigate$suspendImpl(this, navigationData, $completion);
    }

    static /* synthetic */ <T extends KubernetesObject, C> Object navigate$suspendImpl(KubernetesServiceViewDescriptor<T, ? extends C> $this, KubernetesResourceNavigationData navigationData, Continuation<? super Boolean> $completion) {
        boolean bl;
        boolean $this$thenDo$iv = $this.isAccepted(navigationData);
        boolean $i$f$thenDo = false;
        boolean it$iv = bl = $this$thenDo$iv;
        boolean bl2 = false;
        if (it$iv) {
            boolean bl3 = false;
            KubernetesServiceViewContributorKt.selectKubernetesService($this.apiModel.getProject(), $this);
        }
        return Boxing.boxBoolean((boolean)bl);
    }

    protected boolean isAccepted(@NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        return this.mapper.isAcceptedFor(this.resource, navigationData, (Function0<KubernetesApiModel>)((Function0)new Function0<KubernetesApiModel>(this){
            final /* synthetic */ KubernetesServiceViewDescriptor<T, C> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KubernetesApiModel invoke() {
                return this.this$0.getApiModel$intellij_clouds_kubernetes();
            }
        }));
    }
}

