/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view;

import com.intellij.kubernetes.view.KubernetesCachedValueBasedServiceViewContributorBase;
import com.intellij.openapi.diagnostic.Logger;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\b\b\u0000\u0010\u0004*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kubernetesNameIdComparator", "Ljava/util/Comparator;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesCachedValueBasedServiceViewContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesCachedValueBasedServiceViewContributorBase.kt\ncom/intellij/kubernetes/view/KubernetesCachedValueBasedServiceViewContributorBaseKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,336:1\n13#2:337\n*S KotlinDebug\n*F\n+ 1 KubernetesCachedValueBasedServiceViewContributorBase.kt\ncom/intellij/kubernetes/view/KubernetesCachedValueBasedServiceViewContributorBaseKt\n*L\n41#1:337\n*E\n"})
public final class KubernetesCachedValueBasedServiceViewContributorBaseKt {
    @NotNull
    private static final Logger LOG;

    private static final <T extends KubernetesObject> Comparator<T> kubernetesNameIdComparator() {
        return new Comparator<T>(){

            public int compare(@NotNull T item1, @NotNull T item2) {
                String kind2;
                Intrinsics.checkNotNullParameter(item1, (String)"item1");
                Intrinsics.checkNotNullParameter(item2, (String)"item2");
                List<V1OwnerReference> list2 = item1.getMetadata().getOwnerReferences();
                String kind1 = list2 != null && (list2 = (V1OwnerReference)CollectionsKt.firstOrNull(list2)) != null ? ((V1OwnerReference)((Object)list2)).getKind() : null;
                List<V1OwnerReference> list3 = item2.getMetadata().getOwnerReferences();
                String string = list3 != null && (list3 = (V1OwnerReference)CollectionsKt.firstOrNull(list3)) != null ? ((V1OwnerReference)((Object)list3)).getKind() : (kind2 = null);
                if (Intrinsics.areEqual((Object)kind1, (Object)"StatefulSet") && Intrinsics.areEqual((Object)kind2, (Object)"StatefulSet")) {
                    int index2;
                    String string2 = item1.getMetadata().getName();
                    String baseName1 = string2 != null ? StringsKt.substringBeforeLast$default((String)string2, (char)'-', null, (int)2, null) : null;
                    Object object = item1.getMetadata().getName();
                    int index1 = object != null && (object = StringsKt.substringAfterLast$default((String)object, (char)'-', null, (int)2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                    String string3 = item2.getMetadata().getName();
                    String baseName2 = string3 != null ? StringsKt.substringBeforeLast$default((String)string3, (char)'-', null, (int)2, null) : null;
                    Object object2 = item2.getMetadata().getName();
                    int n = object2 != null && (object2 = StringsKt.substringAfterLast$default((String)object2, (char)'-', null, (int)2, null)) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : (index2 = 0);
                    if (baseName1 != null && baseName2 != null) {
                        int baseNameComparison = baseName1.compareTo(baseName2);
                        if (baseNameComparison != 0) {
                            return baseNameComparison;
                        }
                        return Intrinsics.compare((int)index1, (int)index2);
                    }
                }
                return String.valueOf(item1.getMetadata().getName()).compareTo(String.valueOf(item2.getMetadata().getName()));
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Comparator access$kubernetesNameIdComparator() {
        return KubernetesCachedValueBasedServiceViewContributorBaseKt.kubernetesNameIdComparator();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesCachedValueBasedServiceViewContributorBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

