/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.ui.actions.HelmViewTemplateRenderAction;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.QuickHelmActionBase;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001bH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction;", "Lcom/intellij/kubernetes/ui/actions/QuickHelmActionBase;", "()V", "helmCommand", "", "", "getHelmCommand", "()Ljava/util/List;", "convertToLogicalPaths", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isApplicable", "", "parseRenderedTemplate", "fileRelativePath", "helmOutput", "processOutput", "", "request", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmViewTemplateRenderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmViewTemplateRenderAction.kt\ncom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n31#2,2:142\n1#3:144\n23#4:145\n23#4:146\n*S KotlinDebug\n*F\n+ 1 HelmViewTemplateRenderAction.kt\ncom/intellij/kubernetes/ui/actions/HelmViewTemplateRenderAction\n*L\n34#1:142,2\n41#1:145\n59#1:146\n*E\n"})
public final class HelmViewTemplateRenderAction
extends QuickHelmActionBase {
    @NotNull
    private final List<String> helmCommand;

    public HelmViewTemplateRenderAction() {
        String string = KubernetesBundle.message("HelmViewTemplateRenderAction.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, true);
        Object[] objectArray = new String[]{"template", "--debug"};
        this.helmCommand = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getHelmCommand() {
        return this.helmCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getChart(context) == null) return false;
        String string = context.getCurrentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!Chart.Companion.isRenderableTemplateFile(string)) return false;
        return true;
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context) {
        Chart chart2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart3 = ((ChartManager)object).findChartByTemplateFile(context.getCurrentFile());
        if (chart3 != null && (chart3 = chart3.getTopmostChart()) != null) {
            Chart chart4;
            Chart it = chart4 = chart3;
            boolean bl = false;
            chart2 = it.getChartFile() != null ? chart4 : null;
        } else {
            chart2 = null;
        }
        return chart2;
    }

    @Override
    protected void processOutput(@NotNull KubernetesActionBase.ActionContext context, @NotNull HelmExecutionManager.ExecutionRequest request, @NotNull ProcessOutput processOutput2) {
        LightVirtualFile lightVirtualFile;
        String renderResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)processOutput2, (String)"processOutput");
        List fileRelPaths = CollectionsKt.toMutableList(this.convertToLogicalPaths(context.getProject(), context.getCurrentFile()));
        if (fileRelPaths.isEmpty()) {
            HelmViewTemplateRenderAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(HelmViewTemplateRenderAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File " + context.getCurrentFile() + " doesn't relate to any chart");
            return;
        }
        String string = processOutput2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String helmOutput = string;
        Map renderResults = new LinkedHashMap();
        for (String fileRelPath : fileRelPaths) {
            renderResult = this.parseRenderedTemplate(fileRelPath, helmOutput);
            if (renderResult == null) continue;
            renderResults.put(fileRelPath, renderResult);
        }
        fileRelPaths.retainAll(renderResults.keySet());
        if (fileRelPaths.isEmpty()) {
            if (processOutput2.getExitCode() == 0) {
                HelmViewTemplateRenderAction $this$thisLogger$iv = this;
                boolean $i$f$thisLogger22 = false;
                Logger logger = Logger.getInstance(HelmViewTemplateRenderAction.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Couldn't parse rendered template for " + fileRelPaths + " from Helm's output");
                $this$thisLogger$iv = NotificationsKt.getKubernetesNotificationGroup();
                NotificationType $i$f$thisLogger22 = NotificationType.WARNING;
                renderResult = KubernetesBundle.message("HelmViewTemplateRenderAction.notification.title", new Object[0]);
                Object[] objectArray = new Object[]{context.getCurrentFile().getPath()};
                String string2 = KubernetesBundle.message("HelmViewTemplateRenderAction.no.result.message", objectArray);
                Intrinsics.checkNotNull((Object)renderResult);
                Intrinsics.checkNotNull((Object)string2);
                $this$thisLogger$iv.createNotification(renderResult, string2, $i$f$thisLogger22).setSubtitle(KubernetesBundle.message("HelmViewTemplateRenderAction.notification.subtitle", new Object[0])).notify(context.getProject());
            }
            return;
        }
        CollectionsKt.sort((List)fileRelPaths);
        Ref.ObjectRef chosenPath = new Ref.ObjectRef();
        Object object = chosenPath.element = fileRelPaths.size() == 1 ? (String)CollectionsKt.first((List)fileRelPaths) : null;
        if (chosenPath.element == null) {
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(context, (List<String>)fileRelPaths, (Ref.ObjectRef<String>)chosenPath){
                final /* synthetic */ KubernetesActionBase.ActionContext $context;
                final /* synthetic */ List<String> $fileRelPaths;
                final /* synthetic */ Ref.ObjectRef<String> $chosenPath;
                {
                    this.$context = $context;
                    this.$fileRelPaths = $fileRelPaths;
                    this.$chosenPath = $chosenPath;
                    super(0);
                }

                public final void invoke() {
                    Collection $this$toTypedArray$iv = this.$fileRelPaths;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    int chosen = MessagesService.Companion.getInstance().showChooseDialog(this.$context.getProject(), null, KubernetesBundle.message("HelmViewTemplateRenderAction.select.context.dialog.text", new Object[0]), KubernetesBundle.message("HelmViewTemplateRenderAction.task.title", new Object[0]), thisCollection$iv.toArray(new String[0]), (String)CollectionsKt.first(this.$fileRelPaths), KubernetesIcons.Helm);
                    if (chosen >= 0) {
                        this.$chosenPath.element = this.$fileRelPaths.get(chosen);
                    }
                }
            }), (int)1, null);
        }
        if (chosenPath.element == null) {
            return;
        }
        Object v = renderResults.get(chosenPath.element);
        Intrinsics.checkNotNull(v);
        String renderResult2 = (String)v;
        DiffManagerEx diffManagerEx = DiffManagerEx.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffManagerEx, (String)"getInstance(...)");
        DiffManagerEx diffManager = diffManagerEx;
        DiffContentFactoryEx diffContentFactoryEx = DiffContentFactoryEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactoryEx, (String)"getInstanceEx(...)");
        DiffContentFactoryEx contentFactory = diffContentFactoryEx;
        FileContent fileContent = contentFactory.createFile(context.getProject(), context.getCurrentFile());
        Intrinsics.checkNotNull((Object)fileContent);
        FileContent leftContent = fileContent;
        LightVirtualFile it = lightVirtualFile = new LightVirtualFile(context.getCurrentFile().getName(), (FileType)YAMLFileType.YML, (CharSequence)renderResult2);
        boolean bl = false;
        it.setWritable(false);
        LightVirtualFile resultFile = lightVirtualFile;
        FileContent fileContent2 = contentFactory.createFile(context.getProject(), (VirtualFile)resultFile);
        Intrinsics.checkNotNull((Object)fileContent2);
        FileContent rightContent = fileContent2;
        ContentDiffRequest diffRequest2 = new ContentDiffRequest(context, leftContent, rightContent){
            final /* synthetic */ KubernetesActionBase.ActionContext $context;
            final /* synthetic */ FileContent $leftContent;
            final /* synthetic */ FileContent $rightContent;
            {
                this.$context = $context;
                this.$leftContent = $leftContent;
                this.$rightContent = $rightContent;
            }

            @NotNull
            public String getTitle() {
                Object[] objectArray = new Object[]{this.$context.getCurrentFile().getPath()};
                String string = KubernetesBundle.message("HelmViewTemplateRenderAction.diff.window.title", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @NotNull
            public List<DiffContent> getContents() {
                Object[] objectArray = new DiffContent[]{this.$leftContent, this.$rightContent};
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }

            @NotNull
            public List<String> getContentTitles() {
                Object[] objectArray = new String[2];
                Intrinsics.checkNotNullExpressionValue((Object)KubernetesBundle.message("HelmViewTemplateRenderAction.diff.window.left.title", new Object[0]), (String)"message(...)");
                Intrinsics.checkNotNullExpressionValue((Object)KubernetesBundle.message("HelmViewTemplateRenderAction.diff.window.right.title", new Object[0]), (String)"message(...)");
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }
        };
        ApplicationManager.getApplication().invokeLater(() -> HelmViewTemplateRenderAction.processOutput$lambda$2(diffManager, context, diffRequest2));
    }

    private final Collection<String> convertToLogicalPaths(Project project2, VirtualFile file2) {
        Collection collection = (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<? extends String>>(project2, file2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            {
                this.$project = $project;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final Collection<String> invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<ChartManager> serviceClass$iv = ChartManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Pair<Chart, Collection<String>> pair = ((ChartManager)object).getLogicalPathsOfTemplateFile(this.$file);
                return pair != null ? (Collection<E>)pair.getSecond() : null;
            }
        }));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private final String parseRenderedTemplate(String fileRelativePath, String helmOutput) {
        String string;
        String header = "# Source: " + fileRelativePath + "\n";
        int indexOfHeader = StringsKt.indexOf$default((CharSequence)helmOutput, (String)header, (int)0, (boolean)false, (int)6, null);
        if (indexOfHeader < 0) {
            return null;
        }
        int startIndex = indexOfHeader + header.length();
        int endIndex = StringsKt.indexOf$default((CharSequence)helmOutput, (String)"---\n# Source: ", (int)startIndex, (boolean)false, (int)4, null);
        if (endIndex >= startIndex) {
            String string2 = helmOutput.substring(startIndex, endIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String string3 = helmOutput.substring(startIndex);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        return string;
    }

    private static final void processOutput$lambda$2(DiffManagerEx $diffManager, KubernetesActionBase.ActionContext $context, processOutput.diffRequest.1 $diffRequest) {
        Intrinsics.checkNotNullParameter((Object)$diffManager, (String)"$diffManager");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)((Object)$diffRequest), (String)"$diffRequest");
        $diffManager.showDiff($context.getProject(), (DiffRequest)$diffRequest);
    }
}

