/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.kubernetes.ui.actions.QuickHelmActionBase;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0015H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCreateChartAction;", "Lcom/intellij/kubernetes/ui/actions/QuickHelmActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "helmCommand", "", "", "getHelmCommand", "()Ljava/util/List;", "createExecutionRequest", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "getChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "isApplicable", "", "isRepeatableAction", "processOutput", "", "request", "Lcom/intellij/execution/process/ProcessOutput;", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmCreateChartAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCreateChartAction.kt\ncom/intellij/kubernetes/ui/actions/HelmCreateChartAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n1#2:116\n31#3,2:117\n*S KotlinDebug\n*F\n+ 1 HelmCreateChartAction.kt\ncom/intellij/kubernetes/ui/actions/HelmCreateChartAction\n*L\n58#1:117,2\n*E\n"})
public final class HelmCreateChartAction
extends QuickHelmActionBase
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    public HelmCreateChartAction() {
        String string = KubernetesBundle.message("HelmCreateChartAction.task.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, false);
    }

    @Override
    protected boolean isApplicable(@NotNull KubernetesActionBase.ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getCurrentFile().isDirectory() && !(context.getCurrentFile().getFileSystem() instanceof ArchiveFileSystem);
    }

    @Override
    protected boolean isRepeatableAction() {
        return false;
    }

    @Override
    protected void processOutput(@NotNull KubernetesActionBase.ActionContext context, @NotNull HelmExecutionManager.ExecutionRequest request, @NotNull ProcessOutput processOutput2) {
        VirtualFile newChartDir;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)processOutput2, (String)"processOutput");
        if (processOutput2.getExitCode() != 0) {
            return;
        }
        request.getWorkingDir().refresh(false, false);
        if (request.getChartDirName() == null) {
            return;
        }
        VirtualFile virtualFile = request.getWorkingDir().findChild(request.getChartDirName());
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            v1 = it.isDirectory() ? virtualFile2 : null;
        } else {
            v1 = newChartDir = null;
        }
        if (newChartDir != null) {
            ReadAction.run(() -> HelmCreateChartAction.processOutput$lambda$1(context, newChartDir));
        }
    }

    @Override
    @NotNull
    public List<String> getHelmCommand() {
        return CollectionsKt.listOf((Object)"create");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected HelmExecutionManager.ExecutionRequest createExecutionRequest(@NotNull KubernetesActionBase.ActionContext context) {
        void it;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Ref.ObjectRef currentDir = new Ref.ObjectRef();
        VirtualFile virtualFile2 = virtualFile = context.getCurrentFile();
        Ref.ObjectRef objectRef = currentDir;
        boolean bl = false;
        boolean bl2 = it.isDirectory();
        Object object = bl2 ? virtualFile : null;
        if (object == null) {
            return null;
        }
        objectRef.element = object;
        ComponentManager $this$service$iv = (ComponentManager)context.getProject();
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart currentChart = ((ChartManager)object2).findChartByBaseDir((VirtualFile)currentDir.element);
        String string = Messages.showInputDialog((Project)context.getProject(), (String)KubernetesBundle.message("HelmCreateChartAction.input.dialog.label.text", new Object[0]), (String)KubernetesBundle.message("HelmCreateChartAction.task.title", new Object[0]), null, null, (InputValidator)new InputValidator(currentChart, (Ref.ObjectRef<VirtualFile>)currentDir){
            final /* synthetic */ Chart $currentChart;
            final /* synthetic */ Ref.ObjectRef<VirtualFile> $currentDir;
            {
                this.$currentChart = $currentChart;
                this.$currentDir = $currentDir;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean checkInput(@Nullable String inputString) {
                void $this$mapTo$iv$iv;
                if (inputString == null) return false;
                if (!Chart.Companion.isChartNameValid(inputString)) return false;
                if (this.$currentChart == null) {
                    if (((VirtualFile)this.$currentDir.element).findChild(inputString) == null) return true;
                }
                if (this.$currentChart == null) return false;
                Iterable $this$map$iv = this.$currentChart.getSubCharts();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chart chart2 = (Chart)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getBaseDir().getName());
                }
                if (((List)destination$iv$iv).contains(inputString)) return false;
                return true;
            }

            public boolean canClose(@Nullable String inputString) {
                return true;
            }
        });
        if (string == null) {
            return null;
        }
        String newChartName2 = string;
        try {
            if (currentChart != null) {
                WriteAction.run(() -> HelmCreateChartAction.createExecutionRequest$lambda$3(currentDir, currentChart));
            }
        }
        catch (IOException e) {
            VirtualFile externallyCreated;
            VirtualFile virtualFile3;
            VirtualFile virtualFile4 = ((VirtualFile)currentDir.element).findChild("charts");
            if (virtualFile4 != null) {
                VirtualFile it2 = virtualFile3 = virtualFile4;
                boolean bl3 = false;
                v4 = it2.isDirectory() ? virtualFile3 : null;
            } else {
                v4 = externallyCreated = null;
            }
            if (externallyCreated == null) {
                log.warn("Couldn't create charts directory", (Throwable)e);
                NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
                virtualFile3 = NotificationType.ERROR;
                String string2 = KubernetesBundle.message("HelmCreateChartAction.notification.title", new Object[0]);
                Object[] objectArray = new Object[]{((VirtualFile)currentDir.element).getPath()};
                String string3 = KubernetesBundle.message("HelmCreateChartAction.mkdir.failure.message", objectArray);
                Intrinsics.checkNotNull((Object)string2);
                Intrinsics.checkNotNull((Object)string3);
                notificationGroup.createNotification(string2, string3, (NotificationType)virtualFile3).setSubtitle(KubernetesBundle.message("HelmCreateChartAction.notification.subtitle", new Object[0])).notify(context.getProject());
                return null;
            }
            currentDir.element = externallyCreated;
        }
        return new HelmExecutionManager.ExecutionRequest(this.getTaskTitle(), this.getHelmCommand(), EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS(), (VirtualFile)currentDir.element, newChartName2, null, null, 96, null);
    }

    @Override
    @Nullable
    protected Chart getChart(@NotNull KubernetesActionBase.ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    private static final void processOutput$lambda$1(KubernetesActionBase.ActionContext $context, VirtualFile $newChartDir) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        PsiDirectory psiDir = PsiManager.getInstance((Project)$context.getProject()).findDirectory($newChartDir);
        ProjectView.getInstance((Project)$context.getProject()).select((Object)psiDir, $newChartDir, true);
    }

    private static final void createExecutionRequest$lambda$3(Ref.ObjectRef $currentDir, Chart $currentChart) {
        Intrinsics.checkNotNullParameter((Object)$currentDir, (String)"$currentDir");
        VirtualFile virtualFile = $currentChart.getChartsDir();
        if (virtualFile == null) {
            VirtualFile virtualFile2 = ((VirtualFile)$currentDir.element).createChildDirectory(null, "charts");
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildDirectory(...)");
        }
        $currentDir.element = virtualFile;
    }

    static {
        Logger logger = Logger.getInstance(HelmCreateChartAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCreateChartAction$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

