/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.actions;

import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.helm.HelmExecutionManager;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.ui.HelmCommandParametersDialog;
import com.intellij.kubernetes.ui.actions.HelmChartActionBase;
import com.intellij.kubernetes.ui.actions.KubernetesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/ui/actions/HelmCliActionBase;", "Lcom/intellij/kubernetes/ui/actions/HelmChartActionBase;", "taskTitle", "", "dependsOnManualConfiguration", "", "(Ljava/lang/String;Z)V", "helmCommand", "", "getHelmCommand", "()Ljava/util/List;", "getTaskTitle", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createExecutionRequest", "Lcom/intellij/kubernetes/helm/HelmExecutionManager$ExecutionRequest;", "context", "Lcom/intellij/kubernetes/ui/actions/KubernetesActionBase$ActionContext;", "isEnabled", "performInBackground", "executionManager", "Lcom/intellij/kubernetes/helm/HelmExecutionManager;", "request", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmCliActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCliActionBase.kt\ncom/intellij/kubernetes/ui/actions/HelmCliActionBase\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,54:1\n129#2:55\n*S KotlinDebug\n*F\n+ 1 HelmCliActionBase.kt\ncom/intellij/kubernetes/ui/actions/HelmCliActionBase\n*L\n37#1:55\n*E\n"})
public abstract class HelmCliActionBase
extends HelmChartActionBase {
    @NotNull
    private final String taskTitle;
    private final boolean dependsOnManualConfiguration;

    public HelmCliActionBase(@Nls @NotNull String taskTitle, boolean dependsOnManualConfiguration) {
        Intrinsics.checkNotNullParameter((Object)taskTitle, (String)"taskTitle");
        this.taskTitle = taskTitle;
        this.dependsOnManualConfiguration = dependsOnManualConfiguration;
    }

    @NotNull
    public final String getTaskTitle() {
        return this.taskTitle;
    }

    @NotNull
    public abstract List<String> getHelmCommand();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesActionBase.ActionContext actionContext = this.getContext(e);
        if (actionContext == null) {
            return;
        }
        KubernetesActionBase.ActionContext context = actionContext;
        HelmExecutionManager.ExecutionRequest executionRequest = this.createExecutionRequest(context);
        if (executionRequest == null) {
            return;
        }
        HelmExecutionManager.ExecutionRequest request = executionRequest;
        FileDocumentManager.getInstance().saveAllDocuments();
        Object object = context.getProject().getService(HelmExecutionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.performInBackground(context, (HelmExecutionManager)object, request);
    }

    @Override
    protected boolean isEnabled(@NotNull KubernetesActionBase.ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return !((HelmExecutionManager)context.getProject().getService(HelmExecutionManager.class)).isBusy();
    }

    @Nullable
    protected HelmExecutionManager.ExecutionRequest createExecutionRequest(@NotNull KubernetesActionBase.ActionContext context) {
        HelmExecutionManager.ExecutionRequest executionRequest;
        EffectiveHelmParameters effectiveHelmParameters;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Chart chart2 = this.getChart(context);
        if (chart2 == null) {
            return null;
        }
        Chart chart3 = chart2;
        if (this.dependsOnManualConfiguration) {
            HelmParameters helmParameters = KubernetesProjectSettings.Companion.getInstance(context.getProject()).getHelmParameters(chart3);
            if (!(helmParameters != null ? !helmParameters.getShowConfigDialog() : false)) {
                EffectiveHelmParameters effectiveHelmParameters2;
                HelmCommandParametersDialog it = new HelmCommandParametersDialog(context.getProject(), chart3, this.taskTitle);
                boolean bl = false;
                boolean condition$iv = it.showAndGet();
                boolean $i$f$doIf = false;
                if (condition$iv) {
                    boolean bl2 = false;
                    effectiveHelmParameters2 = it.getHelmParameters();
                } else {
                    effectiveHelmParameters2 = effectiveHelmParameters = null;
                }
                if (effectiveHelmParameters2 == null) {
                    return null;
                }
            } else {
                effectiveHelmParameters = chart3.getEffectiveHelmParameters();
            }
        } else {
            effectiveHelmParameters = EffectiveHelmParameters.Companion.getEMPTY_PARAMETERS();
        }
        EffectiveHelmParameters helmParameters = effectiveHelmParameters;
        VirtualFile virtualFile = chart3.getBaseDir().getParent();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            executionRequest = new HelmExecutionManager.ExecutionRequest(this.taskTitle, this.getHelmCommand(), helmParameters, it, chart3.getBaseDir().getName(), null, null, 96, null);
        } else {
            executionRequest = null;
        }
        return executionRequest;
    }

    protected abstract void performInBackground(@NotNull KubernetesActionBase.ActionContext var1, @NotNull HelmExecutionManager var2, @NotNull HelmExecutionManager.ExecutionRequest var3);
}

