/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"TelepresenceNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getTelepresenceNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "suggestInstallTrafficManager", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "upgrade", "", "telepresenceFilePathFinder", "Lcom/intellij/execution/filters/PatternBasedFileHyperlinkRawDataFinder;", "intellij.clouds.kubernetes"})
public final class TelepresenceConsoleFilterProviderKt {
    @NotNull
    public static final PatternBasedFileHyperlinkRawDataFinder telepresenceFilePathFinder() {
        PatternHyperlinkFormat[] patternHyperlinkFormatArray = new PatternHyperlinkFormat[1];
        PatternHyperlinkPart[] patternHyperlinkPartArray = new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH};
        patternHyperlinkFormatArray[0] = new PatternHyperlinkFormat(Pattern.compile("^.*\"(" + StringUtil.escapeToRegexp((String)SystemProperties.getUserHome()) + ".+?)\".*$"), false, false, patternHyperlinkPartArray);
        return new PatternBasedFileHyperlinkRawDataFinder(patternHyperlinkFormatArray);
    }

    public static final void suggestInstallTrafficManager(@NotNull KubernetesApiModel apiModel2, boolean upgrade) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        String string = KubernetesBundle.message(upgrade ? "Telepresence.upgrade.traffic.manager.title" : "Telepresence.install.traffic.manager.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Object[] objectArray = new Object[]{apiModel2.getCurrentContext(), apiModel2.getNamespace()};
        String string2 = KubernetesBundle.message(upgrade ? "Telepresence.upgrade.traffic.manager.prompt" : "Telepresence.install.traffic.manager.prompt", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String content2 = string2;
        TelepresenceConsoleFilterProviderKt.getTelepresenceNotificationGroup().createNotification(title, content2, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimpleExpiring((String)title, () -> TelepresenceConsoleFilterProviderKt.suggestInstallTrafficManager$lambda$0(apiModel2, upgrade))).notify(apiModel2.getProject());
    }

    @NotNull
    public static final NotificationGroup getTelepresenceNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Telepresence.General");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    private static final void suggestInstallTrafficManager$lambda$0(KubernetesApiModel $apiModel, boolean $upgrade) {
        Intrinsics.checkNotNullParameter((Object)$apiModel, (String)"$apiModel");
        $apiModel.getTelepresenceModel$intellij_clouds_kubernetes().launchTrafficManagerInstallation($upgrade);
    }
}

