/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.kubernetes.view.navigation.KubernetesNamespacedResourceNavigationData;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.psi.PsiReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u0006R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/references/KubernetesResourceReference;", "Lcom/intellij/psi/PsiReference;", "resourceInfo", "Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "getResourceInfo", "()Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "ResourceInfo", "intellij.clouds.kubernetes"})
public interface KubernetesResourceReference
extends PsiReference {
    @Nullable
    public ResourceInfo getResourceInfo();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/references/KubernetesResourceReference$ResourceInfo;", "", "kind", "", "name", "namespace", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "fullName", "getFullName", "()Ljava/lang/String;", "getKind", "getName", "getNamespace", "serviceViewNavigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "getServiceViewNavigationData", "()Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "serviceViewNavigationData$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
    public static final class ResourceInfo {
        @NotNull
        private final String kind;
        @NotNull
        private final String name;
        @Nullable
        private final String namespace;
        @NotNull
        private final Lazy serviceViewNavigationData$delegate;

        public ResourceInfo(@NotNull String kind, @NotNull String name2, @Nullable String namespace) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.kind = kind;
            this.name = name2;
            this.namespace = namespace;
            this.serviceViewNavigationData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KubernetesNamespacedResourceNavigationData>(this){
                final /* synthetic */ ResourceInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final KubernetesNamespacedResourceNavigationData invoke() {
                    return new KubernetesNamespacedResourceNavigationData(this.this$0.getKind(), this.this$0.getNamespace(), this.this$0.getName());
                }
            }));
        }

        public /* synthetic */ ResourceInfo(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getKind() {
            return this.kind;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final KubernetesResourceNavigationData getServiceViewNavigationData() {
            Lazy lazy = this.serviceViewNavigationData$delegate;
            return (KubernetesResourceNavigationData)lazy.getValue();
        }

        @NotNull
        public final String getFullName() {
            return this.namespace != null ? this.name + " @ " + this.namespace : this.name;
        }

        @NotNull
        public final String component1() {
            return this.kind;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.namespace;
        }

        @NotNull
        public final ResourceInfo copy(@NotNull String kind, @NotNull String name2, @Nullable String namespace) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new ResourceInfo(kind, name2, namespace);
        }

        public static /* synthetic */ ResourceInfo copy$default(ResourceInfo resourceInfo2, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = resourceInfo2.kind;
            }
            if ((n & 2) != 0) {
                string2 = resourceInfo2.name;
            }
            if ((n & 4) != 0) {
                string3 = resourceInfo2.namespace;
            }
            return resourceInfo2.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ResourceInfo(kind=" + this.kind + ", name=" + this.name + ", namespace=" + this.namespace + ")";
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.namespace == null ? 0 : this.namespace.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceInfo)) {
                return false;
            }
            ResourceInfo resourceInfo2 = (ResourceInfo)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)resourceInfo2.kind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)resourceInfo2.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.namespace, (Object)resourceInfo2.namespace);
        }
    }
}

